"""
Unicode emoji data, synchronized semi-regularly with the server source
"""
# Ignore long lines
# ruff: noqa: E501

# fmt: off
# Generated automatically by tools/convert-unicode-emoji-data
# Do not modify.

EMOJI_DATA = {
    "+1": {'code': '1f44d', 'aliases': ['thumbs_up', 'like']},
    "-1": {'code': '1f44e', 'aliases': ['thumbs_down']},
    "100": {'code': '1f4af', 'aliases': ['hundred']},
    "1234": {'code': '1f522', 'aliases': ['numbers']},
    "a": {'code': '1f170', 'aliases': []},
    "ab": {'code': '1f18e', 'aliases': []},
    "abacus": {'code': '1f9ee', 'aliases': ['calculation']},
    "abc": {'code': '1f524', 'aliases': []},
    "abcd": {'code': '1f521', 'aliases': ['alphabet']},
    "accessible": {'code': '267f', 'aliases': ['wheelchair', 'disabled']},
    "accordion": {'code': '1fa97', 'aliases': ['concertina', 'squeeze_box']},
    "action": {'code': '1f3ac', 'aliases': []},
    "adhesive_bandage": {'code': '1fa79', 'aliases': ['bandage']},
    "aerial_tramway": {'code': '1f6a1', 'aliases': ['ski_lift']},
    "airplane": {'code': '2708', 'aliases': []},
    "alarm_clock": {'code': '23f0', 'aliases': []},
    "alchemy": {'code': '2697', 'aliases': ['alembic']},
    "alien": {'code': '1f47d', 'aliases': ['ufo']},
    "ambulance": {'code': '1f691', 'aliases': []},
    "american_football": {'code': '1f3c8', 'aliases': []},
    "anatomical_heart": {'code': '1fac0', 'aliases': ['anatomical', 'cardiology', 'pulse']},
    "anchor": {'code': '2693', 'aliases': []},
    "angel": {'code': '1f47c', 'aliases': []},
    "anger": {'code': '1f4a2', 'aliases': ['bam', 'pow']},
    "anger_bubble": {'code': '1f5ef', 'aliases': []},
    "angry": {'code': '1f620', 'aliases': []},
    "angry_cat": {'code': '1f63e', 'aliases': ['pouting_cat']},
    "anguish": {'code': '1f62b', 'aliases': []},
    "anguished": {'code': '1f627', 'aliases': ['pained']},
    "ant": {'code': '1f41c', 'aliases': []},
    "apple": {'code': '1f34e', 'aliases': []},
    "aquarius": {'code': '2652', 'aliases': []},
    "arabian_camel": {'code': '1f42a', 'aliases': []},
    "archive": {'code': '1f5c3', 'aliases': []},
    "aries": {'code': '2648', 'aliases': []},
    "art": {'code': '1f3a8', 'aliases': ['palette', 'painting']},
    "artist": {'code': '1f9d1-200d-1f3a8', 'aliases': []},
    "asterisk": {'code': '002a-20e3', 'aliases': []},
    "astonished": {'code': '1f632', 'aliases': []},
    "astronaut": {'code': '1f9d1-200d-1f680', 'aliases': []},
    "at_work": {'code': '2692', 'aliases': ['hammer_and_pick']},
    "athletic_shoe": {'code': '1f45f', 'aliases': ['sneaker', 'running_shoe']},
    "atm": {'code': '1f3e7', 'aliases': []},
    "atom": {'code': '269b', 'aliases': ['physics']},
    "auto_rickshaw": {'code': '1f6fa', 'aliases': ['tuk_tuk']},
    "avocado": {'code': '1f951', 'aliases': []},
    "axe": {'code': '1fa93', 'aliases': ['hatchet', 'split']},
    "b": {'code': '1f171', 'aliases': []},
    "baby": {'code': '1f476', 'aliases': []},
    "baby_bottle": {'code': '1f37c', 'aliases': []},
    "baby_change_station": {'code': '1f6bc', 'aliases': ['nursery']},
    "back": {'code': '1f519', 'aliases': []},
    "backpack": {'code': '1f392', 'aliases': ['satchel']},
    "bacon": {'code': '1f953', 'aliases': []},
    "badger": {'code': '1f9a1', 'aliases': ['honey_badger', 'pester']},
    "badminton": {'code': '1f3f8', 'aliases': []},
    "bagel": {'code': '1f96f', 'aliases': ['schmear']},
    "baggage_claim": {'code': '1f6c4', 'aliases': []},
    "baguette": {'code': '1f956', 'aliases': []},
    "ball": {'code': '26f9', 'aliases': ['sports']},
    "ballet_shoes": {'code': '1fa70', 'aliases': ['ballet']},
    "balloon": {'code': '1f388', 'aliases': ['celebration']},
    "ballot_box": {'code': '1f5f3', 'aliases': []},
    "bamboo": {'code': '1f38d', 'aliases': []},
    "banana": {'code': '1f34c', 'aliases': []},
    "bangbang": {'code': '203c', 'aliases': ['double_exclamation']},
    "banjo": {'code': '1fa95', 'aliases': ['stringed']},
    "bank": {'code': '1f3e6', 'aliases': []},
    "bar_chart": {'code': '1f4ca', 'aliases': []},
    "barber": {'code': '1f488', 'aliases': ['striped_pole']},
    "baseball": {'code': '26be', 'aliases': []},
    "basket": {'code': '1f9fa', 'aliases': ['farming', 'laundry', 'picnic']},
    "basketball": {'code': '1f3c0', 'aliases': []},
    "bat": {'code': '1f987', 'aliases': []},
    "bath": {'code': '1f6c0', 'aliases': []},
    "bathtub": {'code': '1f6c1', 'aliases': []},
    "battery": {'code': '1f50b', 'aliases': ['full_battery']},
    "beach": {'code': '1f3d6', 'aliases': []},
    "beach_umbrella": {'code': '26f1', 'aliases': []},
    "beans": {'code': '1fad8', 'aliases': ['kidney', 'legume']},
    "bear": {'code': '1f43b', 'aliases': []},
    "beaver": {'code': '1f9ab', 'aliases': ['dam']},
    "bed": {'code': '1f6cf', 'aliases': ['bedroom']},
    "bee": {'code': '1f41d', 'aliases': ['buzz', 'honeybee']},
    "beer": {'code': '1f37a', 'aliases': []},
    "beers": {'code': '1f37b', 'aliases': []},
    "beetle": {'code': '1fab2', 'aliases': []},
    "beginner": {'code': '1f530', 'aliases': []},
    "bell_pepper": {'code': '1fad1', 'aliases': ['capsicum', 'pepper', 'vegetable']},
    "bellhop_bell": {'code': '1f6ce', 'aliases': ['reception', 'services', 'ding']},
    "bento": {'code': '1f371', 'aliases': []},
    "beverage_box": {'code': '1f9c3', 'aliases': ['beverage', 'box', 'straw']},
    "big_smile": {'code': '1f604', 'aliases': []},
    "bike": {'code': '1f6b2', 'aliases': ['bicycle']},
    "bikini": {'code': '1f459', 'aliases': []},
    "billed_cap": {'code': '1f9e2', 'aliases': ['baseball_cap']},
    "billiards": {'code': '1f3b1', 'aliases': ['pool', '8_ball']},
    "biohazard": {'code': '2623', 'aliases': []},
    "bird": {'code': '1f426', 'aliases': []},
    "birthday": {'code': '1f382', 'aliases': []},
    "bison": {'code': '1f9ac', 'aliases': ['buffalo', 'herd', 'wisent']},
    "biting_lip": {'code': '1fae6', 'aliases': ['flirting', 'uncomfortable']},
    "black_and_white_square": {'code': '1f533', 'aliases': []},
    "black_belt": {'code': '1f94b', 'aliases': ['keikogi', 'dogi', 'martial_arts']},
    "black_cat": {'code': '1f408-200d-2b1b', 'aliases': ['black', 'unlucky']},
    "black_circle": {'code': '26ab', 'aliases': []},
    "black_flag": {'code': '1f3f4', 'aliases': []},
    "black_heart": {'code': '1f5a4', 'aliases': []},
    "black_large_square": {'code': '2b1b', 'aliases': []},
    "black_medium_small_square": {'code': '25fe', 'aliases': []},
    "black_medium_square": {'code': '25fc', 'aliases': []},
    "black_nib": {'code': '2712', 'aliases': ['nib']},
    "black_small_square": {'code': '25aa', 'aliases': []},
    "blossom": {'code': '1f33c', 'aliases': []},
    "blowfish": {'code': '1f421', 'aliases': []},
    "blue_book": {'code': '1f4d8', 'aliases': []},
    "blue_circle": {'code': '1f535', 'aliases': []},
    "blue_heart": {'code': '1f499', 'aliases': []},
    "blue_square": {'code': '1f7e6', 'aliases': []},
    "blueberries": {'code': '1fad0', 'aliases': ['berry', 'bilberry', 'blueberry']},
    "blush": {'code': '1f60a', 'aliases': []},
    "boar": {'code': '1f417', 'aliases': []},
    "boat": {'code': '26f5', 'aliases': ['sailboat']},
    "bomb": {'code': '1f4a3', 'aliases': []},
    "bone": {'code': '1f9b4', 'aliases': []},
    "book": {'code': '1f4d6', 'aliases': ['open_book']},
    "bookmark": {'code': '1f516', 'aliases': []},
    "books": {'code': '1f4da', 'aliases': []},
    "boom": {'code': '1f4a5', 'aliases': ['explosion', 'crash', 'collision']},
    "boomerang": {'code': '1fa83', 'aliases': ['rebound', 'repercussion']},
    "boot": {'code': '1f462', 'aliases': []},
    "bouquet": {'code': '1f490', 'aliases': []},
    "bow": {'code': '1f647', 'aliases': []},
    "bow_and_arrow": {'code': '1f3f9', 'aliases': ['archery']},
    "bowl_with_spoon": {'code': '1f963', 'aliases': ['cereal', 'congee']},
    "boxing_glove": {'code': '1f94a', 'aliases': []},
    "boy": {'code': '1f466', 'aliases': []},
    "brain": {'code': '1f9e0', 'aliases': ['intelligent']},
    "bread": {'code': '1f35e', 'aliases': []},
    "breast_feeding": {'code': '1f931', 'aliases': ['breast']},
    "brick": {'code': '1f9f1', 'aliases': ['bricks', 'clay', 'mortar', 'wall']},
    "bride": {'code': '1f470', 'aliases': []},
    "bridge": {'code': '1f309', 'aliases': []},
    "briefcase": {'code': '1f4bc', 'aliases': []},
    "briefs": {'code': '1fa72', 'aliases': ['one_piece', 'swimsuit']},
    "brightness": {'code': '1f506', 'aliases': ['high_brightness']},
    "broccoli": {'code': '1f966', 'aliases': ['wild_cabbage']},
    "broken_heart": {'code': '1f494', 'aliases': ['heartache']},
    "broom": {'code': '1f9f9', 'aliases': ['sweeping']},
    "brown_circle": {'code': '1f7e4', 'aliases': []},
    "brown_heart": {'code': '1f90e', 'aliases': []},
    "brown_square": {'code': '1f7eb', 'aliases': []},
    "bubble_tea": {'code': '1f9cb', 'aliases': []},
    "bubbles": {'code': '1fae7', 'aliases': ['burp', 'underwater']},
    "bucket": {'code': '1faa3', 'aliases': ['cask', 'pail', 'vat']},
    "bug": {'code': '1f41b', 'aliases': ['caterpillar']},
    "bullet_train": {'code': '1f685', 'aliases': []},
    "bunny": {'code': '1f430', 'aliases': []},
    "burrito": {'code': '1f32f', 'aliases': []},
    "bus": {'code': '1f68c', 'aliases': ['school_bus']},
    "bus_stop": {'code': '1f68f', 'aliases': []},
    "butter": {'code': '1f9c8', 'aliases': ['dairy']},
    "butterfly": {'code': '1f98b', 'aliases': []},
    "cactus": {'code': '1f335', 'aliases': []},
    "cake": {'code': '1f370', 'aliases': []},
    "calendar": {'code': '1f4c5', 'aliases': []},
    "calf": {'code': '1f42e', 'aliases': []},
    "call_me": {'code': '1f919', 'aliases': []},
    "calling": {'code': '1f4f2', 'aliases': []},
    "camel": {'code': '1f42b', 'aliases': []},
    "camera": {'code': '1f4f7', 'aliases': []},
    "campsite": {'code': '1f3d5', 'aliases': []},
    "cancer": {'code': '264b', 'aliases': []},
    "candle": {'code': '1f56f', 'aliases': []},
    "candy": {'code': '1f36c', 'aliases': []},
    "canned_food": {'code': '1f96b', 'aliases': ['can']},
    "canoe": {'code': '1f6f6', 'aliases': []},
    "capital_abcd": {'code': '1f520', 'aliases': ['capital_letters']},
    "capricorn": {'code': '2651', 'aliases': []},
    "car": {'code': '1f697', 'aliases': []},
    "carousel": {'code': '1f3a0', 'aliases': ['merry_go_round']},
    "carp_streamer": {'code': '1f38f', 'aliases': ['flags']},
    "carpenter_square": {'code': '1f4d0', 'aliases': ['triangular_ruler']},
    "carpentry_saw": {'code': '1fa9a', 'aliases': ['carpenter', 'saw']},
    "carrot": {'code': '1f955', 'aliases': []},
    "cartwheel": {'code': '1f938', 'aliases': ['acrobatics', 'gymnastics', 'tumbling']},
    "castle": {'code': '1f3f0', 'aliases': []},
    "cat": {'code': '1f408', 'aliases': ['meow']},
    "cd": {'code': '1f4bf', 'aliases': []},
    "cell_reception": {'code': '1f4f6', 'aliases': ['signal_strength', 'signal_bars']},
    "chains": {'code': '26d3', 'aliases': []},
    "chair": {'code': '1fa91', 'aliases': ['sit']},
    "champagne": {'code': '1f37e', 'aliases': []},
    "chart": {'code': '1f4c8', 'aliases': ['upwards_trend', 'growing', 'increasing']},
    "check": {'code': '2705', 'aliases': ['all_good', 'approved']},
    "check_mark": {'code': '2714', 'aliases': []},
    "checkbox": {'code': '2611', 'aliases': []},
    "checkered_flag": {'code': '1f3c1', 'aliases': ['race', 'go', 'start']},
    "cheese": {'code': '1f9c0', 'aliases': []},
    "cherries": {'code': '1f352', 'aliases': []},
    "cherry_blossom": {'code': '1f338', 'aliases': []},
    "chess_pawn": {'code': '265f', 'aliases': ['chess', 'dupe', 'expendable']},
    "chestnut": {'code': '1f330', 'aliases': []},
    "chick": {'code': '1f424', 'aliases': ['baby_chick']},
    "chicken": {'code': '1f414', 'aliases': ['cluck']},
    "child": {'code': '1f9d2', 'aliases': ['young']},
    "children_crossing": {'code': '1f6b8', 'aliases': ['school_crossing', 'drive_with_care']},
    "chipmunk": {'code': '1f43f', 'aliases': []},
    "chocolate": {'code': '1f36b', 'aliases': []},
    "chopsticks": {'code': '1f962', 'aliases': ['hashi']},
    "church": {'code': '26ea', 'aliases': []},
    "cinema": {'code': '1f3a6', 'aliases': ['movie_theater']},
    "circle": {'code': '2b55', 'aliases': []},
    "circus": {'code': '1f3aa', 'aliases': []},
    "city": {'code': '1f3d9', 'aliases': ['skyline']},
    "city_sunrise": {'code': '1f307', 'aliases': []},
    "cl": {'code': '1f191', 'aliases': []},
    "clap": {'code': '1f44f', 'aliases': ['applause']},
    "classical_building": {'code': '1f3db', 'aliases': []},
    "clink": {'code': '1f942', 'aliases': ['toast']},
    "clipboard": {'code': '1f4cb', 'aliases': []},
    "clockwise": {'code': '1f503', 'aliases': []},
    "closed_mailbox": {'code': '1f4ea', 'aliases': []},
    "closed_umbrella": {'code': '1f302', 'aliases': []},
    "clothing": {'code': '1f45a', 'aliases': []},
    "cloud": {'code': '2601', 'aliases': ['overcast']},
    "cloudy": {'code': '1f325', 'aliases': []},
    "clown": {'code': '1f921', 'aliases': []},
    "clubs": {'code': '2663', 'aliases': []},
    "coat": {'code': '1f9e5', 'aliases': ['jacket']},
    "cockroach": {'code': '1fab3', 'aliases': ['roach']},
    "cocktail": {'code': '1f378', 'aliases': []},
    "coconut": {'code': '1f965', 'aliases': ['piña_colada', 'pina_colada']},
    "coffee": {'code': '2615', 'aliases': []},
    "coffin": {'code': '26b0', 'aliases': ['burial', 'grave']},
    "coin": {'code': '1fa99', 'aliases': ['metal']},
    "cold_face": {'code': '1f976', 'aliases': ['blue_faced', 'freezing', 'frostbite', 'icicles']},
    "cold_sweat": {'code': '1f630', 'aliases': []},
    "comet": {'code': '2604', 'aliases': ['meteor']},
    "compass": {'code': '1f9ed', 'aliases': ['navigation', 'orienteering']},
    "compression": {'code': '1f5dc', 'aliases': ['vise']},
    "computer": {'code': '1f4bb', 'aliases': ['laptop']},
    "computer_mouse": {'code': '1f5b1', 'aliases': []},
    "confetti": {'code': '1f38a', 'aliases': ['party_ball']},
    "confounded": {'code': '1f616', 'aliases': ['agony']},
    "construction": {'code': '1f3d7', 'aliases': []},
    "construction_worker": {'code': '1f477', 'aliases': []},
    "control_knobs": {'code': '1f39b', 'aliases': []},
    "convenience_store": {'code': '1f3ea', 'aliases': []},
    "cook": {'code': '1f9d1-200d-1f373', 'aliases': []},
    "cookie": {'code': '1f36a', 'aliases': []},
    "cooking": {'code': '1f373', 'aliases': []},
    "cool": {'code': '1f192', 'aliases': []},
    "copyright": {'code': '00a9', 'aliases': ['c']},
    "coral": {'code': '1fab8', 'aliases': ['reef']},
    "corn": {'code': '1f33d', 'aliases': ['maize']},
    "counterclockwise": {'code': '1f504', 'aliases': ['return']},
    "couple_with_heart": {'code': '1f491', 'aliases': []},
    "couple_with_heart_man_man": {'code': '1f468-200d-2764-200d-1f468', 'aliases': []},
    "couple_with_heart_woman_man": {'code': '1f469-200d-2764-200d-1f468', 'aliases': []},
    "couple_with_heart_woman_woman": {'code': '1f469-200d-2764-200d-1f469', 'aliases': []},
    "cow": {'code': '1f404', 'aliases': []},
    "cowboy": {'code': '1f920', 'aliases': []},
    "crab": {'code': '1f980', 'aliases': []},
    "crayon": {'code': '1f58d', 'aliases': []},
    "credit_card": {'code': '1f4b3', 'aliases': ['debit_card']},
    "cricket": {'code': '1f997', 'aliases': ['grasshopper']},
    "cricket_game": {'code': '1f3cf', 'aliases': []},
    "crocodile": {'code': '1f40a', 'aliases': []},
    "croissant": {'code': '1f950', 'aliases': []},
    "cross": {'code': '271d', 'aliases': ['christianity']},
    "cross_mark": {'code': '274c', 'aliases': ['incorrect', 'wrong']},
    "crossed_flags": {'code': '1f38c', 'aliases': ['solidarity']},
    "crown": {'code': '1f451', 'aliases': ['queen', 'king']},
    "crutch": {'code': '1fa7c', 'aliases': ['cane', 'disability', 'mobility_aid']},
    "cry": {'code': '1f622', 'aliases': []},
    "crying_cat": {'code': '1f63f', 'aliases': []},
    "crystal_ball": {'code': '1f52e', 'aliases': ['oracle', 'future', 'fortune_telling']},
    "cucumber": {'code': '1f952', 'aliases': []},
    "cup_with_straw": {'code': '1f964', 'aliases': ['soda']},
    "cupcake": {'code': '1f9c1', 'aliases': []},
    "cupid": {'code': '1f498', 'aliases': ['smitten', 'heart_arrow']},
    "curling_stone": {'code': '1f94c', 'aliases': []},
    "curry": {'code': '1f35b', 'aliases': []},
    "custard": {'code': '1f36e', 'aliases': ['flan']},
    "customs": {'code': '1f6c3', 'aliases': []},
    "cut_of_meat": {'code': '1f969', 'aliases': ['lambchop', 'porkchop', 'steak']},
    "cute": {'code': '1f4a0', 'aliases': ['kawaii', 'diamond_with_a_dot']},
    "cyclist": {'code': '1f6b4', 'aliases': []},
    "cyclone": {'code': '1f300', 'aliases': ['hurricane', 'typhoon']},
    "dagger": {'code': '1f5e1', 'aliases': ['rated_for_violence']},
    "dancer": {'code': '1f483', 'aliases': []},
    "dancers": {'code': '1f46f', 'aliases': []},
    "dancing": {'code': '1f57a', 'aliases': ['disco']},
    "dango": {'code': '1f361', 'aliases': []},
    "dark_sunglasses": {'code': '1f576', 'aliases': []},
    "dash": {'code': '1f4a8', 'aliases': []},
    "date": {'code': '1f4c6', 'aliases': []},
    "deaf_man": {'code': '1f9cf-200d-2642', 'aliases': []},
    "deaf_person": {'code': '1f9cf', 'aliases': ['hear']},
    "deaf_woman": {'code': '1f9cf-200d-2640', 'aliases': []},
    "decorative_notebook": {'code': '1f4d4', 'aliases': []},
    "deer": {'code': '1f98c', 'aliases': []},
    "department_store": {'code': '1f3ec', 'aliases': []},
    "derelict_house": {'code': '1f3da', 'aliases': ['condemned']},
    "desert": {'code': '1f3dc', 'aliases': []},
    "desktop_computer": {'code': '1f5a5', 'aliases': []},
    "detective": {'code': '1f575', 'aliases': ['spy', 'sleuth', 'agent', 'sneaky']},
    "devil": {'code': '1f47f', 'aliases': ['imp', 'angry_devil']},
    "diamonds": {'code': '2666', 'aliases': []},
    "dice": {'code': '1f3b2', 'aliases': ['die']},
    "direct_hit": {'code': '1f3af', 'aliases': ['darts', 'bulls_eye']},
    "disappointed": {'code': '1f61e', 'aliases': []},
    "disguised_face": {'code': '1f978', 'aliases': ['disguise', 'incognito']},
    "diving_mask": {'code': '1f93f', 'aliases': ['scuba', 'snorkeling']},
    "division": {'code': '2797', 'aliases': ['divide']},
    "diya_lamp": {'code': '1fa94', 'aliases': ['diya', 'lamp', 'oil']},
    "dizzy": {'code': '1f635', 'aliases': []},
    "dna": {'code': '1f9ec', 'aliases': ['evolution', 'gene', 'genetics', 'life']},
    "do_not_litter": {'code': '1f6af', 'aliases': []},
    "document": {'code': '1f4c4', 'aliases': ['paper', 'file', 'page']},
    "dodo": {'code': '1f9a4', 'aliases': ['mauritius']},
    "dog": {'code': '1f415', 'aliases': ['woof']},
    "dollar_bills": {'code': '1f4b5', 'aliases': []},
    "dollars": {'code': '1f4b2', 'aliases': []},
    "dolls": {'code': '1f38e', 'aliases': []},
    "dolphin": {'code': '1f42c', 'aliases': ['flipper']},
    "doner_kebab": {'code': '1f959', 'aliases': ['shawarma', 'souvlaki', 'stuffed_flatbread']},
    "donut": {'code': '1f369', 'aliases': ['doughnut']},
    "door": {'code': '1f6aa', 'aliases': []},
    "dormouse": {'code': '1f42d', 'aliases': []},
    "dotted_line_face": {'code': '1fae5', 'aliases': ['depressed', 'hide', 'introvert', 'invisible']},
    "dotted_six_pointed_star": {'code': '1f52f', 'aliases': ['fortune']},
    "double_down": {'code': '23ec', 'aliases': ['fast_down']},
    "double_loop": {'code': '27bf', 'aliases': ['voicemail']},
    "double_up": {'code': '23eb', 'aliases': ['fast_up']},
    "dove": {'code': '1f54a', 'aliases': ['dove_of_peace']},
    "down": {'code': '2b07', 'aliases': ['south']},
    "downvote": {'code': '1f53d', 'aliases': ['down_button', 'decrease']},
    "downwards_trend": {'code': '1f4c9', 'aliases': ['shrinking', 'decreasing']},
    "dragon": {'code': '1f409', 'aliases': []},
    "dragon_face": {'code': '1f432', 'aliases': []},
    "dress": {'code': '1f457', 'aliases': []},
    "drooling": {'code': '1f924', 'aliases': []},
    "drop": {'code': '1f4a7', 'aliases': ['water_drop']},
    "drop_of_blood": {'code': '1fa78', 'aliases': ['bleed', 'blood_donation', 'injury', 'menstruation']},
    "drum": {'code': '1f941', 'aliases': []},
    "drumstick": {'code': '1f357', 'aliases': ['poultry']},
    "duck": {'code': '1f986', 'aliases': []},
    "duel": {'code': '2694', 'aliases': ['swords']},
    "dumpling": {'code': '1f95f', 'aliases': ['empanada', 'gyōza', 'jiaozi', 'pierogi', 'potsticker', 'gyoza']},
    "dvd": {'code': '1f4c0', 'aliases': []},
    "e-mail": {'code': '1f4e7', 'aliases': []},
    "eagle": {'code': '1f985', 'aliases': []},
    "ear": {'code': '1f442', 'aliases': []},
    "ear_with_hearing_aid": {'code': '1f9bb', 'aliases': ['hard_of_hearing']},
    "earth_africa": {'code': '1f30d', 'aliases': []},
    "earth_americas": {'code': '1f30e', 'aliases': []},
    "earth_asia": {'code': '1f30f', 'aliases': []},
    "egg": {'code': '1f95a', 'aliases': []},
    "eggplant": {'code': '1f346', 'aliases': []},
    "eight": {'code': '0038-20e3', 'aliases': []},
    "eight_pointed_star": {'code': '2734', 'aliases': []},
    "eight_spoked_asterisk": {'code': '2733', 'aliases': []},
    "eject_button": {'code': '23cf', 'aliases': ['eject']},
    "electric_plug": {'code': '1f50c', 'aliases': []},
    "elephant": {'code': '1f418', 'aliases': []},
    "elevator": {'code': '1f6d7', 'aliases': ['hoist']},
    "elf": {'code': '1f9dd', 'aliases': []},
    "email": {'code': '2709', 'aliases': ['envelope', 'mail']},
    "empty_nest": {'code': '1fab9', 'aliases': []},
    "end": {'code': '1f51a', 'aliases': []},
    "euro_banknotes": {'code': '1f4b6', 'aliases': []},
    "evergreen_tree": {'code': '1f332', 'aliases': []},
    "exchange": {'code': '1f4b1', 'aliases': []},
    "exclamation": {'code': '2757', 'aliases': []},
    "exhausted": {'code': '1f625', 'aliases': ['disappointed_relieved', 'stressed']},
    "exploding_head": {'code': '1f92f', 'aliases': ['mind_blown', 'shocked']},
    "expressionless": {'code': '1f611', 'aliases': []},
    "eye": {'code': '1f441', 'aliases': []},
    "eye_in_speech_bubble": {'code': '1f441-fe0f-200d-1f5e8-fe0f', 'aliases': ['speech', 'witness']},
    "eyes": {'code': '1f440', 'aliases': ['looking']},
    "face_exhaling": {'code': '1f62e-200d-1f4a8', 'aliases': ['exhale', 'gasp', 'groan', 'relief', 'whisper', 'whistle']},
    "face_holding_back_tears": {'code': '1f979', 'aliases': ['resist']},
    "face_in_clouds": {'code': '1f636-200d-1f32b', 'aliases': ['absentminded', 'face_in_the_fog', 'head_in_clouds']},
    "face_palm": {'code': '1f926', 'aliases': []},
    "face_vomiting": {'code': '1f92e', 'aliases': ['puke', 'vomit']},
    "face_with_diagonal_mouth": {'code': '1fae4', 'aliases': ['meh', 'skeptical', 'unsure']},
    "face_with_hand_over_mouth": {'code': '1f92d', 'aliases': ['whoops']},
    "face_with_monocle": {'code': '1f9d0', 'aliases': ['monocle', 'stuffy']},
    "face_with_open_eyes_and_hand_over_mouth": {'code': '1fae2', 'aliases': ['amazement', 'awe', 'embarrass']},
    "face_with_peeking_eye": {'code': '1fae3', 'aliases': ['captivated', 'peep', 'stare']},
    "face_with_raised_eyebrow": {'code': '1f928', 'aliases': ['distrust', 'skeptic']},
    "face_with_spiral_eyes": {'code': '1f635-200d-1f4ab', 'aliases': ['hypnotized', 'trouble', 'whoa']},
    "face_with_symbols_on_mouth": {'code': '1f92c', 'aliases': ['swearing']},
    "factory": {'code': '1f3ed', 'aliases': []},
    "factory_worker": {'code': '1f9d1-200d-1f3ed', 'aliases': []},
    "fairy": {'code': '1f9da', 'aliases': []},
    "falafel": {'code': '1f9c6', 'aliases': ['chickpea', 'meatball']},
    "fallen_leaf": {'code': '1f342', 'aliases': []},
    "family": {'code': '1f46a', 'aliases': []},
    "family_man_boy": {'code': '1f468-200d-1f466', 'aliases': []},
    "family_man_boy_boy": {'code': '1f468-200d-1f466-200d-1f466', 'aliases': []},
    "family_man_girl": {'code': '1f468-200d-1f467', 'aliases': []},
    "family_man_girl_boy": {'code': '1f468-200d-1f467-200d-1f466', 'aliases': []},
    "family_man_girl_girl": {'code': '1f468-200d-1f467-200d-1f467', 'aliases': []},
    "family_man_man_boy": {'code': '1f468-200d-1f468-200d-1f466', 'aliases': []},
    "family_man_man_boy_boy": {'code': '1f468-200d-1f468-200d-1f466-200d-1f466', 'aliases': []},
    "family_man_man_girl": {'code': '1f468-200d-1f468-200d-1f467', 'aliases': []},
    "family_man_man_girl_boy": {'code': '1f468-200d-1f468-200d-1f467-200d-1f466', 'aliases': []},
    "family_man_man_girl_girl": {'code': '1f468-200d-1f468-200d-1f467-200d-1f467', 'aliases': []},
    "family_man_woman_boy": {'code': '1f468-200d-1f469-200d-1f466', 'aliases': []},
    "family_man_woman_boy_boy": {'code': '1f468-200d-1f469-200d-1f466-200d-1f466', 'aliases': []},
    "family_man_woman_girl": {'code': '1f468-200d-1f469-200d-1f467', 'aliases': []},
    "family_man_woman_girl_boy": {'code': '1f468-200d-1f469-200d-1f467-200d-1f466', 'aliases': []},
    "family_man_woman_girl_girl": {'code': '1f468-200d-1f469-200d-1f467-200d-1f467', 'aliases': []},
    "family_woman_boy": {'code': '1f469-200d-1f466', 'aliases': []},
    "family_woman_boy_boy": {'code': '1f469-200d-1f466-200d-1f466', 'aliases': []},
    "family_woman_girl": {'code': '1f469-200d-1f467', 'aliases': []},
    "family_woman_girl_boy": {'code': '1f469-200d-1f467-200d-1f466', 'aliases': []},
    "family_woman_girl_girl": {'code': '1f469-200d-1f467-200d-1f467', 'aliases': []},
    "family_woman_woman_boy": {'code': '1f469-200d-1f469-200d-1f466', 'aliases': []},
    "family_woman_woman_boy_boy": {'code': '1f469-200d-1f469-200d-1f466-200d-1f466', 'aliases': []},
    "family_woman_woman_girl": {'code': '1f469-200d-1f469-200d-1f467', 'aliases': []},
    "family_woman_woman_girl_boy": {'code': '1f469-200d-1f469-200d-1f467-200d-1f466', 'aliases': []},
    "family_woman_woman_girl_girl": {'code': '1f469-200d-1f469-200d-1f467-200d-1f467', 'aliases': []},
    "farmer": {'code': '1f9d1-200d-1f33e', 'aliases': []},
    "fast_forward": {'code': '23e9', 'aliases': []},
    "fax": {'code': '1f4e0', 'aliases': []},
    "fear": {'code': '1f628', 'aliases': ['scared', 'shock']},
    "feather": {'code': '1fab6', 'aliases': ['flight', 'light', 'plumage']},
    "female_sign": {'code': '2640', 'aliases': []},
    "fencing": {'code': '1f93a', 'aliases': []},
    "ferris_wheel": {'code': '1f3a1', 'aliases': []},
    "ferry": {'code': '26f4', 'aliases': []},
    "field_hockey": {'code': '1f3d1', 'aliases': []},
    "file_cabinet": {'code': '1f5c4', 'aliases': []},
    "film": {'code': '1f39e', 'aliases': []},
    "fingers_crossed": {'code': '1f91e', 'aliases': []},
    "fire": {'code': '1f525', 'aliases': ['lit', 'hot', 'flame']},
    "fire_extinguisher": {'code': '1f9ef', 'aliases': ['extinguish', 'quench']},
    "fire_truck": {'code': '1f692', 'aliases': ['fire_engine']},
    "firecracker": {'code': '1f9e8', 'aliases': ['dynamite', 'explosive']},
    "firefighter": {'code': '1f9d1-200d-1f692', 'aliases': []},
    "fireworks": {'code': '1f386', 'aliases': []},
    "first_place": {'code': '1f947', 'aliases': ['gold', 'number_one']},
    "first_quarter_moon": {'code': '1f313', 'aliases': []},
    "fish": {'code': '1f41f', 'aliases': []},
    "fishing": {'code': '1f3a3', 'aliases': []},
    "fist": {'code': '270a', 'aliases': ['power']},
    "fist_bump": {'code': '1f44a', 'aliases': ['punch']},
    "five": {'code': '0035-20e3', 'aliases': []},
    "fixing": {'code': '1f527', 'aliases': ['wrench']},
    "flag_afghanistan": {'code': '1f1e6-1f1eb', 'aliases': []},
    "flag_albania": {'code': '1f1e6-1f1f1', 'aliases': []},
    "flag_algeria": {'code': '1f1e9-1f1ff', 'aliases': []},
    "flag_american_samoa": {'code': '1f1e6-1f1f8', 'aliases': []},
    "flag_andorra": {'code': '1f1e6-1f1e9', 'aliases': []},
    "flag_angola": {'code': '1f1e6-1f1f4', 'aliases': []},
    "flag_anguilla": {'code': '1f1e6-1f1ee', 'aliases': []},
    "flag_antarctica": {'code': '1f1e6-1f1f6', 'aliases': []},
    "flag_antigua_and_barbuda": {'code': '1f1e6-1f1ec', 'aliases': []},
    "flag_argentina": {'code': '1f1e6-1f1f7', 'aliases': []},
    "flag_armenia": {'code': '1f1e6-1f1f2', 'aliases': []},
    "flag_aruba": {'code': '1f1e6-1f1fc', 'aliases': []},
    "flag_ascension_island": {'code': '1f1e6-1f1e8', 'aliases': []},
    "flag_australia": {'code': '1f1e6-1f1fa', 'aliases': []},
    "flag_austria": {'code': '1f1e6-1f1f9', 'aliases': []},
    "flag_azerbaijan": {'code': '1f1e6-1f1ff', 'aliases': []},
    "flag_bahamas": {'code': '1f1e7-1f1f8', 'aliases': []},
    "flag_bahrain": {'code': '1f1e7-1f1ed', 'aliases': []},
    "flag_bangladesh": {'code': '1f1e7-1f1e9', 'aliases': []},
    "flag_barbados": {'code': '1f1e7-1f1e7', 'aliases': []},
    "flag_belarus": {'code': '1f1e7-1f1fe', 'aliases': []},
    "flag_belgium": {'code': '1f1e7-1f1ea', 'aliases': []},
    "flag_belize": {'code': '1f1e7-1f1ff', 'aliases': []},
    "flag_benin": {'code': '1f1e7-1f1ef', 'aliases': []},
    "flag_bermuda": {'code': '1f1e7-1f1f2', 'aliases': []},
    "flag_bhutan": {'code': '1f1e7-1f1f9', 'aliases': []},
    "flag_bolivia": {'code': '1f1e7-1f1f4', 'aliases': []},
    "flag_bosnia_and_herzegovina": {'code': '1f1e7-1f1e6', 'aliases': []},
    "flag_botswana": {'code': '1f1e7-1f1fc', 'aliases': []},
    "flag_bouvet_island": {'code': '1f1e7-1f1fb', 'aliases': []},
    "flag_brazil": {'code': '1f1e7-1f1f7', 'aliases': []},
    "flag_british_indian_ocean_territory": {'code': '1f1ee-1f1f4', 'aliases': []},
    "flag_british_virgin_islands": {'code': '1f1fb-1f1ec', 'aliases': []},
    "flag_brunei": {'code': '1f1e7-1f1f3', 'aliases': []},
    "flag_bulgaria": {'code': '1f1e7-1f1ec', 'aliases': []},
    "flag_burkina_faso": {'code': '1f1e7-1f1eb', 'aliases': []},
    "flag_burundi": {'code': '1f1e7-1f1ee', 'aliases': []},
    "flag_cambodia": {'code': '1f1f0-1f1ed', 'aliases': []},
    "flag_cameroon": {'code': '1f1e8-1f1f2', 'aliases': []},
    "flag_canada": {'code': '1f1e8-1f1e6', 'aliases': []},
    "flag_canary_islands": {'code': '1f1ee-1f1e8', 'aliases': []},
    "flag_cape_verde": {'code': '1f1e8-1f1fb', 'aliases': []},
    "flag_caribbean_netherlands": {'code': '1f1e7-1f1f6', 'aliases': []},
    "flag_cayman_islands": {'code': '1f1f0-1f1fe', 'aliases': []},
    "flag_central_african_republic": {'code': '1f1e8-1f1eb', 'aliases': []},
    "flag_ceuta_and_melilla": {'code': '1f1ea-1f1e6', 'aliases': []},
    "flag_chad": {'code': '1f1f9-1f1e9', 'aliases': []},
    "flag_chile": {'code': '1f1e8-1f1f1', 'aliases': []},
    "flag_china": {'code': '1f1e8-1f1f3', 'aliases': []},
    "flag_christmas_island": {'code': '1f1e8-1f1fd', 'aliases': []},
    "flag_clipperton_island": {'code': '1f1e8-1f1f5', 'aliases': []},
    "flag_cocos_keeling_islands": {'code': '1f1e8-1f1e8', 'aliases': []},
    "flag_colombia": {'code': '1f1e8-1f1f4', 'aliases': []},
    "flag_comoros": {'code': '1f1f0-1f1f2', 'aliases': []},
    "flag_congo_brazzaville": {'code': '1f1e8-1f1ec', 'aliases': []},
    "flag_congo_kinshasa": {'code': '1f1e8-1f1e9', 'aliases': []},
    "flag_cook_islands": {'code': '1f1e8-1f1f0', 'aliases': []},
    "flag_costa_rica": {'code': '1f1e8-1f1f7', 'aliases': []},
    "flag_croatia": {'code': '1f1ed-1f1f7', 'aliases': []},
    "flag_cuba": {'code': '1f1e8-1f1fa', 'aliases': []},
    "flag_curaçao": {'code': '1f1e8-1f1fc', 'aliases': ['flag_curacao']},
    "flag_cyprus": {'code': '1f1e8-1f1fe', 'aliases': []},
    "flag_czechia": {'code': '1f1e8-1f1ff', 'aliases': []},
    "flag_côte_divoire": {'code': '1f1e8-1f1ee', 'aliases': ['flag_cote_divoire']},
    "flag_denmark": {'code': '1f1e9-1f1f0', 'aliases': []},
    "flag_diego_garcia": {'code': '1f1e9-1f1ec', 'aliases': []},
    "flag_djibouti": {'code': '1f1e9-1f1ef', 'aliases': []},
    "flag_dominica": {'code': '1f1e9-1f1f2', 'aliases': []},
    "flag_dominican_republic": {'code': '1f1e9-1f1f4', 'aliases': []},
    "flag_ecuador": {'code': '1f1ea-1f1e8', 'aliases': []},
    "flag_egypt": {'code': '1f1ea-1f1ec', 'aliases': []},
    "flag_el_salvador": {'code': '1f1f8-1f1fb', 'aliases': []},
    "flag_england": {'code': '1f3f4-e0067-e0062-e0065-e006e-e0067-e007f', 'aliases': []},
    "flag_equatorial_guinea": {'code': '1f1ec-1f1f6', 'aliases': []},
    "flag_eritrea": {'code': '1f1ea-1f1f7', 'aliases': []},
    "flag_estonia": {'code': '1f1ea-1f1ea', 'aliases': []},
    "flag_eswatini": {'code': '1f1f8-1f1ff', 'aliases': []},
    "flag_ethiopia": {'code': '1f1ea-1f1f9', 'aliases': []},
    "flag_european_union": {'code': '1f1ea-1f1fa', 'aliases': []},
    "flag_falkland_islands": {'code': '1f1eb-1f1f0', 'aliases': []},
    "flag_faroe_islands": {'code': '1f1eb-1f1f4', 'aliases': []},
    "flag_fiji": {'code': '1f1eb-1f1ef', 'aliases': []},
    "flag_finland": {'code': '1f1eb-1f1ee', 'aliases': []},
    "flag_france": {'code': '1f1eb-1f1f7', 'aliases': []},
    "flag_french_guiana": {'code': '1f1ec-1f1eb', 'aliases': []},
    "flag_french_polynesia": {'code': '1f1f5-1f1eb', 'aliases': []},
    "flag_french_southern_territories": {'code': '1f1f9-1f1eb', 'aliases': []},
    "flag_gabon": {'code': '1f1ec-1f1e6', 'aliases': []},
    "flag_gambia": {'code': '1f1ec-1f1f2', 'aliases': []},
    "flag_georgia": {'code': '1f1ec-1f1ea', 'aliases': []},
    "flag_germany": {'code': '1f1e9-1f1ea', 'aliases': []},
    "flag_ghana": {'code': '1f1ec-1f1ed', 'aliases': []},
    "flag_gibraltar": {'code': '1f1ec-1f1ee', 'aliases': []},
    "flag_greece": {'code': '1f1ec-1f1f7', 'aliases': []},
    "flag_greenland": {'code': '1f1ec-1f1f1', 'aliases': []},
    "flag_grenada": {'code': '1f1ec-1f1e9', 'aliases': []},
    "flag_guadeloupe": {'code': '1f1ec-1f1f5', 'aliases': []},
    "flag_guam": {'code': '1f1ec-1f1fa', 'aliases': []},
    "flag_guatemala": {'code': '1f1ec-1f1f9', 'aliases': []},
    "flag_guernsey": {'code': '1f1ec-1f1ec', 'aliases': []},
    "flag_guinea": {'code': '1f1ec-1f1f3', 'aliases': []},
    "flag_guinea_bissau": {'code': '1f1ec-1f1fc', 'aliases': []},
    "flag_guyana": {'code': '1f1ec-1f1fe', 'aliases': []},
    "flag_haiti": {'code': '1f1ed-1f1f9', 'aliases': []},
    "flag_heard_and_mcdonald_islands": {'code': '1f1ed-1f1f2', 'aliases': []},
    "flag_honduras": {'code': '1f1ed-1f1f3', 'aliases': []},
    "flag_hong_kong_sar_china": {'code': '1f1ed-1f1f0', 'aliases': []},
    "flag_hungary": {'code': '1f1ed-1f1fa', 'aliases': []},
    "flag_iceland": {'code': '1f1ee-1f1f8', 'aliases': []},
    "flag_india": {'code': '1f1ee-1f1f3', 'aliases': []},
    "flag_indonesia": {'code': '1f1ee-1f1e9', 'aliases': []},
    "flag_iran": {'code': '1f1ee-1f1f7', 'aliases': []},
    "flag_iraq": {'code': '1f1ee-1f1f6', 'aliases': []},
    "flag_ireland": {'code': '1f1ee-1f1ea', 'aliases': []},
    "flag_isle_of_man": {'code': '1f1ee-1f1f2', 'aliases': []},
    "flag_israel": {'code': '1f1ee-1f1f1', 'aliases': []},
    "flag_italy": {'code': '1f1ee-1f1f9', 'aliases': []},
    "flag_jamaica": {'code': '1f1ef-1f1f2', 'aliases': []},
    "flag_japan": {'code': '1f1ef-1f1f5', 'aliases': []},
    "flag_jersey": {'code': '1f1ef-1f1ea', 'aliases': []},
    "flag_jordan": {'code': '1f1ef-1f1f4', 'aliases': []},
    "flag_kazakhstan": {'code': '1f1f0-1f1ff', 'aliases': []},
    "flag_kenya": {'code': '1f1f0-1f1ea', 'aliases': []},
    "flag_kiribati": {'code': '1f1f0-1f1ee', 'aliases': []},
    "flag_kosovo": {'code': '1f1fd-1f1f0', 'aliases': []},
    "flag_kuwait": {'code': '1f1f0-1f1fc', 'aliases': []},
    "flag_kyrgyzstan": {'code': '1f1f0-1f1ec', 'aliases': []},
    "flag_laos": {'code': '1f1f1-1f1e6', 'aliases': []},
    "flag_latvia": {'code': '1f1f1-1f1fb', 'aliases': []},
    "flag_lebanon": {'code': '1f1f1-1f1e7', 'aliases': []},
    "flag_lesotho": {'code': '1f1f1-1f1f8', 'aliases': []},
    "flag_liberia": {'code': '1f1f1-1f1f7', 'aliases': []},
    "flag_libya": {'code': '1f1f1-1f1fe', 'aliases': []},
    "flag_liechtenstein": {'code': '1f1f1-1f1ee', 'aliases': []},
    "flag_lithuania": {'code': '1f1f1-1f1f9', 'aliases': []},
    "flag_luxembourg": {'code': '1f1f1-1f1fa', 'aliases': []},
    "flag_macao_sar_china": {'code': '1f1f2-1f1f4', 'aliases': []},
    "flag_madagascar": {'code': '1f1f2-1f1ec', 'aliases': []},
    "flag_malawi": {'code': '1f1f2-1f1fc', 'aliases': []},
    "flag_malaysia": {'code': '1f1f2-1f1fe', 'aliases': []},
    "flag_maldives": {'code': '1f1f2-1f1fb', 'aliases': []},
    "flag_mali": {'code': '1f1f2-1f1f1', 'aliases': []},
    "flag_malta": {'code': '1f1f2-1f1f9', 'aliases': []},
    "flag_marshall_islands": {'code': '1f1f2-1f1ed', 'aliases': []},
    "flag_martinique": {'code': '1f1f2-1f1f6', 'aliases': []},
    "flag_mauritania": {'code': '1f1f2-1f1f7', 'aliases': []},
    "flag_mauritius": {'code': '1f1f2-1f1fa', 'aliases': []},
    "flag_mayotte": {'code': '1f1fe-1f1f9', 'aliases': []},
    "flag_mexico": {'code': '1f1f2-1f1fd', 'aliases': []},
    "flag_micronesia": {'code': '1f1eb-1f1f2', 'aliases': []},
    "flag_moldova": {'code': '1f1f2-1f1e9', 'aliases': []},
    "flag_monaco": {'code': '1f1f2-1f1e8', 'aliases': []},
    "flag_mongolia": {'code': '1f1f2-1f1f3', 'aliases': []},
    "flag_montenegro": {'code': '1f1f2-1f1ea', 'aliases': []},
    "flag_montserrat": {'code': '1f1f2-1f1f8', 'aliases': []},
    "flag_morocco": {'code': '1f1f2-1f1e6', 'aliases': []},
    "flag_mozambique": {'code': '1f1f2-1f1ff', 'aliases': []},
    "flag_myanmar_burma": {'code': '1f1f2-1f1f2', 'aliases': []},
    "flag_namibia": {'code': '1f1f3-1f1e6', 'aliases': []},
    "flag_nauru": {'code': '1f1f3-1f1f7', 'aliases': []},
    "flag_nepal": {'code': '1f1f3-1f1f5', 'aliases': []},
    "flag_netherlands": {'code': '1f1f3-1f1f1', 'aliases': []},
    "flag_new_caledonia": {'code': '1f1f3-1f1e8', 'aliases': []},
    "flag_new_zealand": {'code': '1f1f3-1f1ff', 'aliases': []},
    "flag_nicaragua": {'code': '1f1f3-1f1ee', 'aliases': []},
    "flag_niger": {'code': '1f1f3-1f1ea', 'aliases': []},
    "flag_nigeria": {'code': '1f1f3-1f1ec', 'aliases': []},
    "flag_niue": {'code': '1f1f3-1f1fa', 'aliases': []},
    "flag_norfolk_island": {'code': '1f1f3-1f1eb', 'aliases': []},
    "flag_north_korea": {'code': '1f1f0-1f1f5', 'aliases': []},
    "flag_north_macedonia": {'code': '1f1f2-1f1f0', 'aliases': []},
    "flag_northern_mariana_islands": {'code': '1f1f2-1f1f5', 'aliases': []},
    "flag_norway": {'code': '1f1f3-1f1f4', 'aliases': []},
    "flag_oman": {'code': '1f1f4-1f1f2', 'aliases': []},
    "flag_pakistan": {'code': '1f1f5-1f1f0', 'aliases': []},
    "flag_palau": {'code': '1f1f5-1f1fc', 'aliases': []},
    "flag_palestinian_territories": {'code': '1f1f5-1f1f8', 'aliases': []},
    "flag_panama": {'code': '1f1f5-1f1e6', 'aliases': []},
    "flag_papua_new_guinea": {'code': '1f1f5-1f1ec', 'aliases': []},
    "flag_paraguay": {'code': '1f1f5-1f1fe', 'aliases': []},
    "flag_peru": {'code': '1f1f5-1f1ea', 'aliases': []},
    "flag_philippines": {'code': '1f1f5-1f1ed', 'aliases': []},
    "flag_pitcairn_islands": {'code': '1f1f5-1f1f3', 'aliases': []},
    "flag_poland": {'code': '1f1f5-1f1f1', 'aliases': []},
    "flag_portugal": {'code': '1f1f5-1f1f9', 'aliases': []},
    "flag_puerto_rico": {'code': '1f1f5-1f1f7', 'aliases': []},
    "flag_qatar": {'code': '1f1f6-1f1e6', 'aliases': []},
    "flag_romania": {'code': '1f1f7-1f1f4', 'aliases': []},
    "flag_russia": {'code': '1f1f7-1f1fa', 'aliases': []},
    "flag_rwanda": {'code': '1f1f7-1f1fc', 'aliases': []},
    "flag_réunion": {'code': '1f1f7-1f1ea', 'aliases': ['flag_reunion']},
    "flag_samoa": {'code': '1f1fc-1f1f8', 'aliases': []},
    "flag_san_marino": {'code': '1f1f8-1f1f2', 'aliases': []},
    "flag_saudi_arabia": {'code': '1f1f8-1f1e6', 'aliases': []},
    "flag_scotland": {'code': '1f3f4-e0067-e0062-e0073-e0063-e0074-e007f', 'aliases': []},
    "flag_senegal": {'code': '1f1f8-1f1f3', 'aliases': []},
    "flag_serbia": {'code': '1f1f7-1f1f8', 'aliases': []},
    "flag_seychelles": {'code': '1f1f8-1f1e8', 'aliases': []},
    "flag_sierra_leone": {'code': '1f1f8-1f1f1', 'aliases': []},
    "flag_singapore": {'code': '1f1f8-1f1ec', 'aliases': []},
    "flag_sint_maarten": {'code': '1f1f8-1f1fd', 'aliases': []},
    "flag_slovakia": {'code': '1f1f8-1f1f0', 'aliases': []},
    "flag_slovenia": {'code': '1f1f8-1f1ee', 'aliases': []},
    "flag_solomon_islands": {'code': '1f1f8-1f1e7', 'aliases': []},
    "flag_somalia": {'code': '1f1f8-1f1f4', 'aliases': []},
    "flag_south_africa": {'code': '1f1ff-1f1e6', 'aliases': []},
    "flag_south_georgia_and_south_sandwich_islands": {'code': '1f1ec-1f1f8', 'aliases': []},
    "flag_south_korea": {'code': '1f1f0-1f1f7', 'aliases': []},
    "flag_south_sudan": {'code': '1f1f8-1f1f8', 'aliases': []},
    "flag_spain": {'code': '1f1ea-1f1f8', 'aliases': []},
    "flag_sri_lanka": {'code': '1f1f1-1f1f0', 'aliases': []},
    "flag_st_barthélemy": {'code': '1f1e7-1f1f1', 'aliases': ['flag_st_barthelemy']},
    "flag_st_helena": {'code': '1f1f8-1f1ed', 'aliases': []},
    "flag_st_kitts_and_nevis": {'code': '1f1f0-1f1f3', 'aliases': []},
    "flag_st_lucia": {'code': '1f1f1-1f1e8', 'aliases': []},
    "flag_st_martin": {'code': '1f1f2-1f1eb', 'aliases': []},
    "flag_st_pierre_and_miquelon": {'code': '1f1f5-1f1f2', 'aliases': []},
    "flag_st_vincent_and_grenadines": {'code': '1f1fb-1f1e8', 'aliases': []},
    "flag_sudan": {'code': '1f1f8-1f1e9', 'aliases': []},
    "flag_suriname": {'code': '1f1f8-1f1f7', 'aliases': []},
    "flag_svalbard_and_jan_mayen": {'code': '1f1f8-1f1ef', 'aliases': []},
    "flag_sweden": {'code': '1f1f8-1f1ea', 'aliases': []},
    "flag_switzerland": {'code': '1f1e8-1f1ed', 'aliases': []},
    "flag_syria": {'code': '1f1f8-1f1fe', 'aliases': []},
    "flag_são_tomé_and_príncipe": {'code': '1f1f8-1f1f9', 'aliases': ['flag_sao_tome_and_principe']},
    "flag_taiwan": {'code': '1f1f9-1f1fc', 'aliases': []},
    "flag_tajikistan": {'code': '1f1f9-1f1ef', 'aliases': []},
    "flag_tanzania": {'code': '1f1f9-1f1ff', 'aliases': []},
    "flag_thailand": {'code': '1f1f9-1f1ed', 'aliases': []},
    "flag_timor_leste": {'code': '1f1f9-1f1f1', 'aliases': []},
    "flag_togo": {'code': '1f1f9-1f1ec', 'aliases': []},
    "flag_tokelau": {'code': '1f1f9-1f1f0', 'aliases': []},
    "flag_tonga": {'code': '1f1f9-1f1f4', 'aliases': []},
    "flag_trinidad_and_tobago": {'code': '1f1f9-1f1f9', 'aliases': []},
    "flag_tristan_da_cunha": {'code': '1f1f9-1f1e6', 'aliases': []},
    "flag_tunisia": {'code': '1f1f9-1f1f3', 'aliases': []},
    "flag_turkey": {'code': '1f1f9-1f1f7', 'aliases': []},
    "flag_turkmenistan": {'code': '1f1f9-1f1f2', 'aliases': []},
    "flag_turks_and_caicos_islands": {'code': '1f1f9-1f1e8', 'aliases': []},
    "flag_tuvalu": {'code': '1f1f9-1f1fb', 'aliases': []},
    "flag_uganda": {'code': '1f1fa-1f1ec', 'aliases': []},
    "flag_ukraine": {'code': '1f1fa-1f1e6', 'aliases': []},
    "flag_united_arab_emirates": {'code': '1f1e6-1f1ea', 'aliases': []},
    "flag_united_kingdom": {'code': '1f1ec-1f1e7', 'aliases': []},
    "flag_united_nations": {'code': '1f1fa-1f1f3', 'aliases': []},
    "flag_united_states": {'code': '1f1fa-1f1f8', 'aliases': []},
    "flag_uruguay": {'code': '1f1fa-1f1fe', 'aliases': []},
    "flag_us_outlying_islands": {'code': '1f1fa-1f1f2', 'aliases': []},
    "flag_us_virgin_islands": {'code': '1f1fb-1f1ee', 'aliases': []},
    "flag_uzbekistan": {'code': '1f1fa-1f1ff', 'aliases': []},
    "flag_vanuatu": {'code': '1f1fb-1f1fa', 'aliases': []},
    "flag_vatican_city": {'code': '1f1fb-1f1e6', 'aliases': []},
    "flag_venezuela": {'code': '1f1fb-1f1ea', 'aliases': []},
    "flag_vietnam": {'code': '1f1fb-1f1f3', 'aliases': []},
    "flag_wales": {'code': '1f3f4-e0067-e0062-e0077-e006c-e0073-e007f', 'aliases': []},
    "flag_wallis_and_futuna": {'code': '1f1fc-1f1eb', 'aliases': []},
    "flag_western_sahara": {'code': '1f1ea-1f1ed', 'aliases': []},
    "flag_yemen": {'code': '1f1fe-1f1ea', 'aliases': []},
    "flag_zambia": {'code': '1f1ff-1f1f2', 'aliases': []},
    "flag_zimbabwe": {'code': '1f1ff-1f1fc', 'aliases': []},
    "flag_åland_islands": {'code': '1f1e6-1f1fd', 'aliases': ['flag_aland_islands']},
    "flamingo": {'code': '1f9a9', 'aliases': ['flamboyant']},
    "flashlight": {'code': '1f526', 'aliases': []},
    "flat_shoe": {'code': '1f97f', 'aliases': ['ballet_flat', 'slip_on', 'slipper']},
    "flatbread": {'code': '1fad3', 'aliases': ['arepa', 'lavash', 'naan', 'pita']},
    "fleur_de_lis": {'code': '269c', 'aliases': []},
    "floppy_disk": {'code': '1f4be', 'aliases': []},
    "flushed": {'code': '1f633', 'aliases': ['embarrassed', 'blushing']},
    "fly": {'code': '1fab0', 'aliases': ['maggot', 'rotting']},
    "flying_disc": {'code': '1f94f', 'aliases': ['ultimate']},
    "flying_saucer": {'code': '1f6f8', 'aliases': []},
    "fog": {'code': '1f32b', 'aliases': ['hazy']},
    "foggy": {'code': '1f301', 'aliases': []},
    "folder": {'code': '1f4c2', 'aliases': []},
    "fondue": {'code': '1fad5', 'aliases': ['melted', 'swiss']},
    "food": {'code': '1f372', 'aliases': ['soup', 'stew']},
    "foot": {'code': '1f9b6', 'aliases': ['stomp']},
    "football": {'code': '26bd', 'aliases': ['soccer']},
    "footprints": {'code': '1f463', 'aliases': ['feet']},
    "fork_and_knife": {'code': '1f374', 'aliases': ['eating_utensils']},
    "fortune_cookie": {'code': '1f960', 'aliases': ['prophecy']},
    "forward": {'code': '21aa', 'aliases': ['right_hook']},
    "fountain": {'code': '26f2', 'aliases': []},
    "fountain_pen": {'code': '1f58b', 'aliases': []},
    "four": {'code': '0034-20e3', 'aliases': []},
    "fox": {'code': '1f98a', 'aliases': []},
    "free": {'code': '1f193', 'aliases': []},
    "fries": {'code': '1f35f', 'aliases': []},
    "frog": {'code': '1f438', 'aliases': []},
    "frosty": {'code': '26c4', 'aliases': []},
    "frown": {'code': '1f641', 'aliases': ['slight_frown']},
    "frowning": {'code': '1f626', 'aliases': []},
    "fuel_pump": {'code': '26fd', 'aliases': ['gas_pump', 'petrol_pump']},
    "full_moon": {'code': '1f315', 'aliases': []},
    "funeral_urn": {'code': '26b1', 'aliases': ['cremation']},
    "garlic": {'code': '1f9c4', 'aliases': []},
    "gear": {'code': '2699', 'aliases': ['settings', 'mechanical', 'engineer']},
    "gem": {'code': '1f48e', 'aliases': ['crystal']},
    "gemini": {'code': '264a', 'aliases': []},
    "genie": {'code': '1f9de', 'aliases': []},
    "ghost": {'code': '1f47b', 'aliases': ['boo', 'spooky', 'haunted']},
    "gift": {'code': '1f381', 'aliases': ['present']},
    "gift_heart": {'code': '1f49d', 'aliases': []},
    "giraffe": {'code': '1f992', 'aliases': ['spots']},
    "girl": {'code': '1f467', 'aliases': []},
    "glasses": {'code': '1f453', 'aliases': ['spectacles']},
    "gloves": {'code': '1f9e4', 'aliases': []},
    "glowing_star": {'code': '1f31f', 'aliases': []},
    "goat": {'code': '1f410', 'aliases': []},
    "goblin": {'code': '1f47a', 'aliases': []},
    "goggles": {'code': '1f97d', 'aliases': ['eye_protection', 'swimming', 'welding']},
    "gold_record": {'code': '1f4bd', 'aliases': ['minidisc']},
    "golf": {'code': '1f3cc', 'aliases': []},
    "gondola": {'code': '1f6a0', 'aliases': ['mountain_cableway']},
    "goodnight": {'code': '1f31b', 'aliases': []},
    "gooooooooal": {'code': '1f945', 'aliases': ['goal']},
    "gorilla": {'code': '1f98d', 'aliases': []},
    "graduate": {'code': '1f393', 'aliases': ['mortar_board']},
    "grapes": {'code': '1f347', 'aliases': []},
    "green_apple": {'code': '1f34f', 'aliases': []},
    "green_book": {'code': '1f4d7', 'aliases': []},
    "green_circle": {'code': '1f7e2', 'aliases': ['green']},
    "green_heart": {'code': '1f49a', 'aliases': ['envy']},
    "green_large_square": {'code': '1f7e9', 'aliases': []},
    "grey_exclamation": {'code': '2755', 'aliases': []},
    "grey_question": {'code': '2754', 'aliases': []},
    "grimacing": {'code': '1f62c', 'aliases': ['nervous', 'anxious']},
    "grinning": {'code': '1f600', 'aliases': ['happy']},
    "grinning_face_with_smiling_eyes": {'code': '1f601', 'aliases': []},
    "gua_pi_mao": {'code': '1f472', 'aliases': []},
    "guard": {'code': '1f482', 'aliases': []},
    "guide_dog": {'code': '1f9ae', 'aliases': ['guide']},
    "guitar": {'code': '1f3b8', 'aliases': []},
    "gun": {'code': '1f52b', 'aliases': []},
    "haircut": {'code': '1f487', 'aliases': []},
    "hamburger": {'code': '1f354', 'aliases': []},
    "hammer": {'code': '1f528', 'aliases': ['maintenance', 'handyman', 'handywoman']},
    "hamsa": {'code': '1faac', 'aliases': ['amulet', 'fatima', 'mary', 'miriam', 'protection']},
    "hamster": {'code': '1f439', 'aliases': []},
    "hand": {'code': '270b', 'aliases': ['raised_hand']},
    "hand_with_index_finger_and_thumb_crossed": {'code': '1faf0', 'aliases': ['expensive', 'snap']},
    "handbag": {'code': '1f45c', 'aliases': []},
    "handball": {'code': '1f93e', 'aliases': []},
    "handshake": {'code': '1f91d', 'aliases': ['done_deal']},
    "harvest": {'code': '1f33e', 'aliases': ['ear_of_rice']},
    "hash": {'code': '0023-20e3', 'aliases': []},
    "hat": {'code': '1f452', 'aliases': []},
    "hatching": {'code': '1f423', 'aliases': ['hatching_chick']},
    "heading_down": {'code': '2935', 'aliases': []},
    "heading_up": {'code': '2934', 'aliases': []},
    "headlines": {'code': '1f4f0', 'aliases': []},
    "headphones": {'code': '1f3a7', 'aliases': []},
    "headstone": {'code': '1faa6', 'aliases': ['cemetery', 'graveyard', 'tombstone']},
    "health_worker": {'code': '1f9d1-200d-2695', 'aliases': []},
    "hear_no_evil": {'code': '1f649', 'aliases': []},
    "heart": {'code': '2764', 'aliases': ['love', 'love_you']},
    "heart_box": {'code': '1f49f', 'aliases': []},
    "heart_exclamation": {'code': '2763', 'aliases': []},
    "heart_eyes": {'code': '1f60d', 'aliases': ['in_love']},
    "heart_eyes_cat": {'code': '1f63b', 'aliases': []},
    "heart_hands": {'code': '1faf6', 'aliases': []},
    "heart_kiss": {'code': '1f618', 'aliases': ['blow_a_kiss']},
    "heart_on_fire": {'code': '2764-200d-1f525', 'aliases': ['burn', 'lust', 'sacred_heart']},
    "heart_pulse": {'code': '1f497', 'aliases': ['growing_heart']},
    "heartbeat": {'code': '1f493', 'aliases': []},
    "hearts": {'code': '2665', 'aliases': []},
    "heavy_equals_sign": {'code': '1f7f0', 'aliases': ['equality', 'math']},
    "hedgehog": {'code': '1f994', 'aliases': ['spiny']},
    "helicopter": {'code': '1f681', 'aliases': []},
    "helmet": {'code': '26d1', 'aliases': ['hard_hat', 'rescue_worker', 'safety_first', 'invincible']},
    "herb": {'code': '1f33f', 'aliases': ['plant']},
    "hibiscus": {'code': '1f33a', 'aliases': []},
    "high_five": {'code': '1f590', 'aliases': ['palm']},
    "high_heels": {'code': '1f460', 'aliases': []},
    "high_speed_train": {'code': '1f684', 'aliases': []},
    "high_voltage": {'code': '26a1', 'aliases': ['zap']},
    "hiking_boot": {'code': '1f97e', 'aliases': ['backpacking', 'hiking']},
    "hindu_temple": {'code': '1f6d5', 'aliases': ['hindu', 'temple']},
    "hippopotamus": {'code': '1f99b', 'aliases': ['hippo']},
    "hole": {'code': '1f573', 'aliases': []},
    "hole_in_one": {'code': '26f3', 'aliases': []},
    "holiday_tree": {'code': '1f384', 'aliases': []},
    "honey": {'code': '1f36f', 'aliases': []},
    "hook": {'code': '1fa9d', 'aliases': ['crook', 'curve', 'ensnare', 'selling_point']},
    "horizontal_traffic_light": {'code': '1f6a5', 'aliases': []},
    "horn": {'code': '1f4ef', 'aliases': []},
    "horse": {'code': '1f40e', 'aliases': []},
    "horse_racing": {'code': '1f3c7', 'aliases': ['horse_riding']},
    "hospital": {'code': '1f3e5', 'aliases': []},
    "hot_face": {'code': '1f975', 'aliases': ['feverish', 'heat_stroke', 'red_faced', 'sweating']},
    "hot_pepper": {'code': '1f336', 'aliases': ['chili_pepper']},
    "hot_springs": {'code': '2668', 'aliases': []},
    "hotdog": {'code': '1f32d', 'aliases': []},
    "hotel": {'code': '1f3e8', 'aliases': []},
    "house": {'code': '1f3e0', 'aliases': []},
    "houses": {'code': '1f3d8', 'aliases': []},
    "hug": {'code': '1f917', 'aliases': ['arms_open']},
    "humpback_whale": {'code': '1f40b', 'aliases': []},
    "hungry": {'code': '1f37d', 'aliases': ['meal', 'table_setting', 'fork_and_knife_with_plate', 'lets_eat']},
    "hurt": {'code': '1f915', 'aliases': ['head_bandage', 'injured']},
    "hushed": {'code': '1f62f', 'aliases': []},
    "hut": {'code': '1f6d6', 'aliases': ['roundhouse', 'yurt']},
    "ice": {'code': '1f9ca', 'aliases': ['ice_cube', 'iceberg']},
    "ice_cream": {'code': '1f368', 'aliases': ['gelato']},
    "ice_hockey": {'code': '1f3d2', 'aliases': []},
    "ice_skate": {'code': '26f8', 'aliases': []},
    "id": {'code': '1f194', 'aliases': []},
    "identification_card": {'code': '1faaa', 'aliases': ['credentials', 'license', 'security']},
    "in_bed": {'code': '1f6cc', 'aliases': ['accommodations', 'guestrooms']},
    "inbox": {'code': '1f4e5', 'aliases': []},
    "inbox_zero": {'code': '1f4ed', 'aliases': ['empty_mailbox', 'no_mail']},
    "index_pointing_at_the_viewer": {'code': '1faf5', 'aliases': ['point', 'you']},
    "infinity": {'code': '267e', 'aliases': ['forever', 'unbounded', 'universal']},
    "info": {'code': '2139', 'aliases': []},
    "information_desk_person": {'code': '1f481', 'aliases': ['person_tipping_hand']},
    "injection": {'code': '1f489', 'aliases': ['syringe']},
    "innocent": {'code': '1f607', 'aliases': ['halo']},
    "interrobang": {'code': '2049', 'aliases': []},
    "island": {'code': '1f3dd', 'aliases': []},
    "jack-o-lantern": {'code': '1f383', 'aliases': ['pumpkin']},
    "japan": {'code': '1f5fe', 'aliases': []},
    "japan_post": {'code': '1f3e3', 'aliases': []},
    "japanese_acceptable_button": {'code': '1f251', 'aliases': ['accept']},
    "japanese_application_button": {'code': '1f238', 'aliases': ['u7533']},
    "japanese_bargain_button": {'code': '1f250', 'aliases': ['ideograph_advantage']},
    "japanese_congratulations_button": {'code': '3297', 'aliases': ['congratulations']},
    "japanese_discount_button": {'code': '1f239', 'aliases': ['u5272']},
    "japanese_free_of_charge_button": {'code': '1f21a', 'aliases': ['u7121']},
    "japanese_here_button": {'code': '1f201', 'aliases': ['here', 'ココ']},
    "japanese_monthly_amount_button": {'code': '1f237', 'aliases': ['u6708']},
    "japanese_no_vacancy_button": {'code': '1f235', 'aliases': ['u6e80']},
    "japanese_not_free_of_charge_button": {'code': '1f236', 'aliases': ['u6709']},
    "japanese_open_for_business_button": {'code': '1f23a', 'aliases': ['u55b6']},
    "japanese_passing_grade_button": {'code': '1f234', 'aliases': ['u5408']},
    "japanese_prohibited_button": {'code': '1f232', 'aliases': ['u7981']},
    "japanese_reserved_button": {'code': '1f22f', 'aliases': ['reserved', '指']},
    "japanese_secret_button": {'code': '3299', 'aliases': []},
    "japanese_service_charge_button": {'code': '1f202', 'aliases': ['service_charge', 'サ']},
    "japanese_vacancy_button": {'code': '1f233', 'aliases': ['vacancy', '空']},
    "jar": {'code': '1fad9', 'aliases': ['container', 'sauce', 'store']},
    "jeans": {'code': '1f456', 'aliases': ['denim']},
    "joker": {'code': '1f0cf', 'aliases': []},
    "joy": {'code': '1f602', 'aliases': ['tears', 'laughter_tears']},
    "joy_cat": {'code': '1f639', 'aliases': []},
    "joystick": {'code': '1f579', 'aliases': ['arcade']},
    "judge": {'code': '1f9d1-200d-2696', 'aliases': []},
    "juggling": {'code': '1f939', 'aliases': []},
    "justice": {'code': '2696', 'aliases': ['scales', 'balance']},
    "kaaba": {'code': '1f54b', 'aliases': []},
    "kangaroo": {'code': '1f998', 'aliases': ['joey', 'jump', 'marsupial']},
    "key": {'code': '1f511', 'aliases': []},
    "keyboard": {'code': '2328', 'aliases': []},
    "kick_scooter": {'code': '1f6f4', 'aliases': []},
    "kimono": {'code': '1f458', 'aliases': []},
    "kiss": {'code': '1f48f', 'aliases': []},
    "kiss_man_man": {'code': '1f468-200d-2764-200d-1f48b-200d-1f468', 'aliases': []},
    "kiss_smiling_eyes": {'code': '1f619', 'aliases': []},
    "kiss_with_blush": {'code': '1f61a', 'aliases': []},
    "kiss_woman_man": {'code': '1f469-200d-2764-200d-1f48b-200d-1f468', 'aliases': []},
    "kiss_woman_woman": {'code': '1f469-200d-2764-200d-1f48b-200d-1f469', 'aliases': []},
    "kissing_cat": {'code': '1f63d', 'aliases': []},
    "kissing_face": {'code': '1f617', 'aliases': []},
    "kite": {'code': '1fa81', 'aliases': ['soar']},
    "kitten": {'code': '1f431', 'aliases': []},
    "kiwi": {'code': '1f95d', 'aliases': []},
    "knife": {'code': '1f52a', 'aliases': ['hocho', 'betrayed']},
    "knot": {'code': '1faa2', 'aliases': ['rope', 'tangled', 'twine', 'twist']},
    "koala": {'code': '1f428', 'aliases': []},
    "lab_coat": {'code': '1f97c', 'aliases': []},
    "label": {'code': '1f3f7', 'aliases': ['tag', 'price_tag']},
    "lacrosse": {'code': '1f94d', 'aliases': []},
    "ladder": {'code': '1fa9c', 'aliases': ['climb', 'rung', 'step']},
    "lady_beetle": {'code': '1f41e', 'aliases': ['ladybird', 'ladybug']},
    "landing": {'code': '1f6ec', 'aliases': ['arrival', 'airplane_arrival']},
    "landline": {'code': '1f4de', 'aliases': ['home_phone']},
    "lantern": {'code': '1f3ee', 'aliases': ['izakaya_lantern']},
    "large_blue_diamond": {'code': '1f537', 'aliases': []},
    "large_orange_diamond": {'code': '1f536', 'aliases': []},
    "last_quarter_moon": {'code': '1f317', 'aliases': []},
    "last_quarter_moon_face": {'code': '1f31c', 'aliases': []},
    "laughing": {'code': '1f606', 'aliases': ['lol']},
    "leafy_green": {'code': '1f96c', 'aliases': ['bok_choy', 'cabbage', 'kale', 'lettuce']},
    "leaves": {'code': '1f343', 'aliases': ['wind', 'fall']},
    "ledger": {'code': '1f4d2', 'aliases': ['spiral_notebook']},
    "left": {'code': '2b05', 'aliases': ['west']},
    "left_fist": {'code': '1f91b', 'aliases': []},
    "left_right": {'code': '2194', 'aliases': ['swap']},
    "leftwards_hand": {'code': '1faf2', 'aliases': ['leftward']},
    "leg": {'code': '1f9b5', 'aliases': ['limb']},
    "lemon": {'code': '1f34b', 'aliases': []},
    "leo": {'code': '264c', 'aliases': []},
    "leopard": {'code': '1f406', 'aliases': []},
    "levitating": {'code': '1f574', 'aliases': ['hover']},
    "libra": {'code': '264e', 'aliases': []},
    "lift": {'code': '1f3cb', 'aliases': ['work_out', 'weight_lift', 'gym']},
    "light_bulb": {'code': '1f4a1', 'aliases': ['bulb', 'idea']},
    "light_rail": {'code': '1f688', 'aliases': []},
    "lightning": {'code': '1f329', 'aliases': ['lightning_storm']},
    "link": {'code': '1f517', 'aliases': []},
    "lion": {'code': '1f981', 'aliases': []},
    "lips": {'code': '1f444', 'aliases': ['mouth']},
    "lipstick": {'code': '1f484', 'aliases': []},
    "lipstick_kiss": {'code': '1f48b', 'aliases': []},
    "living_room": {'code': '1f6cb', 'aliases': ['furniture', 'couch_and_lamp', 'lifestyles']},
    "lizard": {'code': '1f98e', 'aliases': ['gecko']},
    "llama": {'code': '1f999', 'aliases': ['alpaca', 'guanaco', 'vicuña', 'wool', 'vicuna']},
    "lobster": {'code': '1f99e', 'aliases': ['bisque', 'claws', 'seafood']},
    "locked": {'code': '1f512', 'aliases': []},
    "locker": {'code': '1f6c5', 'aliases': ['locked_bag']},
    "lollipop": {'code': '1f36d', 'aliases': []},
    "long_drum": {'code': '1fa98', 'aliases': ['beat', 'conga', 'rhythm']},
    "loop": {'code': '27b0', 'aliases': []},
    "losing_money": {'code': '1f4b8', 'aliases': ['easy_come_easy_go', 'money_with_wings']},
    "lotion_bottle": {'code': '1f9f4', 'aliases': ['lotion', 'moisturizer', 'shampoo', 'sunscreen']},
    "lotus": {'code': '1fab7', 'aliases': ['purity']},
    "louder": {'code': '1f50a', 'aliases': ['sound']},
    "loudspeaker": {'code': '1f4e2', 'aliases': ['bullhorn']},
    "love_hotel": {'code': '1f3e9', 'aliases': []},
    "love_letter": {'code': '1f48c', 'aliases': []},
    "love_you_gesture": {'code': '1f91f', 'aliases': ['ily']},
    "low_battery": {'code': '1faab', 'aliases': ['electronic', 'low_energy']},
    "low_brightness": {'code': '1f505', 'aliases': ['dim']},
    "lower_left": {'code': '2199', 'aliases': ['south_west']},
    "lower_right": {'code': '2198', 'aliases': ['south_east']},
    "lucky": {'code': '1f340', 'aliases': ['four_leaf_clover']},
    "luggage": {'code': '1f9f3', 'aliases': ['packing', 'travel']},
    "lungs": {'code': '1fac1', 'aliases': ['breath', 'exhalation', 'inhalation', 'respiration']},
    "lying": {'code': '1f925', 'aliases': []},
    "mage": {'code': '1f9d9', 'aliases': []},
    "magic_wand": {'code': '1fa84', 'aliases': ['magic']},
    "magnet": {'code': '1f9f2', 'aliases': ['attraction', 'horseshoe']},
    "magnifying_glass_tilted_right": {'code': '1f50e', 'aliases': ['magnifying']},
    "mahjong": {'code': '1f004', 'aliases': []},
    "mail_dropoff": {'code': '1f4ee', 'aliases': []},
    "mail_received": {'code': '1f4e8', 'aliases': []},
    "mail_sent": {'code': '1f4e9', 'aliases': ['sealed']},
    "mailbox": {'code': '1f4eb', 'aliases': []},
    "male_sign": {'code': '2642', 'aliases': []},
    "mammoth": {'code': '1f9a3', 'aliases': ['tusk', 'woolly']},
    "man": {'code': '1f468', 'aliases': []},
    "man_and_woman_holding_hands": {'code': '1f46b', 'aliases': ['man_and_woman_couple']},
    "man_artist": {'code': '1f468-200d-1f3a8', 'aliases': []},
    "man_astronaut": {'code': '1f468-200d-1f680', 'aliases': []},
    "man_bald": {'code': '1f468-200d-1f9b2', 'aliases': []},
    "man_beard": {'code': '1f9d4-200d-2642', 'aliases': []},
    "man_biking": {'code': '1f6b4-200d-2642', 'aliases': []},
    "man_blond_hair": {'code': '1f471-200d-2642', 'aliases': ['blond_haired_man']},
    "man_bouncing_ball": {'code': '26f9-fe0f-200d-2642-fe0f', 'aliases': []},
    "man_bowing": {'code': '1f647-200d-2642', 'aliases': []},
    "man_cartwheeling": {'code': '1f938-200d-2642', 'aliases': []},
    "man_climbing": {'code': '1f9d7-200d-2642', 'aliases': []},
    "man_construction_worker": {'code': '1f477-200d-2642', 'aliases': []},
    "man_cook": {'code': '1f468-200d-1f373', 'aliases': []},
    "man_curly_hair": {'code': '1f468-200d-1f9b1', 'aliases': []},
    "man_detective": {'code': '1f575-fe0f-200d-2642-fe0f', 'aliases': []},
    "man_elf": {'code': '1f9dd-200d-2642', 'aliases': []},
    "man_facepalming": {'code': '1f926-200d-2642', 'aliases': []},
    "man_factory_worker": {'code': '1f468-200d-1f3ed', 'aliases': []},
    "man_fairy": {'code': '1f9da-200d-2642', 'aliases': []},
    "man_farmer": {'code': '1f468-200d-1f33e', 'aliases': []},
    "man_feeding_baby": {'code': '1f468-200d-1f37c', 'aliases': []},
    "man_firefighter": {'code': '1f468-200d-1f692', 'aliases': []},
    "man_frowning": {'code': '1f64d-200d-2642', 'aliases': []},
    "man_genie": {'code': '1f9de-200d-2642', 'aliases': []},
    "man_gesturing_no": {'code': '1f645-200d-2642', 'aliases': []},
    "man_gesturing_ok": {'code': '1f646-200d-2642', 'aliases': []},
    "man_getting_haircut": {'code': '1f487-200d-2642', 'aliases': []},
    "man_getting_massage": {'code': '1f486-200d-2642', 'aliases': []},
    "man_golfing": {'code': '1f3cc-fe0f-200d-2642-fe0f', 'aliases': []},
    "man_guard": {'code': '1f482-200d-2642', 'aliases': []},
    "man_health_worker": {'code': '1f468-200d-2695', 'aliases': []},
    "man_in_lotus_position": {'code': '1f9d8-200d-2642', 'aliases': []},
    "man_in_manual_wheelchair": {'code': '1f468-200d-1f9bd', 'aliases': []},
    "man_in_motorized_wheelchair": {'code': '1f468-200d-1f9bc', 'aliases': []},
    "man_in_steamy_room": {'code': '1f9d6-200d-2642', 'aliases': []},
    "man_in_tuxedo": {'code': '1f935-200d-2642', 'aliases': []},
    "man_judge": {'code': '1f468-200d-2696', 'aliases': []},
    "man_juggling": {'code': '1f939-200d-2642', 'aliases': []},
    "man_kneeling": {'code': '1f9ce-200d-2642', 'aliases': []},
    "man_lifting_weights": {'code': '1f3cb-fe0f-200d-2642-fe0f', 'aliases': []},
    "man_mage": {'code': '1f9d9-200d-2642', 'aliases': []},
    "man_mechanic": {'code': '1f468-200d-1f527', 'aliases': []},
    "man_mountain_biking": {'code': '1f6b5-200d-2642', 'aliases': []},
    "man_office_worker": {'code': '1f468-200d-1f4bc', 'aliases': []},
    "man_pilot": {'code': '1f468-200d-2708', 'aliases': []},
    "man_playing_handball": {'code': '1f93e-200d-2642', 'aliases': []},
    "man_playing_water_polo": {'code': '1f93d-200d-2642', 'aliases': []},
    "man_police_officer": {'code': '1f46e-200d-2642', 'aliases': []},
    "man_pouting": {'code': '1f64e-200d-2642', 'aliases': []},
    "man_raising_hand": {'code': '1f64b-200d-2642', 'aliases': []},
    "man_red_hair": {'code': '1f468-200d-1f9b0', 'aliases': []},
    "man_rowing_boat": {'code': '1f6a3-200d-2642', 'aliases': []},
    "man_running": {'code': '1f3c3-200d-2642', 'aliases': []},
    "man_scientist": {'code': '1f468-200d-1f52c', 'aliases': []},
    "man_shrugging": {'code': '1f937-200d-2642', 'aliases': []},
    "man_singer": {'code': '1f468-200d-1f3a4', 'aliases': []},
    "man_standing": {'code': '1f9cd-200d-2642', 'aliases': []},
    "man_student": {'code': '1f468-200d-1f393', 'aliases': []},
    "man_superhero": {'code': '1f9b8-200d-2642', 'aliases': []},
    "man_supervillain": {'code': '1f9b9-200d-2642', 'aliases': []},
    "man_surfing": {'code': '1f3c4-200d-2642', 'aliases': []},
    "man_swimming": {'code': '1f3ca-200d-2642', 'aliases': []},
    "man_teacher": {'code': '1f468-200d-1f3eb', 'aliases': []},
    "man_technologist": {'code': '1f468-200d-1f4bb', 'aliases': []},
    "man_tipping_hand": {'code': '1f481-200d-2642', 'aliases': []},
    "man_vampire": {'code': '1f9db-200d-2642', 'aliases': []},
    "man_walking": {'code': '1f6b6-200d-2642', 'aliases': []},
    "man_wearing_turban": {'code': '1f473-200d-2642', 'aliases': []},
    "man_white_hair": {'code': '1f468-200d-1f9b3', 'aliases': []},
    "man_with_veil": {'code': '1f470-200d-2642', 'aliases': []},
    "man_with_white_cane": {'code': '1f468-200d-1f9af', 'aliases': []},
    "man_zombie": {'code': '1f9df-200d-2642', 'aliases': []},
    "mango": {'code': '1f96d', 'aliases': ['fruit']},
    "mantelpiece_clock": {'code': '1f570', 'aliases': []},
    "manual_wheelchair": {'code': '1f9bd', 'aliases': []},
    "map": {'code': '1f5fa', 'aliases': ['world_map', 'road_trip']},
    "maple_leaf": {'code': '1f341', 'aliases': []},
    "mask": {'code': '1f637', 'aliases': []},
    "massage": {'code': '1f486', 'aliases': []},
    "mate": {'code': '1f9c9', 'aliases': []},
    "meat": {'code': '1f356', 'aliases': []},
    "mechanic": {'code': '1f9d1-200d-1f527', 'aliases': []},
    "mechanical_arm": {'code': '1f9be', 'aliases': []},
    "mechanical_leg": {'code': '1f9bf', 'aliases': []},
    "medal": {'code': '1f3c5', 'aliases': []},
    "medical_symbol": {'code': '2695', 'aliases': ['aesculapius', 'staff']},
    "medicine": {'code': '1f48a', 'aliases': ['pill']},
    "megaphone": {'code': '1f4e3', 'aliases': ['shout']},
    "melon": {'code': '1f348', 'aliases': []},
    "melting_face": {'code': '1fae0', 'aliases': ['dissolve', 'liquid', 'melt']},
    "memo": {'code': '1f4dd', 'aliases': ['note']},
    "men_with_bunny_ears": {'code': '1f46f-200d-2642', 'aliases': []},
    "men_wrestling": {'code': '1f93c-200d-2642', 'aliases': []},
    "mending_heart": {'code': '2764-200d-1fa79', 'aliases': ['healthier', 'improving', 'mending', 'recovering', 'recuperating', 'well']},
    "menorah": {'code': '1f54e', 'aliases': []},
    "mens": {'code': '1f6b9', 'aliases': []},
    "mermaid": {'code': '1f9dc-200d-2640', 'aliases': []},
    "merman": {'code': '1f9dc-200d-2642', 'aliases': ['triton']},
    "merperson": {'code': '1f9dc', 'aliases': []},
    "metro": {'code': '24c2', 'aliases': ['m']},
    "microbe": {'code': '1f9a0', 'aliases': ['amoeba']},
    "microphone": {'code': '1f3a4', 'aliases': ['mike', 'mic']},
    "middle_finger": {'code': '1f595', 'aliases': []},
    "military_helmet": {'code': '1fa96', 'aliases': ['army', 'military', 'soldier', 'warrior']},
    "military_medal": {'code': '1f396', 'aliases': []},
    "milk": {'code': '1f95b', 'aliases': ['glass_of_milk']},
    "milky_way": {'code': '1f30c', 'aliases': ['night_sky']},
    "mine": {'code': '26cf', 'aliases': ['pick']},
    "minibus": {'code': '1f690', 'aliases': []},
    "minus": {'code': '2796', 'aliases': ['subtract']},
    "mirror": {'code': '1fa9e', 'aliases': ['reflection', 'reflector', 'speculum']},
    "mirror_ball": {'code': '1faa9', 'aliases': ['glitter']},
    "mobile_phone": {'code': '1f4f1', 'aliases': ['smartphone', 'iphone', 'android']},
    "money": {'code': '1f4b0', 'aliases': []},
    "money_face": {'code': '1f911', 'aliases': ['kaching']},
    "monkey": {'code': '1f412', 'aliases': []},
    "monkey_face": {'code': '1f435', 'aliases': []},
    "monorail": {'code': '1f69d', 'aliases': ['elevated_train']},
    "moon": {'code': '1f319', 'aliases': []},
    "moon_cake": {'code': '1f96e', 'aliases': ['autumn', 'festival', 'yuèbǐng', 'yuebing']},
    "moon_ceremony": {'code': '1f391', 'aliases': []},
    "moon_face": {'code': '1f31d', 'aliases': []},
    "mosque": {'code': '1f54c', 'aliases': []},
    "mosquito": {'code': '1f99f', 'aliases': ['malaria']},
    "mostly_sunny": {'code': '1f324', 'aliases': []},
    "mother_christmas": {'code': '1f936', 'aliases': ['mrs_claus']},
    "motor_boat": {'code': '1f6e5', 'aliases': []},
    "motorcycle": {'code': '1f3cd', 'aliases': []},
    "motorized_wheelchair": {'code': '1f9bc', 'aliases': []},
    "mount_fuji": {'code': '1f5fb', 'aliases': []},
    "mountain": {'code': '26f0', 'aliases': []},
    "mountain_biker": {'code': '1f6b5', 'aliases': []},
    "mountain_railway": {'code': '1f69e', 'aliases': []},
    "mountain_sunrise": {'code': '1f304', 'aliases': []},
    "mouse": {'code': '1f401', 'aliases': []},
    "mouse_trap": {'code': '1faa4', 'aliases': ['bait', 'mousetrap', 'snare', 'trap']},
    "movie_camera": {'code': '1f3a5', 'aliases': []},
    "moving_truck": {'code': '1f69a', 'aliases': []},
    "multiplication": {'code': '2716', 'aliases': ['multiply']},
    "muscle": {'code': '1f4aa', 'aliases': []},
    "mushroom": {'code': '1f344', 'aliases': []},
    "music": {'code': '1f3b5', 'aliases': []},
    "musical_notes": {'code': '1f3b6', 'aliases': []},
    "musical_score": {'code': '1f3bc', 'aliases': []},
    "mute": {'code': '1f507', 'aliases': ['no_sound']},
    "mute_notifications": {'code': '1f515', 'aliases': []},
    "mx_claus": {'code': '1f9d1-200d-1f384', 'aliases': ['claus_christmas']},
    "nail_polish": {'code': '1f485', 'aliases': ['nail_care']},
    "name_badge": {'code': '1f4db', 'aliases': []},
    "naruto": {'code': '1f365', 'aliases': []},
    "national_park": {'code': '1f3de', 'aliases': []},
    "nauseated": {'code': '1f922', 'aliases': ['queasy']},
    "nazar_amulet": {'code': '1f9ff', 'aliases': ['bead', 'charm', 'evil_eye', 'nazar', 'talisman']},
    "nerd": {'code': '1f913', 'aliases': ['geek']},
    "nest_with_eggs": {'code': '1faba', 'aliases': []},
    "nesting_dolls": {'code': '1fa86', 'aliases': ['doll', 'russia']},
    "neutral": {'code': '1f610', 'aliases': []},
    "new": {'code': '1f195', 'aliases': []},
    "new_baby": {'code': '1f425', 'aliases': []},
    "new_moon": {'code': '1f311', 'aliases': []},
    "new_moon_face": {'code': '1f31a', 'aliases': []},
    "newspaper": {'code': '1f5de', 'aliases': ['swat']},
    "next_track": {'code': '23ed', 'aliases': ['skip_forward']},
    "ng": {'code': '1f196', 'aliases': []},
    "night": {'code': '1f303', 'aliases': []},
    "nine": {'code': '0039-20e3', 'aliases': []},
    "ninja": {'code': '1f977', 'aliases': ['fighter', 'hidden', 'stealth']},
    "no_bicycles": {'code': '1f6b3', 'aliases': []},
    "no_entry": {'code': '26d4', 'aliases': ['wrong_way']},
    "no_pedestrians": {'code': '1f6b7', 'aliases': []},
    "no_phones": {'code': '1f4f5', 'aliases': []},
    "no_signal": {'code': '1f645', 'aliases': ['nope']},
    "no_smoking": {'code': '1f6ad', 'aliases': []},
    "non-potable_water": {'code': '1f6b1', 'aliases': []},
    "nose": {'code': '1f443', 'aliases': []},
    "notebook": {'code': '1f4d3', 'aliases': ['composition_book']},
    "notifications": {'code': '1f514', 'aliases': ['bell']},
    "nut_and_bolt": {'code': '1f529', 'aliases': ['screw']},
    "o": {'code': '1f17e', 'aliases': []},
    "ocean": {'code': '1f30a', 'aliases': []},
    "octopus": {'code': '1f419', 'aliases': []},
    "oden": {'code': '1f362', 'aliases': []},
    "office": {'code': '1f3e2', 'aliases': []},
    "office_supplies": {'code': '1f587', 'aliases': ['paperclip_chain', 'linked']},
    "office_worker": {'code': '1f9d1-200d-1f4bc', 'aliases': []},
    "ogre": {'code': '1f479', 'aliases': []},
    "oh_no": {'code': '1f615', 'aliases': ['half_frown', 'concerned', 'confused']},
    "oil_drum": {'code': '1f6e2', 'aliases': ['commodities']},
    "ok": {'code': '1f44c', 'aliases': ['got_it']},
    "ok_signal": {'code': '1f646', 'aliases': []},
    "older_man": {'code': '1f474', 'aliases': ['elderly_man']},
    "older_person": {'code': '1f9d3', 'aliases': ['old']},
    "older_woman": {'code': '1f475', 'aliases': ['elderly_woman']},
    "olive": {'code': '1fad2', 'aliases': []},
    "om": {'code': '1f549', 'aliases': ['hinduism']},
    "on": {'code': '1f51b', 'aliases': []},
    "oncoming_bus": {'code': '1f68d', 'aliases': []},
    "oncoming_car": {'code': '1f698', 'aliases': ['oncoming_automobile']},
    "oncoming_police_car": {'code': '1f694', 'aliases': []},
    "oncoming_taxi": {'code': '1f696', 'aliases': []},
    "oncoming_train": {'code': '1f686', 'aliases': []},
    "oncoming_tram": {'code': '1f68a', 'aliases': ['oncoming_streetcar', 'oncoming_trolley']},
    "one": {'code': '0031-20e3', 'aliases': []},
    "one_piece_swimsuit": {'code': '1fa71', 'aliases': []},
    "onigiri": {'code': '1f359', 'aliases': []},
    "onion": {'code': '1f9c5', 'aliases': []},
    "open_hands": {'code': '1f450', 'aliases': []},
    "open_mouth": {'code': '1f62e', 'aliases': ['surprise']},
    "ophiuchus": {'code': '26ce', 'aliases': []},
    "orange": {'code': '1f34a', 'aliases': ['tangerine', 'mandarin']},
    "orange_book": {'code': '1f4d9', 'aliases': []},
    "orange_circle": {'code': '1f7e0', 'aliases': []},
    "orange_heart": {'code': '1f9e1', 'aliases': []},
    "orange_square": {'code': '1f7e7', 'aliases': []},
    "orangutan": {'code': '1f9a7', 'aliases': ['ape']},
    "organize": {'code': '1f4c1', 'aliases': ['file_folder']},
    "orthodox_cross": {'code': '2626', 'aliases': []},
    "otter": {'code': '1f9a6', 'aliases': ['playful']},
    "outbox": {'code': '1f4e4', 'aliases': []},
    "owl": {'code': '1f989', 'aliases': []},
    "ox": {'code': '1f402', 'aliases': ['bull']},
    "oyster": {'code': '1f9aa', 'aliases': []},
    "package": {'code': '1f4e6', 'aliases': []},
    "paella": {'code': '1f958', 'aliases': []},
    "page_with_curl": {'code': '1f4c3', 'aliases': ['curl']},
    "pager": {'code': '1f4df', 'aliases': []},
    "paintbrush": {'code': '1f58c', 'aliases': []},
    "palm_down_hand": {'code': '1faf3', 'aliases': ['dismiss', 'shoo']},
    "palm_tree": {'code': '1f334', 'aliases': []},
    "palm_up_hand": {'code': '1faf4', 'aliases': ['beckon', 'come', 'offer']},
    "palms_up_together": {'code': '1f932', 'aliases': ['prayer']},
    "pancakes": {'code': '1f95e', 'aliases': ['breakfast']},
    "panda": {'code': '1f43c', 'aliases': []},
    "paperclip": {'code': '1f4ce', 'aliases': ['attachment']},
    "parachute": {'code': '1fa82', 'aliases': ['hang_glide', 'parasail', 'skydive']},
    "parking": {'code': '1f17f', 'aliases': ['p']},
    "parrot": {'code': '1f99c', 'aliases': ['talk']},
    "part_alternation": {'code': '303d', 'aliases': []},
    "partly_sunny": {'code': '26c5', 'aliases': ['partly_cloudy']},
    "partying_face": {'code': '1f973', 'aliases': []},
    "pass": {'code': '1f3ab', 'aliases': []},
    "passenger_ship": {'code': '1f6f3', 'aliases': ['yacht', 'cruise']},
    "passport_control": {'code': '1f6c2', 'aliases': ['immigration']},
    "pause": {'code': '23f8', 'aliases': []},
    "paw_prints": {'code': '1f43e', 'aliases': ['paws']},
    "peace": {'code': '262e', 'aliases': []},
    "peace_sign": {'code': '270c', 'aliases': ['victory']},
    "peach": {'code': '1f351', 'aliases': []},
    "peacock": {'code': '1f99a', 'aliases': ['ostentatious', 'peahen']},
    "peanuts": {'code': '1f95c', 'aliases': []},
    "pear": {'code': '1f350', 'aliases': []},
    "pen": {'code': '1f58a', 'aliases': ['ballpoint_pen']},
    "pencil": {'code': '270f', 'aliases': []},
    "penguin": {'code': '1f427', 'aliases': []},
    "pensive": {'code': '1f614', 'aliases': ['tired']},
    "people_holding_hands": {'code': '1f9d1-200d-1f91d-200d-1f9d1', 'aliases': ['hold', 'holding_hands']},
    "people_hugging": {'code': '1fac2', 'aliases': ['goodbye', 'thanks']},
    "performing_arts": {'code': '1f3ad', 'aliases': ['drama', 'theater']},
    "persevere": {'code': '1f623', 'aliases': ['helpless']},
    "person": {'code': '1f9d1', 'aliases': []},
    "person_bald": {'code': '1f9d1-200d-1f9b2', 'aliases': []},
    "person_beard": {'code': '1f9d4', 'aliases': []},
    "person_blond_hair": {'code': '1f471', 'aliases': ['blond_haired_person']},
    "person_climbing": {'code': '1f9d7', 'aliases': []},
    "person_curly_hair": {'code': '1f9d1-200d-1f9b1', 'aliases': []},
    "person_feeding_baby": {'code': '1f9d1-200d-1f37c', 'aliases': []},
    "person_frowning": {'code': '1f64d', 'aliases': []},
    "person_in_lotus_position": {'code': '1f9d8', 'aliases': []},
    "person_in_manual_wheelchair": {'code': '1f9d1-200d-1f9bd', 'aliases': []},
    "person_in_motorized_wheelchair": {'code': '1f9d1-200d-1f9bc', 'aliases': []},
    "person_in_steamy_room": {'code': '1f9d6', 'aliases': []},
    "person_kneeling": {'code': '1f9ce', 'aliases': ['kneel']},
    "person_pouting": {'code': '1f64e', 'aliases': []},
    "person_red_hair": {'code': '1f9d1-200d-1f9b0', 'aliases': []},
    "person_standing": {'code': '1f9cd', 'aliases': ['stand']},
    "person_white_hair": {'code': '1f9d1-200d-1f9b3', 'aliases': []},
    "person_with_crown": {'code': '1fac5', 'aliases': ['monarch', 'noble', 'regal', 'royalty']},
    "person_with_white_cane": {'code': '1f9d1-200d-1f9af', 'aliases': []},
    "petri_dish": {'code': '1f9eb', 'aliases': ['biology', 'culture']},
    "phone": {'code': '260e', 'aliases': ['telephone']},
    "phone_off": {'code': '1f4f4', 'aliases': []},
    "piano": {'code': '1f3b9', 'aliases': ['musical_keyboard']},
    "pickup_truck": {'code': '1f6fb', 'aliases': ['pick_up', 'pickup']},
    "picture": {'code': '1f5bc', 'aliases': ['framed_picture']},
    "pie": {'code': '1f967', 'aliases': ['filling', 'pastry']},
    "pig": {'code': '1f416', 'aliases': ['oink']},
    "pig_nose": {'code': '1f43d', 'aliases': []},
    "piglet": {'code': '1f437', 'aliases': []},
    "pilot": {'code': '1f9d1-200d-2708', 'aliases': []},
    "pin": {'code': '1f4cd', 'aliases': ['sewing_pin']},
    "pinched_fingers": {'code': '1f90c', 'aliases': ['fingers', 'hand_gesture', 'interrogation', 'pinched', 'sarcastic']},
    "pinching_hand": {'code': '1f90f', 'aliases': ['small_amount']},
    "pineapple": {'code': '1f34d', 'aliases': []},
    "ping_pong": {'code': '1f3d3', 'aliases': ['table_tennis']},
    "pirate_flag": {'code': '1f3f4-200d-2620', 'aliases': ['jolly_roger', 'plunder']},
    "pisces": {'code': '2653', 'aliases': []},
    "pizza": {'code': '1f355', 'aliases': []},
    "piñata": {'code': '1fa85', 'aliases': ['pinata']},
    "placard": {'code': '1faa7', 'aliases': ['demonstration', 'picket', 'protest', 'sign']},
    "place_holder": {'code': '1f4d1', 'aliases': []},
    "place_of_worship": {'code': '1f6d0', 'aliases': []},
    "play": {'code': '25b6', 'aliases': []},
    "play_pause": {'code': '23ef', 'aliases': []},
    "play_reverse": {'code': '25c0', 'aliases': []},
    "playground_slide": {'code': '1f6dd', 'aliases': ['amusement_park']},
    "playing_cards": {'code': '1f3b4', 'aliases': []},
    "pleading_face": {'code': '1f97a', 'aliases': ['begging', 'mercy', 'puppy_eyes']},
    "plunger": {'code': '1faa0', 'aliases': ['force_cup', 'suction']},
    "plus": {'code': '2795', 'aliases': ['add']},
    "point_down": {'code': '1f447', 'aliases': []},
    "point_left": {'code': '1f448', 'aliases': []},
    "point_right": {'code': '1f449', 'aliases': []},
    "point_up": {'code': '1f446', 'aliases': ['this']},
    "polar_bear": {'code': '1f43b-200d-2744', 'aliases': ['arctic']},
    "police": {'code': '1f46e', 'aliases': ['cop']},
    "police_car": {'code': '1f693', 'aliases': []},
    "pony": {'code': '1f434', 'aliases': []},
    "poodle": {'code': '1f429', 'aliases': []},
    "poop": {'code': '1f4a9', 'aliases': ['pile_of_poo']},
    "popcorn": {'code': '1f37f', 'aliases': []},
    "post_office": {'code': '1f3e4', 'aliases': []},
    "potable_water": {'code': '1f6b0', 'aliases': ['tap_water', 'drinking_water']},
    "potato": {'code': '1f954', 'aliases': []},
    "potted_plant": {'code': '1fab4', 'aliases': ['boring', 'grow', 'nurturing', 'useless']},
    "pouch": {'code': '1f45d', 'aliases': []},
    "pound_notes": {'code': '1f4b7', 'aliases': []},
    "pouring_liquid": {'code': '1fad7', 'aliases': ['spill']},
    "pray": {'code': '1f64f', 'aliases': ['welcome', 'thank_you', 'namaste']},
    "prayer_beads": {'code': '1f4ff', 'aliases': []},
    "pregnant": {'code': '1f930', 'aliases': ['expecting']},
    "pregnant_man": {'code': '1fac3', 'aliases': []},
    "pregnant_person": {'code': '1fac4', 'aliases': []},
    "pretzel": {'code': '1f968', 'aliases': ['twisted']},
    "previous_track": {'code': '23ee', 'aliases': ['skip_back']},
    "prince": {'code': '1f934', 'aliases': []},
    "princess": {'code': '1f478', 'aliases': []},
    "printer": {'code': '1f5a8', 'aliases': []},
    "privacy": {'code': '1f50f', 'aliases': ['key_signing', 'digital_security', 'protected']},
    "prohibited": {'code': '1f6ab', 'aliases': ['not_allowed']},
    "projector": {'code': '1f4fd', 'aliases': ['movie']},
    "puppy": {'code': '1f436', 'aliases': []},
    "purple_circle": {'code': '1f7e3', 'aliases': []},
    "purple_heart": {'code': '1f49c', 'aliases': ['bravery']},
    "purple_square": {'code': '1f7ea', 'aliases': []},
    "purse": {'code': '1f45b', 'aliases': []},
    "push_pin": {'code': '1f4cc', 'aliases': ['thumb_tack']},
    "put_litter_in_its_place": {'code': '1f6ae', 'aliases': []},
    "puzzle_piece": {'code': '1f9e9', 'aliases': ['interlocking', 'jigsaw', 'piece', 'puzzle']},
    "question": {'code': '2753', 'aliases': []},
    "rabbit": {'code': '1f407', 'aliases': []},
    "raccoon": {'code': '1f99d', 'aliases': ['curious', 'sly']},
    "racecar": {'code': '1f3ce', 'aliases': []},
    "radio": {'code': '1f4fb', 'aliases': []},
    "radio_button": {'code': '1f518', 'aliases': []},
    "radioactive": {'code': '2622', 'aliases': ['nuclear']},
    "rage": {'code': '1f621', 'aliases': ['mad', 'grumpy', 'very_angry']},
    "railway_car": {'code': '1f683', 'aliases': ['train_car']},
    "railway_track": {'code': '1f6e4', 'aliases': ['train_tracks']},
    "rainbow": {'code': '1f308', 'aliases': ['pride', 'lgbtq']},
    "rainbow_flag": {'code': '1f3f3-200d-1f308', 'aliases': []},
    "rainy": {'code': '1f327', 'aliases': ['soaked', 'drenched']},
    "raised_hands": {'code': '1f64c', 'aliases': ['praise']},
    "raising_hand": {'code': '1f64b', 'aliases': ['pick_me']},
    "ram": {'code': '1f40f', 'aliases': []},
    "ramen": {'code': '1f35c', 'aliases': ['noodles']},
    "rat": {'code': '1f400', 'aliases': []},
    "razor": {'code': '1fa92', 'aliases': ['sharp', 'shave']},
    "receipt": {'code': '1f9fe', 'aliases': ['accounting', 'bookkeeping', 'evidence', 'proof']},
    "record": {'code': '23fa', 'aliases': []},
    "recreational_vehicle": {'code': '1f699', 'aliases': ['jeep']},
    "recycle": {'code': '267b', 'aliases': []},
    "red_book": {'code': '1f4d5', 'aliases': ['closed_book']},
    "red_circle": {'code': '1f534', 'aliases': []},
    "red_envelope": {'code': '1f9e7', 'aliases': ['good_luck', 'hóngbāo', 'lai_see', 'hongbao']},
    "red_square": {'code': '1f7e5', 'aliases': ['red']},
    "red_triangle_down": {'code': '1f53b', 'aliases': []},
    "red_triangle_up": {'code': '1f53a', 'aliases': []},
    "registered": {'code': '00ae', 'aliases': ['r']},
    "relieved": {'code': '1f60c', 'aliases': []},
    "reminder_ribbon": {'code': '1f397', 'aliases': []},
    "repeat": {'code': '1f501', 'aliases': []},
    "repeat_one": {'code': '1f502', 'aliases': []},
    "reply": {'code': '21a9', 'aliases': ['left_hook']},
    "restroom": {'code': '1f6bb', 'aliases': []},
    "revolving_hearts": {'code': '1f49e', 'aliases': []},
    "rewind": {'code': '23ea', 'aliases': ['fast_reverse']},
    "rhinoceros": {'code': '1f98f', 'aliases': []},
    "ribbon": {'code': '1f380', 'aliases': ['decoration']},
    "rice": {'code': '1f35a', 'aliases': []},
    "right": {'code': '27a1', 'aliases': ['east']},
    "right_fist": {'code': '1f91c', 'aliases': []},
    "rightwards_hand": {'code': '1faf1', 'aliases': ['rightward']},
    "ring": {'code': '1f48d', 'aliases': []},
    "ring_buoy": {'code': '1f6df', 'aliases': ['float', 'life_preserver', 'life_saver', 'rescue']},
    "ringed_planet": {'code': '1fa90', 'aliases': ['saturn', 'saturnine']},
    "road": {'code': '1f6e3', 'aliases': ['motorway']},
    "robot": {'code': '1f916', 'aliases': []},
    "rock": {'code': '1faa8', 'aliases': ['boulder', 'heavy', 'solid', 'stone']},
    "rock_carving": {'code': '1f5ff', 'aliases': ['moyai']},
    "rock_on": {'code': '1f918', 'aliases': ['sign_of_the_horns']},
    "rocket": {'code': '1f680', 'aliases': []},
    "roll_of_paper": {'code': '1f9fb', 'aliases': ['paper_towels', 'toilet_paper']},
    "roller_coaster": {'code': '1f3a2', 'aliases': []},
    "roller_skate": {'code': '1f6fc', 'aliases': ['roller', 'skate']},
    "rolling_eyes": {'code': '1f644', 'aliases': []},
    "rolling_on_the_floor_laughing": {'code': '1f923', 'aliases': ['rofl']},
    "rolodex": {'code': '1f4c7', 'aliases': ['card_index']},
    "rooster": {'code': '1f413', 'aliases': ['alarm', 'cock-a-doodle-doo']},
    "rose": {'code': '1f339', 'aliases': []},
    "rosette": {'code': '1f3f5', 'aliases': []},
    "rowboat": {'code': '1f6a3', 'aliases': ['crew', 'sculling', 'rowing']},
    "rugby": {'code': '1f3c9', 'aliases': []},
    "ruler": {'code': '1f4cf', 'aliases': ['straightedge']},
    "running": {'code': '1f3c3', 'aliases': ['runner']},
    "running_shirt": {'code': '1f3bd', 'aliases': []},
    "sad": {'code': '2639', 'aliases': ['big_frown']},
    "safety_pin": {'code': '1f9f7', 'aliases': ['diaper', 'punk_rock']},
    "safety_vest": {'code': '1f9ba', 'aliases': ['emergency', 'vest']},
    "sagittarius": {'code': '2650', 'aliases': []},
    "sake": {'code': '1f376', 'aliases': []},
    "salad": {'code': '1f957', 'aliases': []},
    "salt": {'code': '1f9c2', 'aliases': ['shaker']},
    "saluting_face": {'code': '1fae1', 'aliases': ['salute', 'troops', 'yes']},
    "sandal": {'code': '1f461', 'aliases': ['flip_flops']},
    "sandwich": {'code': '1f96a', 'aliases': []},
    "santa": {'code': '1f385', 'aliases': []},
    "sari": {'code': '1f97b', 'aliases': []},
    "satellite": {'code': '1f6f0', 'aliases': []},
    "satellite_antenna": {'code': '1f4e1', 'aliases': []},
    "sauropod": {'code': '1f995', 'aliases': ['brachiosaurus', 'brontosaurus', 'diplodocus']},
    "saxophone": {'code': '1f3b7', 'aliases': []},
    "scarf": {'code': '1f9e3', 'aliases': ['neck']},
    "school": {'code': '1f3eb', 'aliases': []},
    "science": {'code': '1f52c', 'aliases': ['microscope']},
    "scientist": {'code': '1f9d1-200d-1f52c', 'aliases': []},
    "scissors": {'code': '2702', 'aliases': []},
    "scooter": {'code': '1f6f5', 'aliases': ['motor_bike']},
    "scorpion": {'code': '1f982', 'aliases': []},
    "scorpius": {'code': '264f', 'aliases': []},
    "scream": {'code': '1f631', 'aliases': []},
    "scream_cat": {'code': '1f640', 'aliases': ['weary_cat']},
    "screwdriver": {'code': '1fa9b', 'aliases': []},
    "scroll": {'code': '1f4dc', 'aliases': []},
    "seal": {'code': '1f9ad', 'aliases': ['sea_lion']},
    "search": {'code': '1f50d', 'aliases': ['find', 'magnifying_glass']},
    "seat": {'code': '1f4ba', 'aliases': []},
    "second_place": {'code': '1f948', 'aliases': ['silver']},
    "secret": {'code': '1f5dd', 'aliases': ['dungeon', 'old_key', 'encrypted', 'clue', 'hint']},
    "secure": {'code': '1f510', 'aliases': ['lock_with_key', 'safe', 'commitment', 'loyalty']},
    "see_no_evil": {'code': '1f648', 'aliases': []},
    "seedling": {'code': '1f331', 'aliases': ['sprout']},
    "seeing_stars": {'code': '1f4ab', 'aliases': []},
    "selfie": {'code': '1f933', 'aliases': []},
    "senbei": {'code': '1f358', 'aliases': ['rice_cracker']},
    "service_dog": {'code': '1f415-200d-1f9ba', 'aliases': ['assistance', 'service']},
    "seven": {'code': '0037-20e3', 'aliases': []},
    "sewing_needle": {'code': '1faa1', 'aliases': ['embroidery', 'stitches', 'sutures', 'tailoring']},
    "shamrock": {'code': '2618', 'aliases': ['clover']},
    "shark": {'code': '1f988', 'aliases': []},
    "shaved_ice": {'code': '1f367', 'aliases': []},
    "sheep": {'code': '1f411', 'aliases': ['baa']},
    "shell": {'code': '1f41a', 'aliases': ['seashell', 'conch', 'spiral_shell']},
    "shield": {'code': '1f6e1', 'aliases': []},
    "shinto_shrine": {'code': '26e9', 'aliases': []},
    "ship": {'code': '1f6a2', 'aliases': []},
    "shiro": {'code': '1f3ef', 'aliases': []},
    "shirt": {'code': '1f455', 'aliases': ['tshirt']},
    "shoe": {'code': '1f45e', 'aliases': []},
    "shooting_star": {'code': '1f320', 'aliases': ['wish']},
    "shopping_bags": {'code': '1f6cd', 'aliases': []},
    "shopping_cart": {'code': '1f6d2', 'aliases': ['shopping_trolley']},
    "shorts": {'code': '1fa73', 'aliases': ['pants']},
    "shower": {'code': '1f6bf', 'aliases': []},
    "shrimp": {'code': '1f990', 'aliases': []},
    "shrug": {'code': '1f937', 'aliases': []},
    "shuffle": {'code': '1f500', 'aliases': []},
    "shushing_face": {'code': '1f92b', 'aliases': ['shush']},
    "sick": {'code': '1f912', 'aliases': ['flu', 'face_with_thermometer', 'ill', 'fever']},
    "silence": {'code': '1f910', 'aliases': ['quiet', 'hush', 'zip_it', 'lips_are_sealed']},
    "silhouette": {'code': '1f464', 'aliases': ['shadow']},
    "silhouettes": {'code': '1f465', 'aliases': ['shadows']},
    "singer": {'code': '1f9d1-200d-1f3a4', 'aliases': []},
    "siren": {'code': '1f6a8', 'aliases': ['rotating_light', 'alert']},
    "six": {'code': '0036-20e3', 'aliases': []},
    "skateboard": {'code': '1f6f9', 'aliases': ['board']},
    "ski": {'code': '1f3bf', 'aliases': []},
    "skier": {'code': '26f7', 'aliases': []},
    "skull": {'code': '1f480', 'aliases': []},
    "skull_and_crossbones": {'code': '2620', 'aliases': ['pirate', 'death', 'hazard', 'toxic', 'poison']},
    "skunk": {'code': '1f9a8', 'aliases': ['stink']},
    "sled": {'code': '1f6f7', 'aliases': ['sledge', 'sleigh']},
    "sleeping": {'code': '1f634', 'aliases': []},
    "sleepy": {'code': '1f62a', 'aliases': []},
    "slot_machine": {'code': '1f3b0', 'aliases': []},
    "sloth": {'code': '1f9a5', 'aliases': ['lazy', 'slow']},
    "small_airplane": {'code': '1f6e9', 'aliases': []},
    "small_blue_diamond": {'code': '1f539', 'aliases': []},
    "small_glass": {'code': '1f943', 'aliases': []},
    "small_orange_diamond": {'code': '1f538', 'aliases': []},
    "smile": {'code': '1f642', 'aliases': []},
    "smile_cat": {'code': '1f638', 'aliases': []},
    "smiley": {'code': '1f603', 'aliases': []},
    "smiley_cat": {'code': '1f63a', 'aliases': []},
    "smiling_devil": {'code': '1f608', 'aliases': ['smiling_imp', 'smiling_face_with_horns']},
    "smiling_face": {'code': '263a', 'aliases': ['relaxed']},
    "smiling_face_with_hearts": {'code': '1f970', 'aliases': ['adore', 'crush']},
    "smiling_face_with_tear": {'code': '1f972', 'aliases': ['grateful', 'smiling', 'tear', 'touched']},
    "smirk": {'code': '1f60f', 'aliases': ['smug']},
    "smirk_cat": {'code': '1f63c', 'aliases': ['smug_cat']},
    "smoking": {'code': '1f6ac', 'aliases': []},
    "snail": {'code': '1f40c', 'aliases': []},
    "snake": {'code': '1f40d', 'aliases': ['hiss']},
    "sneezing": {'code': '1f927', 'aliases': []},
    "snowboarder": {'code': '1f3c2', 'aliases': []},
    "snowflake": {'code': '2744', 'aliases': []},
    "snowman": {'code': '2603', 'aliases': []},
    "snowy": {'code': '1f328', 'aliases': ['snowstorm']},
    "snowy_mountain": {'code': '1f3d4', 'aliases': []},
    "soap": {'code': '1f9fc', 'aliases': ['bar', 'bathing', 'lather', 'soapdish']},
    "sob": {'code': '1f62d', 'aliases': []},
    "socks": {'code': '1f9e6', 'aliases': ['stocking']},
    "soft_serve": {'code': '1f366', 'aliases': ['soft_ice_cream']},
    "softball": {'code': '1f94e', 'aliases': ['glove', 'underarm']},
    "softer": {'code': '1f509', 'aliases': []},
    "soon": {'code': '1f51c', 'aliases': []},
    "sort": {'code': '1f5c2', 'aliases': []},
    "sos": {'code': '1f198', 'aliases': []},
    "space_invader": {'code': '1f47e', 'aliases': []},
    "spades": {'code': '2660', 'aliases': []},
    "spaghetti": {'code': '1f35d', 'aliases': []},
    "sparkle": {'code': '2747', 'aliases': []},
    "sparkler": {'code': '1f387', 'aliases': []},
    "sparkles": {'code': '2728', 'aliases': ['glamour']},
    "sparkling_heart": {'code': '1f496', 'aliases': []},
    "speak_no_evil": {'code': '1f64a', 'aliases': []},
    "speaker": {'code': '1f508', 'aliases': []},
    "speaking_head": {'code': '1f5e3', 'aliases': []},
    "speech_bubble": {'code': '1f5e8', 'aliases': []},
    "speechless": {'code': '1f636', 'aliases': ['no_mouth', 'blank', 'poker_face']},
    "speedboat": {'code': '1f6a4', 'aliases': []},
    "spider": {'code': '1f577', 'aliases': []},
    "spiral_calendar": {'code': '1f5d3', 'aliases': ['pad']},
    "spiral_notepad": {'code': '1f5d2', 'aliases': []},
    "spock": {'code': '1f596', 'aliases': ['live_long_and_prosper']},
    "sponge": {'code': '1f9fd', 'aliases': ['absorbing', 'porous']},
    "spoon": {'code': '1f944', 'aliases': []},
    "squared_ok": {'code': '1f197', 'aliases': []},
    "squared_up": {'code': '1f199', 'aliases': []},
    "squid": {'code': '1f991', 'aliases': []},
    "stadium": {'code': '1f3df', 'aliases': []},
    "star": {'code': '2b50', 'aliases': []},
    "star_and_crescent": {'code': '262a', 'aliases': ['islam']},
    "star_of_david": {'code': '2721', 'aliases': ['judaism']},
    "star_struck": {'code': '1f929', 'aliases': []},
    "station": {'code': '1f689', 'aliases': []},
    "statue": {'code': '1f5fd', 'aliases': ['new_york', 'statue_of_liberty']},
    "stethoscope": {'code': '1fa7a', 'aliases': []},
    "stock_market": {'code': '1f4b9', 'aliases': []},
    "stop": {'code': '1f91a', 'aliases': []},
    "stop_button": {'code': '23f9', 'aliases': []},
    "stop_sign": {'code': '1f6d1', 'aliases': ['octagonal_sign']},
    "stopwatch": {'code': '23f1', 'aliases': []},
    "strawberry": {'code': '1f353', 'aliases': []},
    "strike": {'code': '1f3b3', 'aliases': ['bowling']},
    "stuck_out_tongue": {'code': '1f61b', 'aliases': ['mischievous']},
    "stuck_out_tongue_closed_eyes": {'code': '1f61d', 'aliases': []},
    "stuck_out_tongue_wink": {'code': '1f61c', 'aliases': ['joking', 'crazy']},
    "student": {'code': '1f9d1-200d-1f393', 'aliases': []},
    "studio_microphone": {'code': '1f399', 'aliases': []},
    "suburb": {'code': '1f3e1', 'aliases': []},
    "subway": {'code': '1f687', 'aliases': []},
    "sun_face": {'code': '1f31e', 'aliases': []},
    "sunflower": {'code': '1f33b', 'aliases': []},
    "sunglasses": {'code': '1f60e', 'aliases': []},
    "sunny": {'code': '2600', 'aliases': []},
    "sunrise": {'code': '1f305', 'aliases': ['ocean_sunrise']},
    "sunset": {'code': '1f306', 'aliases': []},
    "sunshowers": {'code': '1f326', 'aliases': ['sun_and_rain', 'partly_sunny_with_rain']},
    "superhero": {'code': '1f9b8', 'aliases': []},
    "supervillain": {'code': '1f9b9', 'aliases': []},
    "surf": {'code': '1f3c4', 'aliases': []},
    "sushi": {'code': '1f363', 'aliases': []},
    "suspension_railway": {'code': '1f69f', 'aliases': []},
    "swan": {'code': '1f9a2', 'aliases': ['cygnet', 'ugly_duckling']},
    "sweat": {'code': '1f613', 'aliases': []},
    "sweat_drops": {'code': '1f4a6', 'aliases': []},
    "sweat_smile": {'code': '1f605', 'aliases': []},
    "swim": {'code': '1f3ca', 'aliases': []},
    "symbols": {'code': '1f523', 'aliases': []},
    "synagogue": {'code': '1f54d', 'aliases': []},
    "t_rex": {'code': '1f996', 'aliases': ['tyrannosaurus_rex']},
    "taco": {'code': '1f32e', 'aliases': []},
    "tada": {'code': '1f389', 'aliases': []},
    "take_off": {'code': '1f6eb', 'aliases': ['departure', 'airplane_departure']},
    "takeout_box": {'code': '1f961', 'aliases': ['oyster_pail']},
    "taking_a_picture": {'code': '1f4f8', 'aliases': ['say_cheese']},
    "tamale": {'code': '1fad4', 'aliases': ['mexican', 'wrapped']},
    "taurus": {'code': '2649', 'aliases': []},
    "taxi": {'code': '1f695', 'aliases': ['rideshare']},
    "tea": {'code': '1f375', 'aliases': []},
    "teacher": {'code': '1f9d1-200d-1f3eb', 'aliases': []},
    "teapot": {'code': '1fad6', 'aliases': []},
    "technologist": {'code': '1f9d1-200d-1f4bb', 'aliases': []},
    "teddy_bear": {'code': '1f9f8', 'aliases': ['plaything', 'plush', 'stuffed']},
    "telescope": {'code': '1f52d', 'aliases': []},
    "temperature": {'code': '1f321', 'aliases': ['thermometer', 'warm']},
    "tempura": {'code': '1f364', 'aliases': []},
    "ten": {'code': '1f51f', 'aliases': []},
    "tennis": {'code': '1f3be', 'aliases': []},
    "tent": {'code': '26fa', 'aliases': ['camping']},
    "test_tube": {'code': '1f9ea', 'aliases': ['chemistry']},
    "thinking": {'code': '1f914', 'aliases': []},
    "third_place": {'code': '1f949', 'aliases': ['bronze']},
    "thong_sandal": {'code': '1fa74', 'aliases': ['beach_sandals', 'sandals', 'thong_sandals', 'thongs', 'zōri', 'zori']},
    "thought": {'code': '1f4ad', 'aliases': ['dream']},
    "thread": {'code': '1f9f5', 'aliases': ['spool', 'string']},
    "three": {'code': '0033-20e3', 'aliases': []},
    "thunderstorm": {'code': '26c8', 'aliases': ['thunder_and_rain']},
    "ticket": {'code': '1f39f', 'aliases': []},
    "tie": {'code': '1f454', 'aliases': []},
    "tiger": {'code': '1f405', 'aliases': []},
    "tiger_cub": {'code': '1f42f', 'aliases': []},
    "time": {'code': '1f557', 'aliases': ['clock']},
    "time_ticking": {'code': '23f3', 'aliases': ['hourglass']},
    "timer": {'code': '23f2', 'aliases': []},
    "times_up": {'code': '231b', 'aliases': ['hourglass_done']},
    "tm": {'code': '2122', 'aliases': ['trademark']},
    "toilet": {'code': '1f6bd', 'aliases': []},
    "tomato": {'code': '1f345', 'aliases': []},
    "tongue": {'code': '1f445', 'aliases': []},
    "toolbox": {'code': '1f9f0', 'aliases': ['chest']},
    "tooth": {'code': '1f9b7', 'aliases': ['dentist']},
    "toothbrush": {'code': '1faa5', 'aliases': ['bathroom', 'brush', 'dental', 'hygiene', 'teeth']},
    "top": {'code': '1f51d', 'aliases': []},
    "top_hat": {'code': '1f3a9', 'aliases': []},
    "tornado": {'code': '1f32a', 'aliases': []},
    "tower": {'code': '1f5fc', 'aliases': ['tokyo_tower']},
    "trackball": {'code': '1f5b2', 'aliases': []},
    "tractor": {'code': '1f69c', 'aliases': []},
    "traffic_light": {'code': '1f6a6', 'aliases': ['vertical_traffic_light']},
    "train": {'code': '1f682', 'aliases': ['steam_locomotive']},
    "tram": {'code': '1f68b', 'aliases': ['streetcar']},
    "transgender_flag": {'code': '1f3f3-fe0f-200d-26a7-fe0f', 'aliases': ['light_blue', 'pink']},
    "transgender_symbol": {'code': '26a7', 'aliases': []},
    "tree": {'code': '1f333', 'aliases': ['deciduous_tree']},
    "triangular_flag": {'code': '1f6a9', 'aliases': []},
    "trident": {'code': '1f531', 'aliases': []},
    "triumph": {'code': '1f624', 'aliases': []},
    "troll": {'code': '1f9cc', 'aliases': ['fairy_tale', 'fantasy', 'monster']},
    "trolley": {'code': '1f68e', 'aliases': []},
    "trophy": {'code': '1f3c6', 'aliases': ['winner']},
    "tropical_drink": {'code': '1f379', 'aliases': []},
    "tropical_fish": {'code': '1f420', 'aliases': []},
    "truck": {'code': '1f69b', 'aliases': ['tractor-trailer', 'big_rig', 'semi_truck', 'transport_truck']},
    "trumpet": {'code': '1f3ba', 'aliases': []},
    "tulip": {'code': '1f337', 'aliases': ['flower']},
    "turban": {'code': '1f473', 'aliases': []},
    "turkey": {'code': '1f983', 'aliases': []},
    "turtle": {'code': '1f422', 'aliases': ['tortoise']},
    "tuxedo": {'code': '1f935', 'aliases': []},
    "tv": {'code': '1f4fa', 'aliases': ['television']},
    "two": {'code': '0032-20e3', 'aliases': []},
    "two_hearts": {'code': '1f495', 'aliases': []},
    "two_men_holding_hands": {'code': '1f46c', 'aliases': ['men_couple']},
    "two_women_holding_hands": {'code': '1f46d', 'aliases': ['women_couple']},
    "umbrella": {'code': '2602', 'aliases': []},
    "umbrella_with_rain": {'code': '2614', 'aliases': []},
    "umm": {'code': '1f4ac', 'aliases': ['speech_balloon']},
    "unamused": {'code': '1f612', 'aliases': []},
    "underage": {'code': '1f51e', 'aliases': ['nc17']},
    "unicorn": {'code': '1f984', 'aliases': []},
    "unlocked": {'code': '1f513', 'aliases': []},
    "unread_mail": {'code': '1f4ec', 'aliases': []},
    "up": {'code': '2b06', 'aliases': ['north']},
    "up_down": {'code': '2195', 'aliases': []},
    "upper_left": {'code': '2196', 'aliases': ['north_west']},
    "upper_right": {'code': '2197', 'aliases': ['north_east']},
    "upside_down": {'code': '1f643', 'aliases': ['oops']},
    "upvote": {'code': '1f53c', 'aliases': ['up_button', 'increase']},
    "vampire": {'code': '1f9db', 'aliases': []},
    "vase": {'code': '1f3fa', 'aliases': ['amphora']},
    "vhs": {'code': '1f4fc', 'aliases': ['videocassette']},
    "vibration_mode": {'code': '1f4f3', 'aliases': []},
    "video_camera": {'code': '1f4f9', 'aliases': ['video_recorder']},
    "video_game": {'code': '1f3ae', 'aliases': []},
    "violin": {'code': '1f3bb', 'aliases': []},
    "virgo": {'code': '264d', 'aliases': []},
    "volcano": {'code': '1f30b', 'aliases': []},
    "volleyball": {'code': '1f3d0', 'aliases': []},
    "volume": {'code': '1f39a', 'aliases': ['level_slider']},
    "vs": {'code': '1f19a', 'aliases': []},
    "waffle": {'code': '1f9c7', 'aliases': ['indecisive', 'iron']},
    "wait_one_second": {'code': '261d', 'aliases': ['point_of_information', 'asking_a_question']},
    "walking": {'code': '1f6b6', 'aliases': ['pedestrian']},
    "waning_crescent_moon": {'code': '1f318', 'aliases': []},
    "waning_gibbous_moon": {'code': '1f316', 'aliases': ['gibbous']},
    "warning": {'code': '26a0', 'aliases': ['caution', 'danger']},
    "wastebasket": {'code': '1f5d1', 'aliases': ['trash_can']},
    "watch": {'code': '231a', 'aliases': []},
    "water_buffalo": {'code': '1f403', 'aliases': []},
    "water_polo": {'code': '1f93d', 'aliases': []},
    "watermelon": {'code': '1f349', 'aliases': []},
    "wave": {'code': '1f44b', 'aliases': ['hello', 'hi']},
    "wavy_dash": {'code': '3030', 'aliases': []},
    "waxing_crescent_moon": {'code': '1f312', 'aliases': ['waxing']},
    "waxing_moon": {'code': '1f314', 'aliases': []},
    "wc": {'code': '1f6be', 'aliases': ['water_closet']},
    "weary": {'code': '1f629', 'aliases': ['distraught']},
    "web": {'code': '1f578', 'aliases': ['spider_web']},
    "wedding": {'code': '1f492', 'aliases': []},
    "whale": {'code': '1f433', 'aliases': []},
    "wheel": {'code': '1f6de', 'aliases': ['tire', 'turn']},
    "wheel_of_dharma": {'code': '2638', 'aliases': ['buddhism']},
    "white_and_black_square": {'code': '1f532', 'aliases': []},
    "white_cane": {'code': '1f9af', 'aliases': []},
    "white_circle": {'code': '26aa', 'aliases': []},
    "white_flag": {'code': '1f3f3', 'aliases': ['surrender']},
    "white_flower": {'code': '1f4ae', 'aliases': []},
    "white_heart": {'code': '1f90d', 'aliases': []},
    "white_large_square": {'code': '2b1c', 'aliases': []},
    "white_medium_small_square": {'code': '25fd', 'aliases': []},
    "white_medium_square": {'code': '25fb', 'aliases': []},
    "white_small_square": {'code': '25ab', 'aliases': []},
    "wilted_flower": {'code': '1f940', 'aliases': ['crushed']},
    "wind_chime": {'code': '1f390', 'aliases': []},
    "window": {'code': '1fa9f', 'aliases': ['frame', 'fresh_air', 'opening', 'transparent', 'view']},
    "windy": {'code': '1f32c', 'aliases': ['mother_nature']},
    "wine": {'code': '1f377', 'aliases': []},
    "wink": {'code': '1f609', 'aliases': []},
    "wish_tree": {'code': '1f38b', 'aliases': ['tanabata_tree']},
    "wolf": {'code': '1f43a', 'aliases': []},
    "woman": {'code': '1f469', 'aliases': []},
    "woman_artist": {'code': '1f469-200d-1f3a8', 'aliases': []},
    "woman_astronaut": {'code': '1f469-200d-1f680', 'aliases': []},
    "woman_bald": {'code': '1f469-200d-1f9b2', 'aliases': []},
    "woman_beard": {'code': '1f9d4-200d-2640', 'aliases': []},
    "woman_biking": {'code': '1f6b4-200d-2640', 'aliases': []},
    "woman_blond_hair": {'code': '1f471-200d-2640', 'aliases': ['blond_haired_woman', 'blonde']},
    "woman_bouncing_ball": {'code': '26f9-fe0f-200d-2640-fe0f', 'aliases': []},
    "woman_bowing": {'code': '1f647-200d-2640', 'aliases': []},
    "woman_cartwheeling": {'code': '1f938-200d-2640', 'aliases': []},
    "woman_climbing": {'code': '1f9d7-200d-2640', 'aliases': []},
    "woman_construction_worker": {'code': '1f477-200d-2640', 'aliases': []},
    "woman_cook": {'code': '1f469-200d-1f373', 'aliases': []},
    "woman_curly_hair": {'code': '1f469-200d-1f9b1', 'aliases': []},
    "woman_detective": {'code': '1f575-fe0f-200d-2640-fe0f', 'aliases': []},
    "woman_elf": {'code': '1f9dd-200d-2640', 'aliases': []},
    "woman_facepalming": {'code': '1f926-200d-2640', 'aliases': []},
    "woman_factory_worker": {'code': '1f469-200d-1f3ed', 'aliases': []},
    "woman_fairy": {'code': '1f9da-200d-2640', 'aliases': []},
    "woman_farmer": {'code': '1f469-200d-1f33e', 'aliases': []},
    "woman_feeding_baby": {'code': '1f469-200d-1f37c', 'aliases': []},
    "woman_firefighter": {'code': '1f469-200d-1f692', 'aliases': []},
    "woman_frowning": {'code': '1f64d-200d-2640', 'aliases': []},
    "woman_genie": {'code': '1f9de-200d-2640', 'aliases': []},
    "woman_gesturing_no": {'code': '1f645-200d-2640', 'aliases': []},
    "woman_gesturing_ok": {'code': '1f646-200d-2640', 'aliases': []},
    "woman_getting_haircut": {'code': '1f487-200d-2640', 'aliases': []},
    "woman_getting_massage": {'code': '1f486-200d-2640', 'aliases': []},
    "woman_golfing": {'code': '1f3cc-fe0f-200d-2640-fe0f', 'aliases': []},
    "woman_guard": {'code': '1f482-200d-2640', 'aliases': []},
    "woman_health_worker": {'code': '1f469-200d-2695', 'aliases': []},
    "woman_in_lotus_position": {'code': '1f9d8-200d-2640', 'aliases': []},
    "woman_in_manual_wheelchair": {'code': '1f469-200d-1f9bd', 'aliases': []},
    "woman_in_motorized_wheelchair": {'code': '1f469-200d-1f9bc', 'aliases': []},
    "woman_in_steamy_room": {'code': '1f9d6-200d-2640', 'aliases': []},
    "woman_in_tuxedo": {'code': '1f935-200d-2640', 'aliases': []},
    "woman_judge": {'code': '1f469-200d-2696', 'aliases': []},
    "woman_juggling": {'code': '1f939-200d-2640', 'aliases': []},
    "woman_kneeling": {'code': '1f9ce-200d-2640', 'aliases': []},
    "woman_lifting_weights": {'code': '1f3cb-fe0f-200d-2640-fe0f', 'aliases': []},
    "woman_mage": {'code': '1f9d9-200d-2640', 'aliases': []},
    "woman_mechanic": {'code': '1f469-200d-1f527', 'aliases': []},
    "woman_mountain_biking": {'code': '1f6b5-200d-2640', 'aliases': []},
    "woman_office_worker": {'code': '1f469-200d-1f4bc', 'aliases': []},
    "woman_pilot": {'code': '1f469-200d-2708', 'aliases': []},
    "woman_playing_handball": {'code': '1f93e-200d-2640', 'aliases': []},
    "woman_playing_water_polo": {'code': '1f93d-200d-2640', 'aliases': []},
    "woman_police_officer": {'code': '1f46e-200d-2640', 'aliases': []},
    "woman_pouting": {'code': '1f64e-200d-2640', 'aliases': []},
    "woman_raising_hand": {'code': '1f64b-200d-2640', 'aliases': []},
    "woman_red_hair": {'code': '1f469-200d-1f9b0', 'aliases': []},
    "woman_rowing_boat": {'code': '1f6a3-200d-2640', 'aliases': []},
    "woman_running": {'code': '1f3c3-200d-2640', 'aliases': []},
    "woman_scientist": {'code': '1f469-200d-1f52c', 'aliases': []},
    "woman_shrugging": {'code': '1f937-200d-2640', 'aliases': []},
    "woman_singer": {'code': '1f469-200d-1f3a4', 'aliases': []},
    "woman_standing": {'code': '1f9cd-200d-2640', 'aliases': []},
    "woman_student": {'code': '1f469-200d-1f393', 'aliases': []},
    "woman_superhero": {'code': '1f9b8-200d-2640', 'aliases': []},
    "woman_supervillain": {'code': '1f9b9-200d-2640', 'aliases': []},
    "woman_surfing": {'code': '1f3c4-200d-2640', 'aliases': []},
    "woman_swimming": {'code': '1f3ca-200d-2640', 'aliases': []},
    "woman_teacher": {'code': '1f469-200d-1f3eb', 'aliases': []},
    "woman_technologist": {'code': '1f469-200d-1f4bb', 'aliases': []},
    "woman_tipping_hand": {'code': '1f481-200d-2640', 'aliases': []},
    "woman_vampire": {'code': '1f9db-200d-2640', 'aliases': []},
    "woman_walking": {'code': '1f6b6-200d-2640', 'aliases': []},
    "woman_wearing_turban": {'code': '1f473-200d-2640', 'aliases': []},
    "woman_white_hair": {'code': '1f469-200d-1f9b3', 'aliases': []},
    "woman_with_headscarf": {'code': '1f9d5', 'aliases': ['headscarf', 'hijab', 'mantilla', 'tichel']},
    "woman_with_veil": {'code': '1f470-200d-2640', 'aliases': []},
    "woman_with_white_cane": {'code': '1f469-200d-1f9af', 'aliases': []},
    "woman_zombie": {'code': '1f9df-200d-2640', 'aliases': []},
    "women_with_bunny_ears": {'code': '1f46f-200d-2640', 'aliases': []},
    "women_wrestling": {'code': '1f93c-200d-2640', 'aliases': []},
    "womens": {'code': '1f6ba', 'aliases': []},
    "wood": {'code': '1fab5', 'aliases': ['log', 'timber']},
    "woozy_face": {'code': '1f974', 'aliases': ['intoxicated', 'tipsy', 'uneven_eyes', 'wavy_mouth']},
    "work_in_progress": {'code': '1f6a7', 'aliases': ['construction_zone']},
    "working_on_it": {'code': '1f6e0', 'aliases': ['hammer_and_wrench', 'tools']},
    "worm": {'code': '1fab1', 'aliases': ['annelid', 'earthworm', 'parasite']},
    "worried": {'code': '1f61f', 'aliases': []},
    "wrestling": {'code': '1f93c', 'aliases': []},
    "writing": {'code': '270d', 'aliases': []},
    "www": {'code': '1f310', 'aliases': ['globe']},
    "x": {'code': '274e', 'aliases': []},
    "x_ray": {'code': '1fa7b', 'aliases': ['bones', 'medical']},
    "yam": {'code': '1f360', 'aliases': ['sweet_potato']},
    "yarn": {'code': '1f9f6', 'aliases': ['crochet', 'knit']},
    "yawning_face": {'code': '1f971', 'aliases': ['bored', 'yawn']},
    "yellow_circle": {'code': '1f7e1', 'aliases': ['yellow']},
    "yellow_heart": {'code': '1f49b', 'aliases': ['heart_of_gold']},
    "yellow_large_square": {'code': '1f7e8', 'aliases': []},
    "yen_banknotes": {'code': '1f4b4', 'aliases': []},
    "yin_yang": {'code': '262f', 'aliases': []},
    "yo_yo": {'code': '1fa80', 'aliases': ['fluctuate']},
    "yum": {'code': '1f60b', 'aliases': []},
    "zany_face": {'code': '1f92a', 'aliases': ['goofy', 'small']},
    "zebra": {'code': '1f993', 'aliases': ['stripe']},
    "zero": {'code': '0030-20e3', 'aliases': []},
    "zombie": {'code': '1f9df', 'aliases': []},
    "zzz": {'code': '1f4a4', 'aliases': []},
}
# fmt: on
