# Карта развития веб-разработчика [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=%D0%9A%D0%B0%D1%80%D1%82%D0%B0+%D1%80%D0%B0%D0%B7%D0%B2%D0%B8%D1%82%D0%B8%D1%8F+%D0%B2%D0%B5%D0%B1-%D1%80%D0%B0%D0%B7%D1%80%D0%B0%D0%B1%D0%BE%D1%82%D1%87%D0%B8%D0%BA%D0%B0&url=https://github.com/zualex/devmap/&via=iamZualex&hashtags=devmap)

## Содержание
- [**Каждый уважающий себя разработчик должен знать:**](#Каждый-уважающий-себя-разработчик-должен-знать-)
    - [ ] [Книги](#Книги-)
    - [ ] [Английский язык](#Английский-язык-)
    - [ ] [Архитектура компьютера](#Архитектура-компьютера-)
    - [ ] [Linux, командная строка Bash](#linux-командная-строка-bash-)
    - [ ] [Структуры данных](#Структуры-данных-)
    - [ ] [HTML & CSS](#html--css-)
    - [ ] [Объектно-ориентированное программирование](#Объектно-ориентированное-программирование-)
    - [ ] [Функциональное программирование](#Функциональное-программирование-)
    - [ ] [Системы управления версиями](#Системы-управления-версиями-)
    - [ ] [Протокол HTTP](#Протокол-http-)
    - [ ] [Тестирование](#Тестирование-)
    - [ ] [Безопасность сайтов](#Безопасность-сайтов-)
    - [ ] [Тайм-менеджмент](#Тайм-менеджмент-)

- [**Карта развития Back-end разработчика:**](#Карта-развития-back-end-разработчика-)
    - [ ] [Алгоритмы](#Алгоритмы-)
    - [ ] [Серверные языки программирования](#Серверные-языки-программирования-)
    - [ ] [Паттерны программирования](#Паттерны-программирования-)
    - [ ] [Принципы программирования](#Принципы-программирования-)
    - [ ] [Регулярные выражения](#Регулярные-выражения-)
    - [ ] [SQL](#sql-)
    - [ ] [Проектирование баз данных](#Проектирование-баз-данных-)
    - [ ] [Фреймворки](#Фреймворки-)
    - [ ] [Пакетный менеджер](#Пакетный-менеджер-)
    - [ ] [Устройство веб-серверов и способы взаимодействия](#Устройство-веб-серверов-и-способы-взаимодействия-)
    - [ ] [Развертывание проектов](#Развертывание-проектов-)

- [**Карта развития Front-end разработчика:**](#Карта-развития-front-end-разработчика-)
    - [ ] [JavaScript](#javascript-)
    - [ ] [Адаптивный/отзывчивый веб-дизайн](#Адаптивныйотзывчивый-веб-дизайн-)
    - [ ] [JavaScript библиотеки](#javascript-библиотеки-)
    - [ ] [Препроцессоры CSS](#Препроцессоры-css-)
    - [ ] [Сборщик проектов](#Сборщик-проектов-)
    - [ ] [Пакетный менеджер](#Пакетный-менеджер-)
    - [ ] [CSS фреймворки](#css-фреймворки-)
    - [ ] [JavaScript фреймворки](#javascript-фреймворки-)
    - [ ] [Одностраничное приложение](#Одностраничное-приложение-)

---

## Каждый уважающий себя разработчик должен знать [&uarr;](#Содержание)

### Книги [&uarr;](#Содержание)
Это — книги «на все времена». Лучшие в своем роде и важные для программистов любых направлений.

- [ ] Жизнь:
    - [ ] [Цель. Процесс непрерывного совершенствования (Элия М. Гольдратт, Джеф Кокс)](https://www.ozon.ru/context/detail/id/4341360/)
    - [ ] [Идеальный программист. Как стать профессионалом разработки ПО (Роберт К. Мартин)](http://www.ozon.ru/context/detail/id/7360633/)
    - [ ] [Джоэл о программировании (Джоэл Х. Спольски)](https://www.ozon.ru/context/detail/id/2820575/)
    - [ ] [Джоэл и снова о программировании (Джоэл Х. Спольски)](http://www.ozon.ru/context/detail/id/4878099/)

- [ ] Архитектура компьютера:
    - [ ] [Код. Тайный язык информатики (Чарльз Петцольд)](http://www.ozon.ru/context/detail/id/125884/)

- [ ] Программирование:
    - [ ] [Структура и интерпретация компьютерных программ (Харольд Абельсон, Джеральд Джей Сассман)](http://www.ozon.ru/context/detail/id/5322055/)
    - [ ] [Алгоритмы. Вводный курс (Томас Х. Кормен)](http://www.ozon.ru/context/detail/id/24903185/)
    - [ ] [Совершенный код (Стив Макконнелл)](http://www.ozon.ru/context/detail/id/5508646/)
    - [ ] [Чистый код: создание, анализ и рефакторинг (Роберт Мартин)](http://www.ozon.ru/context/detail/id/21916535/)
    - [ ] [Рефакторинг. Улучшение существующего кода (Мартин Фаулер)](http://www.ozon.ru/context/detail/id/1308678/)

- [ ] Операционные системы:
    - [ ] [Операционная система UNIX (Андрей Робачевский, Сергей Немнюгин, Ольга Стесик)](http://www.ozon.ru/context/detail/id/2419365/)
    - [ ] [Руководство администратора Linux (Эви Немет, Гарт Снайдер, Трент Р. Хейн)](https://www.ozon.ru/context/detail/id/7607778/)

- [ ] Люди:
    - [ ] [Человеческий фактор. Успешные проекты и команды (Том ДеМарко, Тимоти Листер)](https://www.ozon.ru/context/detail/id/2338486/)
    - [ ] [Мифический человеко-месяц, или Как создаются программные системы (Хилл Чапел, Фредерик Брукс)](https://www.ozon.ru/context/detail/id/83760/)
    - [ ] [Как сдвинуть гору Фудзи? Подходы ведущих мировых компаний к поиску талантов (Уильям Паундстоун)](https://www.ozon.ru/context/detail/id/3764126/)

---

### Английский язык [&uarr;](#Содержание)
**Зачем** - большинство лучших курсов, справочных и учебных материалов доступно именно на английском языке. Если возникают трудности, то со знанием английского языка выше шансы найти ответ во всемирной паутине. Также если хотите работать в крутой престижной кампании, то без английского никак.

- Полезные ресурсы:
    - [ ] [Duolingo](https://www.duolingo.com/)
    - [ ] [Lingualeo](https://lingualeo.com/)
    - [ ] [Babadum](https://babadum.com/)
    - [ ] [Anki](http://ankisrs.net/) и карточки [4000 Essential English Words (all books) [en-en] M4R4M](https://ankiweb.net/shared/info/1898344648)
    - [ ] [Techrocks](https://techrocks.ru) очень много статей переведенных с английского
    - [ ] [English e-Reader](https://english-e-reader.net/) адаптированные книги на английском
    - [ ] [British council](https://learnenglish.britishcouncil.org/) очень много полезной и структурированной информации для изучения
    - [ ] [Jazz chants](http://www.onestopenglish.com/skills/listening/jazz-chants/mp3-files-and-recording-scripts/) тренировка темпа и скорости речи, чтобы звучать более естественно
    - [ ] [Engoo Daily news](https://engoo.com/app/daily-news) статьи на английском с разбивкой по уровням
    - [ ] [YouGlish](https://youglish.com) поиск произношения слова или короткой фразы в Youtube

---

### Архитектура компьютера [&uarr;](#Содержание)
**Цель** - познакомиться с концептуальной структурой вычислительных машин.

- [ ] Книга:
    - [ ] [Код. Тайный язык информатики (Чарльз Петцольд)](http://www.ozon.ru/context/detail/id/125884/)

---

### Linux, командная строка Bash [&uarr;](#Содержание)
**Цель** - понять как работают операционные системы. Научиться базовому администрированию.

- [ ] Ресурсы:
    - [ ] [Курс: Bash: Основы командной строки (Hexlet)](https://ru.hexlet.io/courses/bash?ref=62000)
    - [ ] [Статья: Искусство командной строки (статья)](https://github.com/jlevy/the-art-of-command-line/blob/master/README-ru.md)
    - [ ] [Книга: Операционная система UNIX (Андрей Робачевский, Сергей Немнюгин, Ольга Стесик)](http://www.ozon.ru/context/detail/id/2419365/)
    - [ ] [Книга: Руководство администратора Linux (Эви Немет, Гарт Снайдер, Трент Р. Хейн)](https://www.ozon.ru/context/detail/id/7607778/)
    - [ ] [Книга: Advanced Programming in the UNIX Environment (Richard Stevens)](https://www.amazon.com/Advanced-Programming-UNIX-Environment-3rd/dp/0321637739)

---

### Структуры данных [&uarr;](#Содержание)
Структуры данных — программная единица, позволяющая хранить и обрабатывать множество однотипных и/или логически связанных данных в вычислительной технике. Данные можно представить по-разному. В зависимости от того, что это за данные и что вы собираетесь с ними делать, одно представление подойдёт лучше других.

Рекомендуется ознакомиться с [алгоритмами](#Алгоритмы-) хотя бы на базововм уровне. Так как структуры данных реализованы с помощью алгоритмов, алгоритмы - с помощью структур данных.

- [ ] Понимание:
    - [ ] Списки
    - [ ] Хеш-таблица
    - [ ] Стек
    - [ ] Очередь
    - [ ] Граф
    - [ ] Связный список
    - [ ] Деревья
    - [ ] Двоичное дерево поиска

- [ ] Статьи:
    - [ ] [Структуры данных для самых маленьких](https://habrahabr.ru/post/310794/)

- [ ] Книги:
    - [ ] [Совершенный код (Стив Макконнелл) глава 12 Основные типы данных](http://www.ozon.ru/context/detail/id/5508646/)
    - [ ] [Структура и интерпретация компьютерных программ (Харольд Абельсон, Джеральд Джей Сассман)](http://www.ozon.ru/context/detail/id/5322055/)
    - [ ] [Грокаем алгоритмы. Иллюстрированное пособие для программистов и любопытствующих(Адитья Бхаргава)](https://www.ozon.ru/context/detail/id/139296295/)


---

### HTML & CSS [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Верстка
    - [ ] HTML 5
    - [ ] Разметка
    - [ ] Семантика
    - [ ] Cтили
    - [ ] Cелекторы
    - [ ] Анимация

- [ ] Документации, курсы:
    - [ ] [htmlbook](http://htmlbook.ru/)
    - [ ] [MDN](https://developer.mozilla.org/en-US/)
    - [ ] [HTML academy](https://htmlacademy.ru/)
    - [ ] [Введение в schema.org (yandex)](https://yandex.ru/support/webmaster/schema-org/intro-schema-org.xml)

---

### Объектно-ориентированное программирование [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Класс
    - [ ] Объект
    - [ ] Абстракция данных
    - [ ] Инкапсуляция
    - [ ] Наследование
    - [ ] Полиморфизм

- [ ] Книга:
    - [ ] [Объектно-ориентированное конструирование программных систем (Бертран Мейер)](http://www.ozon.ru/context/detail/id/2336754/)

---

### Функциональное программирование [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Абстракция данных
    - [ ] Функция высшего порядка
    - [ ] Чистые функции
    - [ ] Рекурсия
    - [ ] Замыкания
    - [ ] Неизменяемый объект

- [ ] Статьи:
    - [ ] [Функциональное программирование для всех (habrahabr)](https://habrahabr.ru/post/142351/)
    - [ ] [Умение видеть абстракции (habrahabr)](https://habrahabr.ru/company/infopulse/blog/185144/)

- [ ] Книга:
    - [ ] [Структура и интерпретация компьютерных программ (Харольд Абельсон, Джеральд Джей Сассман)](http://www.ozon.ru/context/detail/id/5322055/)

---

### Системы управления версиями [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Ветвления
    - [ ] Слияние
    - [ ] Конфликты и их разрешение
    - [ ] Версии проекта, теги
    - [ ] Базовые принципы разработки ПО в VCS
    - [ ] Ежедневный цикл работы

- [ ] Курс:
    - [ ] [Git How To](https://githowto.com/ru)

- [ ] Книга:
    - [ ] [Pro Git (Scott Chacon, Ben Straub)](https://git-scm.com/book/ru/v2)

- [ ] Статьи:
    - [ ] [Как генерировать осмысленные коммиты. Применяем стандарт Conventional Commits](https://habr.com/ru/company/yandex/blog/431432/)

---

### Протокол HTTP [&uarr;](#Содержание)
**Цель** - понять, как браузер взаимодействует с веб-сервером.

- [ ] Усвоить понятия:
    - [ ] User-agent
    - [ ] DNS
    - [ ] Отличия HTTP 2.0 от версий 1.x
    - [ ] Тело HTTP-запроса
    - [ ] Передача данных
    - [ ] Отправка форм
    - [ ] Transfer-Encoding
    - [ ] Перенаправления
    - [ ] Базовая аутентификация
    - [ ] Cookies

- [ ] Статьи:
    - [ ] [Простым языком об HTTP (habrahabr)](https://habrahabr.ru/post/215117/)
    - [ ] [HTTP: протокол, который каждый разработчик должен знать (часть 1)](http://ruseller.com/lessons.php?rub=28&id=1726)
    - [ ] [HTTP: протокол, который каждый разработчик должен знать (часть 2)](http://ruseller.com/lessons.php?rub=28&id=1777)
    - [ ] [HTTP запрос](http://citforum.ru/internet/cgi_tut/rqst.shtml)
    - [ ] [HTTP ответ](http://citforum.ru/internet/cgi_tut/spns.shtml)

- [ ] Курс:
    - [ ] [Протокол HTTP (Hexlet)](https://ru.hexlet.io/courses/http_protocol?ref=62000)

---

### Тестирование [&uarr;](#Содержание)
- [ ] Виды тестов:
    - [ ] Блочное тестирование (модульное, unit testing)
    - [ ] Интеграционное тестирование
    - [ ] Системное тестирование

- [ ] Изучить методологии:
    - [ ] Разработка через тестирование (TDD)
    - [ ] разработка, основанная на функционировании (BDD)

- [ ] Статьи:
    - [ ] [Виды тестирования и подходы к их применению (habrahabr)](https://habrahabr.ru/post/81226/)
    - [ ] [Test-Driven Development — телега или лошадь? (habrahabr)](https://habrahabr.ru/post/206828/)

---

### Безопасность сайтов [&uarr;](#Содержание)
- [ ] Уязвимости:
    - [ ] SQL-инъекция
    - [ ] Межсайтовый скриптинг или XSS
    - [ ] Демонстрация ошибок пользователю
    - [ ] Доступность данных о характеристиках системы пользователю
    - [ ] Инъекция через загрузку файлов
    - [ ] E-mail-инъекция
    - [ ] Кража сессии

- [ ] Книга:
    - [ ] [Секреты хакеров. Безопасность Web-приложений - готовые решения (Джоел Скамбрэй, Майк Шема)](http://www.ozon.ru/reviews/1351090/)

- [ ] Статья:
    - [ ] [Top 5 уязвимостей PHP безопасности](http://php-hack.ru/php_mysql/top_5_uyazvimostej_php_bezopasnosti/)

---

### Тайм-менеджмент [&uarr;](#Содержание)
Тайм-менеджмент - технология организации времени и повышения эффективности его использования.

Методы:
- [ ] Метод «Помидора»
- [ ] Метод Парето
- [ ] Метод «Альп»
- [ ] Матрица Эйзенхауэра

Можно использовать один или несколько методов или разработать свой метод. Главное, чтобы он был удобен и реально приносил пользу.

- [ ] Статьи:
    - [ ] [Как планировать время: 7 самых популярных техник тайм-менеджмента](http://uspevai7ya.ru/2014/10/kak-planirovat-vremya/)
    - [ ] [Тайм-менеджмент для разработчика](https://habrahabr.ru/post/259293/)
    - [ ] [Управление временем (Wikipedia)](https://ru.wikipedia.org/wiki/%D0%A3%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5_%D0%B2%D1%80%D0%B5%D0%BC%D0%B5%D0%BD%D0%B5%D0%BC)

---

## Карта развития Back-end разработчика [&uarr;](#Содержание)

### Алгоритмы [&uarr;](#Содержание)
- [ ] Познакомиться с алгоритмами:
    - [ ] Сортировки
    - [ ] Поиска в строке
    - [ ] Обхода и поиска в структурах данных
    - [ ] На графах

- [ ] Статьи:
    - [ ] [Пузырьковая сортировка и все-все-все (habrahabr)](https://habrahabr.ru/post/204600/)
    - [ ] [Алгоритмы поиска в строке (habrahabr)](https://habrahabr.ru/post/111449/)
    - [ ] [Алгоритмы и структуры данных поиска. Лекции и курсы от Яндекса (habrahabr)](https://habrahabr.ru/company/yandex/blog/208716/)
    - [ ] [Алгоритм Дейкстры. Поиск оптимальных маршрутов на графе (habrahabr)](https://habrahabr.ru/post/111361/)

- [ ] Книги:
    - [ ] [Грокаем алгоритмы. Иллюстрированное пособие для программистов и любопытствующих (Адитья Бхаргава)](https://www.ozon.ru/context/detail/id/139296295/)
    - [ ] [Алгоритмы. Вводный курс (Томас Х. Кормен)](http://www.ozon.ru/context/detail/id/24903185/)

- [ ] Ресурсы:
    - [ ] [HackerRank](https://www.hackerrank.com/)
    - [ ] [Codewars](https://www.codewars.com/)
    - [ ] [LeetCode](https://leetcode.com/)

---

### Серверные языки программирования [&uarr;](#Содержание)
**Цель** - освоить несколько серверных языков программирования.

Нельзя останавливаться на одном языке, так как у вас может появиться 'JAVA головного мозга' - неспособность думать за пределами своего языка программирования.

Лозунг: нужно программировать не на языке программирования, а используя его.

- [ ] Примеры серверных языков:
    - [ ] PHP
    - [ ] Python
    - [ ] Ruby
    - [ ] Node.js

- [ ] Статьи:
    - [ ] Типы данных
    - [ ] [Функциональное программирование](#Функциональное-программирование-)
    - [ ] [Объектно-ориентированное программирование](#Объектно-ориентированное-программирование-)
    - [ ] [Тестирование](#Тестирование-)

---

### Паттерны программирования [&uarr;](#Содержание)
- [ ] Познакомиться cо слелующими типами паттернов:
    - [ ] Порождающие шаблоны проектирования
    - [ ] Структурные шаблоны проектирования
    - [ ] Поведенческие шаблоны проектирования

- [ ] Статьи:
    - [ ] [DesignPatternsPHP](http://designpatternsphp.readthedocs.io/ru/latest/README.html)
    - [ ] [Шаблон проектирования (wikipedia)](https://ru.wikipedia.org/wiki/%D0%A8%D0%B0%D0%B1%D0%BB%D0%BE%D0%BD_%D0%BF%D1%80%D0%BE%D0%B5%D0%BA%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F)
    - [ ] [Шпаргалка по шаблонам проектирования (habrahabr)](https://habrahabr.ru/post/210288/)
    - [ ] [Справочник «Паттерны проектирования»](http://design-pattern.ru/)
    - [ ] [Design Patterns for Humans (Github)](https://github.com/kamranahmedse/design-patterns-for-humans)
    - [ ] [Каталог паттернов проектирования](https://refactoring.guru/ru/design-patterns/catalog)

- [ ] Видео:
    - [ ] [Webinar: Patterns (Hexlet)](https://www.youtube.com/watch?v=wX6BBaQZpzE)

- [ ] Книга:
    - [ ] [Приемы объектно-ориентированного проектирования. Паттерны проектирования (Э. Гамма, Р. Хелм, Р. Джонсон, Д. Влиссилес.)](http://www.ozon.ru/context/detail/id/2457392/)

---

### Принципы программирования [&uarr;](#Содержание)
- [ ] Познакомиться с принципами:
    - [ ] DRY
    - [ ] KISS
    - [ ] YAGNI
    - [ ] SOLID

- [ ] Статья:
    - [ ] [Принципы программирования (wikipedia)](https://ru.wikipedia.org/wiki/%D0%9A%D0%B0%D1%82%D0%B5%D0%B3%D0%BE%D1%80%D0%B8%D1%8F:%D0%9F%D1%80%D0%B8%D0%BD%D1%86%D0%B8%D0%BF%D1%8B_%D0%BF%D1%80%D0%BE%D0%B3%D1%80%D0%B0%D0%BC%D0%BC%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D1%8F)

---

### Регулярные выражения [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Квантификация
    - [ ] Жадность
    - [ ] Группировка

- [ ] Статьи:
    - [ ] [Регулярные выражения (wikipedia)](https://ru.wikipedia.org/wiki/%D0%A0%D0%B5%D0%B3%D1%83%D0%BB%D1%8F%D1%80%D0%BD%D1%8B%D0%B5_%D0%B2%D1%8B%D1%80%D0%B0%D0%B6%D0%B5%D0%BD%D0%B8%D1%8F)
    - [ ] [Жадные и ленивые квантификаторы (learn.javascript)](https://learn.javascript.ru/regexp-greedy-and-lazy)

---

### SQL [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] DDL, DML, DQL
    - [ ] Создание и удаление базы данных, таблицы
    - [ ] Добавление, обновление и удаление записи
    - [ ] Схема (SCHEMA)
    - [ ] Представления (VIEWS)
    - [ ] WHERE
    - [ ] LIMIT, OFFSET
    - [ ] ORDER BY
    - [ ] GROUP BY
    - [ ] JOIN
    - [ ] Подзапросы

- [ ] Статьи:
    - [ ] [Что такое SQL (wikipedia)](https://ru.wikipedia.org/wiki/SQL)
    - [ ] [Схема базы данных (wikipedia)](https://ru.wikipedia.org/wiki/%D0%A1%D1%85%D0%B5%D0%BC%D0%B0_%D0%B1%D0%B0%D0%B7%D1%8B_%D0%B4%D0%B0%D0%BD%D0%BD%D1%8B%D1%85)
    - [ ] [Представления в MySQL (habrahabr)](https://habrahabr.ru/post/47031/)
    - [ ] [Квалифицированный выбор при использовании предложений](http://www.sql.ru/docs/sql/u_sql/ch3.shtml#3.9)
    - [ ] [Полнотекстовый поиск и его возможности (habrahabr)](https://habrahabr.ru/post/40218/)

- [ ] Курсы:
    - [ ] [Базы данных: SQL (DDL/DML) (Hexlet)](https://ru.hexlet.io/courses/postgresql-ddl?ref=62000)
    - [ ] [Базы данных: SQL (DQL) (Hexlet)](https://ru.hexlet.io/courses/sql-dql?ref=62000)

---

### Проектирование баз данных [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Нормализация
    - [ ] Денормализация
    - [ ] Связи

- [ ] Статьи:
    - [ ] [Проектирование баз данных (wikipedia)](https://ru.wikipedia.org/wiki/%D0%9F%D1%80%D0%BE%D0%B5%D0%BA%D1%82%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5_%D0%B1%D0%B0%D0%B7_%D0%B4%D0%B0%D0%BD%D0%BD%D1%8B%D1%85)
    - [ ] [Нормальная форма (wikipedia)](https://ru.wikipedia.org/wiki/%D0%9D%D0%BE%D1%80%D0%BC%D0%B0%D0%BB%D1%8C%D0%BD%D0%B0%D1%8F_%D1%84%D0%BE%D1%80%D0%BC%D0%B0)
    - [ ] [Нормализация отношений. Шесть нормальных форм (habrahabr)](https://habrahabr.ru/post/254773/)
    - [ ] [Денормализация БД. Зачем? Когда? Как? (habrahabr)](https://habrahabr.ru/post/64524/)

---

### Фреймворки [&uarr;](#Содержание)
Для разных языков программирования существуют разные фреймворки, не нужно изучать всё сразу, необходимо взять несколько фреймворков за основу.

- [ ] PHP фреймворки:
    - [ ] [Slim microframework](http://www.slimframework.com/)
    - [ ] [Laravel](https://laravel.com/)
    - [ ] [Symfony](https://symfony.com/)
    - [ ] [Yii](http://www.yiiframework.com/)

- [ ] Python фреймворки:
    - [ ] [Django](https://www.djangoproject.com/)
    - [ ] [Flask](http://flask.pocoo.org/)

- [ ] Ruby фреймворки:
    - [ ] [Ruby on Rails](http://rubyonrails.org/)

- [ ] Node.js фреймворки:
    - [ ] [Express](https://expressjs.com/)
    - [ ] [Koa](https://koajs.com/)
    - [ ] [Next](https://nextjs.org/)

- [ ] Статьи:
    - [ ] [Фреймворк (wikipedia)](https://ru.wikipedia.org/wiki/%D0%A4%D1%80%D0%B5%D0%B9%D0%BC%D0%B2%D0%BE%D1%80%D0%BA)
    - [ ] [Не учите фреймворки, учите архитектуру (habrahabr)](https://habrahabr.ru/post/253297/)

---

### Пакетный менеджер [&uarr;](#Содержание)
- [ ] Список пакетных менеджеров:
    - [ ] Для PHP - [composer](https://getcomposer.org/)
    - [ ] Для Python - [pip](https://pypi.python.org/pypi/pip)
    - [ ] Для Ruby - [bundler](http://bundler.io/)
    - [ ] Для Javascript - [npm](https://www.npmjs.com/), [yarn](https://yarnpkg.com/)

- [ ] Статьи:
    - [ ] [Composer — менеджер зависимостей для PHP (habrahabr)](https://habrahabr.ru/post/145946/)
    - [ ] [npm для простых смертных (habrahabr)](https://habrahabr.ru/post/243335/)

---

### Устройство веб-серверов и способы взаимодействия [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] HTTP
    - [ ] NGINX
    - [ ] APACHE
    - [ ] Треды
    - [ ] Worker
    - [ ] CGI
    - [ ] FastCGI
    - [ ] event Loop

- [ ] Статьи:
    - [ ] [Протокол HTTP (devmap)](http.md)
    - [ ] [Веб-сервер (wikipedia)](https://ru.wikipedia.org/wiki/%D0%92%D0%B5%D0%B1-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80)
    - [ ] [Модели работы веб-серверов](http://algolist.manual.ru/web/servers.php)

---

### Развертывание проектов [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Деплой
    - [ ] Миграции
    - [ ] Релизы
    - [ ] Еnvironment
    - [ ] Непрерывная интеграция (CI)

- [ ] Статьи:
    - [ ] [Версионная миграция структуры базы данных: основные подходы (habrahabr)](https://habrahabr.ru/post/121265/)
    - [ ] [Нумерация версий ПО для новичков и не только (habrahabr)](https://habrahabr.ru/post/119400/)
    - [ ] [Automated git deployments from Bitbucket](http://jonathannicol.com/blog/2013/11/19/automated-git-deployments-from-bitbucket/)
    - [ ] [How to use Vagrant for local web development](http://tech.osteel.me/posts/2015/01/25/how-to-use-vagrant-for-local-web-development.html)
    - [ ] [Vagrant для малышей, или как на Windows легко получить настроенный сервер для разработки веб-приложений](https://habrahabr.ru/post/251529/)

---

## Карта развития Front-end разработчика [&uarr;](#Содержание)

### JavaScript [&uarr;](#Содержание)
- [ ] Познакомиться с такими понятиями как:
    - [ ] Переменные
    - [ ] Типы данных
    - [ ] Функции
    - [ ] Рекурсия
    - [ ] Замыкания
    - [ ] Область видимости
    - [ ] Объекты
    - [ ] События
    - [ ] DOM

- [ ] Документации, книги:
    - [ ] [Eloquent JavaScript](https://karmazzin.gitbooks.io/eloquentjavascript_ru/content/)
    - [ ] [learn.javascript](https://learn.javascript.ru/)
    - [ ] [MDN](https://developer.mozilla.org/bm/docs/Web/JavaScript)
    - [ ] [ECMAScript 6 features](https://github.com/lukehoban/es6features)

---

### Адаптивный/отзывчивый веб-дизайн [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Адаптивный веб-дизайн
    - [ ] Отзывчивый веб-дизайн
    - [ ] Media queries
    - [ ] Mobile first
    - [ ] Graceful degradation
    - [ ] RESS

- [ ] Статьи:
    - [ ] [9 отличий адаптивного дизайна от «резинового» в GIF-картинках](http://ain.ua/2014/11/14/550351)
    - [ ] [Сравнение методов создания мобильных версий сайтов (habrahabr)](https://habrahabr.ru/company/netcat/blog/170807/)

---

### JavaScript библиотеки [&uarr;](#Содержание)
**Цель** - познакомиться с наиболее популярными библиотеками JavaScript. Знать где и когда их применять.

Список библиотек:
- [ ] [jQuery](https://jquery.com/)
- [ ] [ReactJS](https://reactjs.org/)
- [ ] [Underscore - набор полезных функций](http://underscorejs.org/)
- [ ] [Modernizr - обнаруживает HTML5 и CSS3 функции в браузере пользователя](https://modernizr.com/)
- [ ] [Babel - компилятор для написания JavaScript следующего поколения](https://babeljs.io/)
- [ ] [Three - 3D](http://threejs.org/)
- [ ] [WOW - анимация при прокрутки страницы](http://mynameismatthieu.com/WOW/)
- [ ] [Moment - Работа с датой и временем](http://momentjs.com/)
- [ ] [Mocha - написание тестов](https://mochajs.org/)

Список наиболее популярных библиотек есть на [Javascripting](https://www.javascripting.com/)

---

### Препроцессоры CSS [&uarr;](#Содержание)
- [ ] Усвоить понятия:
    - [ ] Переменные
    - [ ] Миксины
    - [ ] Функции
    - [ ] Импорт
    - [ ] Минификация

- [ ] Список препроцессоров CSS:
    - [ ] [Sass/Scss](http://sass-lang.com/)
    - [ ] [Less](http://lesscss.org/)
    - [ ] [Stylus](http://stylus-lang.com/)

- [ ] Статьи:
    - [ ] [Руководство по написанию разумного, поддерживаемого и масштабируемого Sass](https://sass-guidelin.es/ru/)

---

### Сборщик проектов [&uarr;](#Содержание)
Сборщик проектов — небольшое приложение, которое используется для автоматизации скучных и рутинных задач, которые приходится постоянно выполнять в процессе разработки проекта. Такие задачи включают в себя, к примеру, запуск модульных тестов, конкатенацию файлов, минификацию, препроцессинг CSS.

- [ ] Сборщики проектов:
    - [ ] [Gulp](http://gulpjs.com/)
    - [ ] [Grunt](http://gruntjs.com/)
    - [ ] [Webpack](https://webpack.js.org/)
    - [ ] [Vite](https://vitejs.dev/)

- [ ] Статьи:
    - [ ] [Приятная сборка frontend проекта (habrahabr)](https://habrahabr.ru/post/250569/)
    - [ ] [Gulp — как глоток свежего воздуха после Grunt](http://frontender.info/no-need-to-grunt-take-a-gulp-of-fresh-air/)
    - [ ] [The Gulp file generator](http://quenchjs.com/)

---

### Пакетный менеджер [&uarr;](#Содержание)
- [ ] Список пакетных менеджеров:
    - [ ] [Bower](https://bower.io/)
    - [ ] [npm](https://www.npmjs.com/)
    - [ ] [Yarn](https://yarnpkg.com/)

- [ ] Статьи:
    - [ ] [Пакетный менеджер (Backend)](backend-dependency-manager.md)
    - [ ] [npm для простых смертных (habrahabr)](https://habrahabr.ru/post/243335/)

---

### CSS фреймворки [&uarr;](#Содержание)
- [ ] Список фреймворков:
    - [ ] [Bootstrap](http://getbootstrap.com/)
    - [ ] [Skeleton](http://getskeleton.com/)
    - [ ] [Foundation](http://foundation.zurb.com/)

- [ ] Статьи:
    - [ ] [Длинная телега про Бутстрап](https://gist.github.com/iAdramelk/d328b73c72cab92ef95f)

---

### JavaScript фреймворки [&uarr;](#Содержание)
Существуют разные фреймворки, не нужно изучать всё сразу, необходимо взять несколько фреймворков за основу.

Список фреймворков:
- [ ] [Angular](https://angular.io/)
- [ ] [Vue](http://vuejs.org/)
- [ ] [Svelte](https://ru.svelte.dev/)
- [ ] [Ember](http://emberjs.com/)

---

### Одностраничное приложение [&uarr;](#Содержание)
Одностраничное приложение или SPA (single page application) - сайт или веб-приложение, использующий единственный HTML-документ как оболочку для всех веб-страниц и организующий взаимодействие с пользователем через динамически подгружаемые HTML, CSS, JavaScript, обычно посредством AJAX.

- [ ] Изучить:
    - [ ] [JavaScript фреймворки](#javascript-фреймворки-)
    - [ ] Роутинг
    - [ ] Шаблонизатор
    - [ ] API, например REST
    - [ ] AJAX

- [ ] Статьи:
    - [ ] [Одностраничное приложение (wikipedia)](https://ru.wikipedia.org/wiki/%D0%9E%D0%B4%D0%BD%D0%BE%D1%81%D1%82%D1%80%D0%B0%D0%BD%D0%B8%D1%87%D0%BD%D0%BE%D0%B5_%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B5)
    - [ ] [Пишем single-page web application framework в 60 строках кода (habrahabr)](https://habrahabr.ru/post/200720/)
