from enum import Enum


class SensorType(str, Enum):
    RADONSHORTTERMAVG = "radonShortTermAvg"
    RADONLONGTERMAVG = "radonLongTermAvg"
    TEMP = "temp"
    OUTDOORTEMP = "outdoorTemp"
    HUMIDITY = "humidity"
    OUTDOORHUMIDITY = "outdoorHumidity"
    CO2 = "co2"
    VOC = "voc"
    PRESSURE = "pressure"
    OUTDOORPRESSURE = "outdoorPressure"
    PRESSUREDIFFERENCE = "pressureDifference"
    PRESSUREDIFFSTDDEV = "pressureDiffStdDev"
    PRESSUREDIFFMIN = "pressureDiffMin"
    PRESSUREDIFFMAX = "pressureDiffMax"
    LIGHT = "light"
    LUX = "lux"
    BATTERYPERCENTAGE = "batteryPercentage"
    BATTERYVOLTAGE = "batteryVoltage"
    ORIENTATION = "orientation"
    PM1 = "pm1"
    OUTDOORPM1 = "outdoorPm1"
    PM25 = "pm25"
    OUTDOORPM25 = "outdoorPm25"
    PM10 = "pm10"
    OUTDOORPM10 = "outdoorPm10"
    MOLD = "mold"
    STALEAIR = "staleAir"
    TRANSMISSIONEFFICIENCY = "transmissionEfficiency"
    VIRUSSURVIVALRATE = "virusSurvivalRate"
    VIRUSRISK = "virusRisk"
    WINDSPEED = "windSpeed"
    WINDDIRECTION = "windDirection"
    WINDGUST = "windGust"
    DEWPOINT = "dewPoint"
    CLOUDCOVER = "cloudCover"
    VISIBILITY = "visibility"
    PRECIPITATION_PROBABILITY = "precipitation_probability"
    TOTAL_PRECIPITATION = "total_precipitation"
    OUTDOORWEATHER = "outdoorWeather"
    HOURLYRADONSTANDARDDEVIATION = "hourlyRadonStandardDeviation"
    HOURLYRADON = "hourlyRadon"
    ENERGYWASTAGE = "energyWastage"
    ENERGYSCENARIOS = "energyScenarios"
    HISTORICVENTILATIONCONFIDENCE = "historicVentilationConfidence"
    DAYTIMEBASELINE = "daytimeBaseline"
    DAYTIMEPEAK = "daytimePeak"
    NIGHTBASELINE = "nightBaseline"
    HISTORICVENTILATION = "historicVentilation"
    VENTILATIONRUNNINGCONFIDENCE = "ventilationRunningConfidence"
    OCCUPANTSUPPER = "occupantsUpper"
    OCCUPANTSLOWER = "occupantsLower"
    OCCUPANTS = "occupants"
    RELATIVEOCCUPANTS = "relativeOccupants"
    VENTILATIONAMOUNT = "ventilationAmount"
    HISTORICVENTILATIONRUNNING = "historicVentilationRunning"
    VENTILATIONRUNNING = "ventilationRunning"
    RELATIVEVENTILATIONRATE = "relativeVentilationRate"
    AGGREGATED = "aggregated"
    SLA = "sla"
    PRESSUREATMINHEIGHT = "pressureAtMinHeight"
    PRESSUREATMAXHEIGHT = "pressureAtMaxHeight"
    REGULATIONPRESSURE = "regulationPressure"
    REGULATIONHEIGHT = "regulationHeight"
    ZEROPRESSUREHEIGHT = "zeroPressureHeight"
    TOTALPOWERLOST = "totalPowerLost"
    MOISTGUARD = "moistGuard"
    POTENTIALPOWERSAVED = "potentialPowerSaved"
    POTENTIALPOWERSAVEDPERCENT = "potentialPowerSavedPercent"
    ZEROHEIGHTPERCENT = "zeroHeightPercent"
    ZONE = "zone"
    CONTROLSIGNAL = "controlSignal"
    CONTROLSTATUS = "controlStatus"
    RETURNSTATE = "returnState"
    APPLIEDGAIN = "appliedGain"
    LASTBESTCONTROLSIGNAL = "lastBestControlSignal"
    LASTBESTSIGNALERROR = "lastBestSignalError"
    LASTBESTCONTROLSIGNALGAIN = "lastBestControlSignalGain"
    LASTBESTCONTROLSIGNALRECORDED = "lastBestControlSignalRecorded"
    MESSAGES = "messages"
    BALANCECONTROL = "balanceControl"
    CONTROLSIGNALSLOT01 = "controlSignalSlot01"
    CONTROLSIGNALSLOT02 = "controlSignalSlot02"
    CONTROLSIGNALSLOT03 = "controlSignalSlot03"
    CONTROLSIGNALSLOT04 = "controlSignalSlot04"
    CONTROLSIGNALSLOT05 = "controlSignalSlot05"
    CONTROLSIGNALSLOT06 = "controlSignalSlot06"
    CONTROLSIGNALSLOT07 = "controlSignalSlot07"
    CONTROLSIGNALSLOT08 = "controlSignalSlot08"
    INLETAIRCONTROL = "inletAirControl"
    POWERVOLTAGE = "powerVoltage"
    RSRP = "rsrp"
    VENTCONTROLLER = "ventController"
    SUBSAMPLESCOUNT = "subsamplesCount"
    SUBSAMPLES = "subsamples"
    BALANCEINFO = "balanceInfo"
    OUTDOORNO2 = "outdoorNo2"
    OUTDOORO3 = "outdoorO3"
    OUTDOORSO2 = "outdoorSo2"
    OUTDOORCO = "outdoorCo"
    OUTDOORNO = "outdoorNo"
    AIRLY = "airly"
    AIRLYNO2 = "airlyNo2"
    AIRLYCO = "airlyCo"
    AIRLYNO = "airlyNo"
    BACNET = "bacnet"

    def __str__(self) -> str:
        return str(self.value)
