# Airthings Web API Client

This library also provides a client for accessing the Airthings web API. The code in `wave_reader/web`
is _mostly_ generated by `openapi-python-client` using the
[official OpenAPI schema published by Airthings](https://ext-api.airthings.com/v1/api-docs).

As with any versioned schema, breaking changes are possible by upstream developments. If you notice anything that
isn't working correctly, please open a bug ticket.

Check out the [official specification to see what functionality is available](https://developer.airthings.com/api-docs).

## Usage

First, create a client:

```python
from wave_reader.web import client

handler = client.OAuth2ClientHandler(client_id, client_secret, redirect_uri)
handler.new_authorization_url()
handler.new_access_token()
client = handler.new_client()
```

Now call your endpoint and use the models:

```python
from wave_reader.web.models.get_device_detailed_response import GetDeviceDetailedResponse
from wave_reader.web.api.devices import device_info
from wave_reader.web.types import Response

response: Response[GetDeviceDetailedResponse] = device_info.sync_detailed(1234567890, client=client)
```

Or do the same thing with an async version:

```python
from wave_reader.web.models.get_device_detailed_response import GetDeviceDetailedResponse
from wave_reader.web.api.devices import device_info
from wave_reader.web.types import Response

response: Response[GetDeviceDetailedResponse] = await device_info.asyncio_detailed(1234567890, client=client)
```

All path/query params, and bodies become method arguments. In the example above, the serial number is required.

See `examples` for a concrete code sample.

## Important Notes

1. Every path/method combo becomes a Python module with four functions:
    - `sync`: Blocking request that returns parsed data (if successful) or `None`
    - `sync_detailed`: Blocking request that always returns a `Request`, optionally with `parsed` set if the request was successful.
    - `asyncio`: Like `sync` but the async instead of blocking
    - `asyncio_detailed`: Like `sync_detailed` by async instead of blocking

2. All path/query params, and bodies become method arguments.
3. If your endpoint had any tags on it, the first tag will be used as a module name for the function (my_tag above)
4. Any endpoint which did not have a tag will be in `wave_reader.web.api.default`

## Testing

The code in `api` and `models` is auto-generated and won't be covered in testing. Bugs that may occur in the future
will likely result from upstream API schema changes and that is out of our control.
