# unity3d-package-utils

Utility functionality for unity3d-package's to ease access to package assets and generated
data assets.


## Installation

```sh
$ yarn add rotorz/unity3d-package-utils
```

This package is compatible with the [unity3d-package-syncer][tool] tool. Refer to the
tools' [README][tool] for information on syncing packages into a Unity project.

[tool]: https://github.com/rotorz/unity3d-package-syncer


## Accessing read-only assets from a package

Assets that are synchronized using `unity3d-package-syncer` can be accessed in a read-only
fashion since they are nuked each time the package is updated or re-installed.

Resolve asset paths (the one's that start with "Assets/"):

```csharp
Debug.Log(PackageUtility.ResolveAssetPath("@vendor-name/my-package-name", "Language", "en-US.txt"));
// Assets/Plugins/Packages/@vendor-name/my-package-name/Language/en-US.txt

Debug.Log(PackageUtility.ResolveAssetPath("@vendor-name/my-package-name", null, "Foo.txt"));
// Assets/Plugins/Packages/@vendor-name/my-package-name/Foo.txt

Debug.Log(PackageUtility.ResolveAssetPath("my-package-name", null, "Foo.txt"));
// Assets/Plugins/Packages/my-package-name/Foo.txt

Debug.Log(PackageUtility.ResolveAssetPath("my-package-name"));
// Assets/Plugins/Packages/my-package-name
```

Resolve absolute paths of directories and files (file system paths):

```csharp
Debug.Log(PackageUtility.ResolveAssetPathAbsolute("@vendor-name/my-package-name", "Language", "en-US.txt"));
// C:\MyProject\Assets\Plugins\Packages\@vendor-name\my-package-name\Language\en-US.txt

Debug.Log(PackageUtility.ResolveAssetPathAbsolute("@vendor-name/my-package-name", null, "Foo.txt"));
// C:\MyProject\Assets\Plugins\Packages\@vendor-name\my-package-name\Foo.txt

Debug.Log(PackageUtility.ResolveAssetPathAbsolute("my-package-name", null, "Foo.txt"));
// C:\MyProject\Assets\Plugins\Packages\my-package-name\Foo.txt

Debug.Log(PackageUtility.ResolveAssetPathAbsolute("my-package-name"));
// C:\MyProject\Assets\Plugins\Packages\my-package-name
```


## Accessing mutable data assets for a package

Data assets that are generated by a package should be saved into the associated data path
so that they survive after the package is updated or re-installed.

Get asset paths (the one's that start with "Assets/"); missing directories are
automatically created so that data assets can be saved into them. If you want to resolve a
data asset path but don't want to create any missing directories, then you should use the
`ResolveDataAssetPath` and `ResolveDataAssetPathAbsolute` functions instead.

```csharp
Debug.Log(PackageUtility.GetDataAssetPath("@vendor-name/my-package-name", "Presets", "NewPreset.asset"));
// Assets/Plugins/PackageData/@vendor-name/my-package-name/Presets/NewPreset.asset

Debug.Log(PackageUtility.GetDataAssetPath("@vendor-name/my-package-name", null, "ProjectSettings.asset"));
// Assets/Plugins/PackageData/@vendor-name/my-package-name/ProjectSettings.asset

Debug.Log(PackageUtility.GetDataAssetPath("my-package-name", null, "ProjectSettings.asset"));
// Assets/Plugins/PackageData/my-package-name/ProjectSettings.asset

Debug.Log(PackageUtility.GetDataAssetPath("my-package-name"));
// Assets/Plugins/PackageData/my-package-name
```

Get absolute paths of directories and files (file system paths):

```csharp
Debug.Log(PackageUtility.GetDataAssetPathAbsolute("@vendor-name/my-package-name", "Presets", "NewPreset.asset"));
// C:\MyProject\Assets\Plugins\PackageData\@vendor-name\my-package-name\Presets\NewPreset.asset

Debug.Log(PackageUtility.GetDataAssetPathAbsolute("@vendor-name/my-package-name", null, "ProjectSettings.asset"));
// C:\MyProject\Assets\Plugins\PackageData\@vendor-name\my-package-name\ProjectSettings.asset

Debug.Log(PackageUtility.GetDataAssetPathAbsolute("my-package-name", null, "ProjectSettings.asset"));
// C:\MyProject\Assets\Plugins\PackageData\my-package-name\ProjectSettings.asset

Debug.Log(PackageUtility.GetDataAssetPathAbsolute("my-package-name"));
// C:\MyProject\Assets\Plugins\PackageData\my-package-name
```


## Contribution Agreement

This project is licensed under the MIT license (see LICENSE). To be in the best
position to enforce these licenses the copyright status of this project needs to
be as simple as possible. To achieve this the following terms and conditions
must be met:

- All contributed content (including but not limited to source code, text,
  image, videos, bug reports, suggestions, ideas, etc.) must be the
  contributors own work.

- The contributor disclaims all copyright and accepts that their contributed
  content will be released to the public domain.

- The act of submitting a contribution indicates that the contributor agrees
  with this agreement. This includes (but is not limited to) pull requests, issues,
  tickets, e-mails, newsgroups, blogs, forums, etc.
