-- ----------------------------
-- 开发时间：2021/11/27
-- 程序名称：孜然授权系统
-- 程序作者：孜然
-- 作者官网：zrv7.com
-- ----------------------------

-- ----------------------------
-- 表的结构 `zrauth_config` 系统配置
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_config`;
create table `zrauth_config` (
  `k` varchar(32) NOT NULL,
  `v` text NULL,
  PRIMARY KEY (`k`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_procedure` 授权程序
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_procedure`;
CREATE TABLE `zrauth_procedure` (
  `id` int(11) NOT NULL AUTO_INCREMENT,  
  `name` text NULL,
  `img` text NULL,
  `content` text NULL,
  `type` int(2) NOT NULL DEFAULT '1',
  `download` text NULL,
  `code` text NULL,
  `update_sql` text NULL,
  `youke_url` text NULL,
  `youke_replace` text NULL,
  `youke_agency` text NULL,
  `youke_auth` text NULL,
  `youke_cooperate` text NULL,
  `agency_url` text NULL,
  `auth_url` text NULL,
  `auth_agency` text NULL,
  `cooperate_url` text NULL,
  `cooperate_agency` text NULL,
  `cooperate_auth` text NULL,
  `cooperate_cooperate` text NULL,
  `sql_version` text NULL,
  `sql_grade` text NULL,
  `sql_update_log` text NULL,
  `sql_update_sql` text NULL,
  `no_auth` text NULL,
  `no_edtime` text NULL,
  `no_ban` text NULL,
  `no_mistake` text NULL,
  `no_ti` int(2) NOT NULL DEFAULT '1',
  `no_hm` int(2) NOT NULL DEFAULT '1',
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zrauth_procedure`(`name`, `img`, `content`, `type`, `download`, `code`, `update_sql`, `youke_url`, `youke_replace`, `youke_agency`, `youke_auth`, `youke_cooperate`, `agency_url` ,`auth_url` ,`auth_agency` ,`cooperate_url` ,`cooperate_agency` ,`cooperate_auth` ,`cooperate_cooperate` ,`sql_version` ,`sql_grade` ,`sql_update_log` ,`sql_update_sql` ,`no_auth` ,`no_edtime` ,`no_ban` ,`no_mistake` ,`no_ti` ,`no_hm` ,`time`) VALUES
('孜然导航系统', '', '孜然导航系统，孜然系列第一个程序', '1', '44226c22625cfb912a391fb9dce944cb', 'ZR/authcode.php', '无', '48', '10', '88', '388', '588', '24' ,'12' ,'44','0','0','0','588','2900','V2.9','无','无','未授权','到期','封禁','错误','1','0','2022-01-25 03:06');

-- ----------------------------
-- 表的结构 `zrauth_user` 用户字段 userid是上级ID
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_user`;
CREATE TABLE `zrauth_user` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(150) NOT NULL,
  `pwd` varchar(150) NOT NULL,
  `qq` varchar(20) DEFAULT NULL,
  `email` text NOT NULL,
  `rmb` decimal(10,2) NOT NULL DEFAULT '0.00',
  `ip` varchar(255) DEFAULT NULL,
  `api_token` varchar(255) DEFAULT NULL,
  `api_ip` varchar(255) DEFAULT NULL,
  `access_token` text,
  `time` text NOT NULL,
  `孜然导航系统_power` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `孜然导航系统_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `孜然导航系统_userid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2;

-- ----------------------------
-- 表的结构 `zrauth_url` 授权域名
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_url`;
CREATE TABLE `zrauth_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `qq` varchar(20) NULL,
  `url` text NOT NULL,
  `type` int(2) NOT NULL DEFAULT '1',
  `authcode` varchar(100) NULL,
  `ip` varchar(255) DEFAULT NULL,
  `editime` text NOT NULL,
  `time` text NOT NULL,
  `ZRid` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_km` 多程序卡密
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_km`;
CREATE TABLE `zrauth_km` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `kms` text NOT NULL,
  `qq` varchar(20) NULL,
  `power` int(2) NOT NULL DEFAULT '1',
  `user_time` text NOT NULL,
  `time` text NOT NULL,
  `type` int(2) NOT NULL DEFAULT '0',
  `ZRid` varchar(150) NOT NULL,
  `ZR_z` text NOT NULL,
  `ZR_r` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_yzf` 易支付认证
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_yzf`;
CREATE TABLE `zrauth_yzf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qq` varchar(20) NULL,
  `url` text NOT NULL,
  `editime` text NOT NULL,
  `time` text NOT NULL,
  `type` int(2) NOT NULL DEFAULT '0',
  `ZRid` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_db` 多程序盗版列表
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_db`;
CREATE TABLE `zrauth_db` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  `name` text NOT NULL,
  `qq` varchar(20) NULL,
  `admin_user` text NOT NULL,
  `admin_pwd` text NOT NULL,
  `user` text NOT NULL,
  `pwd` text NOT NULL,
  `db` text NOT NULL,
  `cronkey` text NOT NULL,
  `version` text NOT NULL,
  `authcode` text NOT NULL,
  `ip` text NOT NULL,
  `time` text NOT NULL,
  `com` text NOT NULL,
  `ZRid` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_mingdan` 黑白名单-by孜然
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_mingdan`;
CREATE TABLE IF NOT EXISTS `zrauth_mingdan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` text NOT NULL,
  `content` text NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   
  `time` text NOT NULL,     
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_qiandao` 签到奖励
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_qiandao`;
CREATE TABLE `zrauth_qiandao`(
  `id` INT(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL DEFAULT '1',
  `qq` VARCHAR(20) DEFAULT NULL,
  `rmb` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `time` datetime NOT NULL,
  `continue` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY uid (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_workorder` 工单系统
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_workorder`;
CREATE TABLE `zrauth_workorder`(
  `id` INT(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `qq` VARCHAR(11) NOT NULL,
  `content` TEXT NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   
  `time` text NOT NULL,
  `ZRid` VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_workorder_list` 工单系统
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_workorder_list`;
CREATE TABLE `zrauth_workorder_list`(
  `id` INT(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `zid` text NOT NULL,
  `user` varchar(255) DEFAULT NULL,
  `qq` VARCHAR(11) NOT NULL,
  `content` TEXT NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_chat` 在线聊天
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_chat`;
CREATE TABLE `zrauth_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_code` 发信邮箱
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_code`;
CREATE TABLE `zrauth_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` text NULL,
  `code` text NULL,
  `leixing` text NOT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 转存表中的数据 `zrauth_pay` 支付订单列表
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_pay`;
CREATE TABLE `zrauth_pay` (
  `id` INT(11) unsigned NOT NULL AUTO_INCREMENT,
  `trade_no` varchar(64) NOT NULL,
  `type` varchar(20) NULL,
  `othertype` varchar(20) NULL,
  `name` varchar(64) NULL,
  `money` varchar(32) NULL,
  `input` text NOT NULL,
  `addtime` datetime NULL,
  `endtime` datetime NULL,
  `ip` varchar(20) NULL,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_log` 运行日志-by孜然
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_log`;
CREATE TABLE `zrauth_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(20) NULL,
  `data` text NULL,
  `ip` varchar(20) DEFAULT NULL,
  `city` varchar(20) DEFAULT NULL,
  `date` datetime NOT NULL,
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_download` 下载日志
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_download`;
CREATE TABLE `zrauth_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `qq` text NOT NULL,
  `url` text NOT NULL,
  `authcode` text NOT NULL,
  `ip` text NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',   
  `time` text NOT NULL,
  `ZRid` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_post` 文章系统
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_post`;
CREATE TABLE `zrauth_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `content` text NOT NULL,
  `look` text NOT NULL ,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 表的结构 `zrauth_api` API接口列表
-- ----------------------------
DROP TABLE IF EXISTS `zrauth_api`;
CREATE TABLE `zrauth_api` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `rmb` text NOT NULL,
  `content` text NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ip` text NOT NULL,
  `time` text NOT NULL,
  `ZRid` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- 转存表中的数据 `zrauth_config`
-- ----------------------------
INSERT INTO `zrauth_config` VALUES ('admin_user', 'admin');
INSERT INTO `zrauth_config` VALUES ('admin_pwd', '123456');
INSERT INTO `zrauth_config` VALUES ('cache', '');
INSERT INTO `zrauth_config` VALUES ('name', '孜然正版程序查询');
INSERT INTO `zrauth_config` VALUES ('kfqq', '2937978586');
INSERT INTO `zrauth_config` VALUES ('email', '2937978586@qq.com');
INSERT INTO `zrauth_config` VALUES ('qqqun', '站长QQ群');
INSERT INTO `zrauth_config` VALUES ('time', '1609718400');
INSERT INTO `zrauth_config` VALUES ('sitename', '孜然授权系统');
INSERT INTO `zrauth_config` VALUES ('title', '正版查询');
INSERT INTO `zrauth_config` VALUES ('keywords', '孜然授权系统,孜然授权网,正版孜然系统,孜然网络查询中心,正版导航查询');
INSERT INTO `zrauth_config` VALUES ('description', '孜然授权系统|孜然授权网络|孜然正版系统|孜然导航系统查询|孜然站长工具|孜然多应用授权系统查询');

INSERT INTO `zrauth_config` VALUES ('sendemail', '1');
INSERT INTO `zrauth_config` VALUES ('mail_cloud', '0');
INSERT INTO `zrauth_config` VALUES ('mail_smtp', 'smtp.qq.com');
INSERT INTO `zrauth_config` VALUES ('mail_port', '465');
INSERT INTO `zrauth_config` VALUES ('mail_name', '2937978586@qq.com');
INSERT INTO `zrauth_config` VALUES ('mail_pwd', 'ymskstmyozzadgji');
INSERT INTO `zrauth_config` VALUES ('email_temp', '1');
INSERT INTO `zrauth_config` VALUES ('mail_recv', '1@qq.com');

INSERT INTO `zrauth_config` VALUES ('template', 'ZR');
INSERT INTO `zrauth_config` VALUES ('cronkey', 'ziran');

INSERT INTO `zrauth_config` VALUES ('alipay_api', '2');
INSERT INTO `zrauth_config` VALUES ('tenpay_api', '2');
INSERT INTO `zrauth_config` VALUES ('qqpay_api', '2');
INSERT INTO `zrauth_config` VALUES ('wxpay_api', '2');
INSERT INTO `zrauth_config` VALUES ('epays_open', '0');
INSERT INTO `zrauth_config` VALUES ('qqtz', '0');
INSERT INTO `zrauth_config` VALUES ('is_apisq', '1');

INSERT INTO `zrauth_config` VALUES ('qiandao_open', '1');
INSERT INTO `zrauth_config` VALUES ('qiandao_rmb', '1');
INSERT INTO `zrauth_config` VALUES ('qiandao_rmbmin', '1');
INSERT INTO `zrauth_config` VALUES ('qiandao_rmbmax', '10');
INSERT INTO `zrauth_config` VALUES ('qiandao_day', '10');