<?php
/*
 * @Team : 孜然云
 * @Author : 孜然
 * @Url : zrv7.com
 * @Date : 2021-11-27 20:46
 * @Project : 孜然授权系统
 * @Description : 基于ZR框架开发的授权系统
 * @Qq : 2937978586
 * @Wx : hhr2937978586 
 * @Email : 2937978586@qq.com
 * @Read me : 孜然授权系统，是一款多模板/多用途/多权限的授权系统
 * @Remind : 孜然授权系统受《劳动知识产权》和《计算机软件著作法》的法律保护，使用破解即违法法律
 * @Dbfk : 如果您已经使用了盗版，孜然可以通过上述两法告你，不过我是不会这么做的，如果是传播盗版那么就必定告上法院
 */
$title='调用列表';
require_once 'head.php';
if (isset($_GET['kw'])) {
    $kw = daddslashes($_GET['kw']);
    $sql = " ip like '%" . $kw . "%' or qq like '%" . $kw. "%' or uid like '%" . $kw. "%'";
    $numrows = $DB->count("SELECT count(*) from zrauth_api WHERE{$sql}");
    $con = "包含 <b>" . $kw . "</b> 共有 <b>" . $numrows . "</b> API调用";
    $link = "&kw=" . $kw;
} else {
    $sql = " 1";
    $numrows = $DB->count("SELECT count(*) from zrauth_api");
    $con = "共有 <b>" . $numrows . "</b> 条API调用";
}
$pagesize=100;
$pages=intval($numrows/$pagesize);
if ($numrows%$pagesize) {
    $pages++;
}
if (isset($_GET['page'])) {
    $page=intval($_GET['page']);
} else {
    $page=1;
}
$offset=$pagesize*($page - 1);
?>
<div class="layui-fluid">
    <div class="layui-card">
        <div class="layui-card-header">API调用列表</div>
        <div class="layui-card-body layui-form">
            <!-- 表格工具栏 -->
            <blockquote class="layui-elem-quote"><b><?php echo $conf['name'];?></b><?php echo $con?></blockquote>
            <form class="layui-form toolbar">
                <div class="layui-form-item">
                    <div class="layui-inline">
                        <input type="text" class="layui-input" name="kw" placeholder="请输入IP或QQ或UID">
                    </div>
                    <div class="layui-inline">
                        <button type="button" class="layui-btn icon-btn" lay-submit lay-filter="search"><i class="layui-icon layui-icon-search"></i>搜索</button>
                        <?php echo (isset($_GET['kw']))?'<a href="api_list.php" class="layui-btn layui-btn-primary">查看全部</a>':'';?>
                    </div>
                </div>
            </form>
              <div class="layui-tab layui-tab-brief layadmin-latestData">
                <ul class="layui-tab-title">
                  <?php
                  $i1=0;
                  $rs1=$DB->query("SELECT * FROM zrauth_procedure WHERE type=1 order by id asc");    
                  while($res = $DB->fetch($rs1)) {
                  $i1++;
                  if($i1==1){
                  $checked='class="layui-this"';
                  }else{
                  $checked='';
                  }
                  if($res['type']==1){
                  echo '<li '.$checked.'>'.$res['name'].'</li>';
                  }
                  }
                  ?>
                  </ul>
                  <div class="layui-tab-content">
                  
                  <?php
                  $i2=0;
                  $rs2=$DB->query("SELECT * FROM zrauth_procedure WHERE type=1 order by id asc");
                  while($rescx = $DB->fetch($rs2)) {
                  
                  $zr1 = $DB->count("SELECT count(*) from zrauth_api WHERE {$sql} and `ZRid` = '".$rescx['id']."' ");
                  
                  $i2++;
                  if($i2==1){
                  $checked='layui-show';
                  }else{
                  $checked='';
                  }
                  ?>
                 <div class="layui-tab-item <?php echo $checked;?>">
            <form name="form1" id="form1">
            <blockquote class="layui-elem-quote">
            <h5>程序【<?php echo $rescx['name'];?>】中有<?php echo $zr1;?>条API调用</h5>
            </blockquote>
            <div style="white-space:nowrap;overflow-x: auto;">
                <table class="layui-table layuiadmin-page-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>上级</th>
                            <th>扣费</th>
                            <th>内容</th>
                            <th>类型</th>
                            <th>IP</th>
                            <th>时间</th>
                            <th>操作</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    $rs=$DB->query("SELECT * FROM zrauth_api WHERE{$sql} and `ZRid` = '".$rescx['id']."' order by id desc limit $offset,$pagesize");
                    while($res = $DB->fetch($rs)) {
                    if ($res['type']==1) { //授权接口
	                $type='<span lay-direction="1" lay-bg="#4facfe" class="layui-badge layui-badge-green">授权接口</span>';                    
                    } else if ($res['type']==2) { //代理接口
	                $type='<span lay-direction="1" lay-bg="#4facfe" class="layui-badge layui-badge-blue">代理接口</span>';                    
                    } else { //未匹配
	                $type='<span lay-direction="1" lay-bg="#4facfe" class="layui-badge layui-badge-red">类型异常</span>';                    
                    }
                    ?>
                        <tr>
                            <td><?php echo $res['id']?></td>
                            <td>UID:<?php echo $res['uid']?></td>
                            <td><?php echo $res['rmb']?>元</td>
                            <td><?php echo $res['content']?></td>
                            <td><?php echo $type?></td>
                            <td><?php echo $res['ip']?></td>
                            <td><?php echo $res['time']?></td>
                            <td>
                            <a class="layui-btn layui-btn-sm layui-btn-danger" href="javascript:del(<?php echo $res['id']?>)" lay-filter="del<?php echo $res['id']?>"><i class="layui-icon layui-icon-delete"></i>删除</a>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
            </form>
                 </div>
                 <?php } ?>
            <?php
            echo '<div class="layui-laypage layui-laypage-default">';
            $prev = $page - 1;
            $next = $page + 1;
            if ($page > 1) {
                echo '<a href="api_list.php?page='.$prev.$link.'" class="layui-laypage-prev" data-page="'.$prev.$link.'">上一页</a>';
            } else {
                echo '<a class="layui-laypage-prev layui-disabled"  lay-tips="<img src=\'../assets/img/logo.png\' style=\'width:24px;height:24px;border-radius: 50%;\'/>&nbsp;&nbsp;没有更多页面了哦" lay-bg="#803ed9" lay-bgImg="linear-gradient(to right,#8510FF,#D025C2,#FF8B2D,#F64E2C)" data-page="'.$prev.$link.'">上一页</a>';
            }
            for ($i=1;$i<$page;$i++) {
                echo '<a href="api_list.php?page='.$i.$link.'" data-page="'.$i .'">'.$i .'</a>';
            }
            echo '<span class="layui-laypage-curr" lay-tips="<img src=\'../assets/img/logo.png\' style=\'width:24px;height:24px;border-radius: 50%;\'/>&nbsp;&nbsp;已是第'.$page.'页" lay-bg="#803ed9" lay-bgImg="linear-gradient(to right,#8510FF,#D025C2,#FF8B2D,#F64E2C)"><em class="layui-laypage-em"></em><em>'.$page.'</em></span>';
            if ($pages >= 10) {
                $s = 10;
            } else {
                $s = $pages;
            }
            for ($i=$page+1;$i<=$s;$i++) {
                echo '<a href="api_list.php?page='.$i.$link.'" data-page="'.$i .'">'.$i .'</a>';
            }
            echo '';
            if ($page < $pages) {
                echo '<a href="api_list.php?page='.$next.$link.'" class="layui-laypage-next" data-page="'.$next.$link.'">下一页</a>';
            } else {
                echo '<a class="layui-laypage-next layui-disabled" lay-tips="<img src=\'../assets/img/logo.png\' style=\'width:24px;height:24px;border-radius: 50%;\'/>&nbsp;&nbsp;没有更多页面了哦" lay-bg="#803ed9" lay-bgImg="linear-gradient(to right,#8510FF,#D025C2,#FF8B2D,#F64E2C)" data-page="'.$last.$link.'">下一页</a>';
            }
            echo '</div>';
            ?>
        </div>
    </div>
</div>
<script type="text/javascript">
layui.use(['form', 'element','layer','dropdown','jquery', 'admin', 'tagsInput', 'notice'], function () {
    var form = layui.form;
    var $ = layui.jquery;
    var tagsInput = layui.tagsInput;
    var admin = layui.admin;
    var notice = layui.notice;
    form.on('submit(search)', function (data) {
        var kw=$("input[name='kw']").val();
        window.location.href = 'api_list.php?kw='+kw;
    });
});
//删除API调用
function del(id) {
    layui.use(['form', 'element','layer','dropdown','jquery', 'admin', 'tagsInput', 'notice'], function () {
        var form = layui.form;
        var $ = layui.jquery;
        var tagsInput = layui.tagsInput;
        var admin = layui.admin;
        var notice = layui.notice;
        var confirmobj = parent.layui.admin.confirm('你确实要删除此API调用吗？', {
            icon: 3, btn: ['确定','取消']
        }, function(){
            parent.layer.close(confirmobj);
            var ii = layer.load(2, {shade:[0.1,'#fff']});
            notice.destroy();
            $.ajax({
                type : 'GET',
                url : 'ajax/url_ajax.php?act=api_del&id='+id,
                dataType : 'json',
                success : function(data) {
                    layer.close(ii);
                    if (data.code == 0) {
                        notice.msg(data.msg, {animateInside: true, icon: 1});
                        setTimeout(function(){
                            window.location.reload();
                        },1000);
                    } else {
                        notice.msg(data.msg, {animateInside: true, icon: 2});
                    }
                },
                error:function(data){
                    notice.msg('服务器错误', {animateInside: true, icon: 2});
                    return false;
                }
            });
        }, function(){
            parent.layer.close(confirmobj);
        });
    });
}
</script>