<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,height=device-height,initial-scale=1.0,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
  <title>404 Not Found</title>
  <style>
    body {
      padding: 0;
      margin: 0;
    }

    main {
      position: fixed;
      background: #333;
      font: 16em/0 arial;
      width: 100%;
      height: 100%;
    }

    .text-line {
      font-size: .5em;
    }

    .text-line2 {
      font-size: .2em;
    }

    svg {
      width: 100%;
      height: 100%;
    }

    .text-copy {
      fill: none;
      stroke: white;
      stroke-dasharray: 7% 28%;
      stroke-width: 3px;
      -webkit-animation: stroke-offset 8s infinite linear;
      animation: stroke-offset 8s infinite linear;
    }

    .text-copy:nth-child(1) {
      stroke: #360745;
      stroke-dashoffset: 7%;
    }

    .text-copy:nth-child(2) {
      stroke: #d61c59;
      stroke-dashoffset: 14%;
    }

    .text-copy:nth-child(3) {
      stroke: #e7d84b;
      stroke-dashoffset: 21%;
    }

    .text-copy:nth-child(4) {
      stroke: #efeac5;
      stroke-dashoffset: 28%;
    }

    .text-copy:nth-child(5) {
      stroke: #1b8798;
      stroke-dashoffset: 35%;
    }

    @-webkit-keyframes stroke-offset {
      50% {
        stroke-dashoffset: 35%;
        stroke-dasharray: 0 87.5%;
      }
    }

    @keyframes stroke-offset {
      50% {
        stroke-dashoffset: 35%;
        stroke-dasharray: 0 87.5%;
      }
    }

    .back {
      position: absolute;
      display: block;
      bottom: 15%;
      width: 100%;
      text-align: center;
    }

    .back a {
      color: #fff;
      font-size: 18px;
      padding: 8px 16px;
      border: 1px solid #fff;
      border-radius: 25px;
      text-decoration: none;
      -webkit-transition: color, background .3s;
      -moz-transition: color, background .3s;
      -o-transition: color, background .3s;
      transition: color, background .3s;
    }

    .back a:hover {
      color: #000;
      background: #fff;
    }
  </style>
</head>
<body>
<main>
  <svg viewBox="0 -40 600 320">
    <symbol id="s-text">
      <text text-anchor="middle" x="50%" y="40%" class="text-line">404</text>
      <text text-anchor="middle" x="50%" y="60%" class="text-line2">Not Found</text>
    </symbol>
    <g class="g-ants">
      <use xlink:href="#s-text" class="text-copy"></use>
      <use xlink:href="#s-text" class="text-copy"></use>
      <use xlink:href="#s-text" class="text-copy"></use>
      <use xlink:href="#s-text" class="text-copy"></use>
      <use xlink:href="#s-text" class="text-copy"></use>
    </g>
  </svg>
  <div class="back">
    <a href="">返回首页</a>
    <a href="//zrv7.com">购买授权</a>
  </div>
</main>
</body>
</html>