# Literature

During Cadwyn's development, I went through countless resources on API Versioning. The following are the most unique and effective ones I could find.

## Cadwyn-like API Versioning

### Articles

* [API Versioning at Stripe](https://stripe.com/blog/api-versioning)
* [API Versioning at Intercom](https://www.intercom.com/blog/api-versioning/)
* [Rolling Versions at Convoy](https://getconvoy.io/blog/rolling-versions)
* [Breaking Things Without Breaking Things at Keygen](https://keygen.sh/blog/breaking-things-without-breaking-things/)
* [API Versioning at LinkedIn Marketing](https://engineering.linkedin.com/blog/2022/-under-the-hood--how-we-built-api-versioning-for-linkedin-market)

### Projects

#### Python

* [Django REST Framework Versioning](https://github.com/binnev/djangorestframework_versioning)

#### Golang

* [Pinned](https://github.com/sjkaliski/pinned)
* [Request Migrations for Go](https://github.com/subomi/requestmigrations) (by the author of Convoy)

#### Ruby

* [Gates](https://github.com/phillbaker/gates)
* [Request Migrations for Ruby](https://github.com/keygen-sh/request_migrations)

#### PHP

* [Laravel API Migrations](https://github.com/lukepolo/laravel-api-migrations)
* [Request Migrations for PHP](https://github.com/tomschlick/request-migrations)

## Overview articles on API Versioning

* [Developing an API](https://smartlogic.io/blog/2012-12-12-developing-an-api/)
* [The tricks of API Versioning](https://thenewstack.io/tricks-api-versioning/)
* [Versioning API in Django REST Framework](https://studygyaan.com/django/versioning-api-in-django-rest-framework)

## Other articles on API Versioning

* [Postman API Platform: API Versioning](https://www.postman.com/api-platform/api-versioning/)
* [Four REST API Versioning Strategies](https://www.xmatters.com/blog/blog-four-rest-api-versioning-strategies)
* [The Ultimate Guide to Microservices Versioning Best Practices](https://www.opslevel.com/resources/the-ultimate-guide-to-microservices-versioning-best-practices)
* [ASP.NET API Versioning on GitHub](https://github.com/dotnet/aspnet-api-versioning)
* [API Versioning at SuperJob](https://habr.com/ru/companies/superjob/articles/577650/)
* [Better API Versioning with Semantic Versioning in Django REST Framework](https://mikehelmick.medium.com/django-rest-framework-better-api-versioning-with-semantic-versioning-d93908613dea)
* [How Badoo Versions its API for internal clients](https://youtu.be/M2KCu0Oq3JE)
