## 语音合成极速版API
### 中英文语音极速合成版本
* 100毫秒极速识别
* 支持中英文混合文本
* 支持感情表达
#### URL
**`https://tts-dev.abcpen.com/v3/tts/emotion1/gen`**
中英文的语音合成

#### KEY
* 使用之前，请向商务申请appKey和appSecret, 以正常服务请求。
#### 请求参数：

* 以HTTPS POST(**x-www-form-urlencoded**)请求发送

|    参数    | 数据类型 | 是否必须 | 说明                                                         | 默认值    |
| :--------: | -------- | -------- | :----------------------------------------------------------- | --------- |
|    text    | String   | 是       | 待合成的中英文文本，需统一编码成utf-8格式                    |           |
|  emotion   | String   | 否       | 该段文本的情感， "neutral" (自然),  "happy"（开心）, "angry"（生气）, "sad"（悲伤）, "fear"（恐惧）, "hate"（厌恶）, "surprise"(惊讶) | "普通"    |
| speaker_id | String   | 否       | 语音合成的具体的模特发音id号，支持2000多种模特发音           | "1000"    |
|   speed    | float    | 语速     | 分为： " x-slow", "slow",  "medium", " fast",  "x-fast", "default" | "default" |
| audio_type | string   | 声音类型 | 可不填，不填时默认为 5。<br/>audioType=3 返回 16K 采样率的 mp3 <br/>audioType=4 返回 8K 采样率的 mp3 <br/>audioType=5 返回 24K 采样率的 mp3<br/>audioType=6 返回 48k采样率的mp3 <br/>audioType=7 返回 16K 采样率的 pcm 格式<br/>audioType=8 返回 8K 采样率的 pcm 格式<br/>audioType=9 返回 24k 采样率的pcm格式<br/>audioType=10 返回  8K 采样率的 wav 格式<br/>audioType=11 返回 16K 采样率的 wav 格式 <br/> | "5"       |

#### 返回参数

```json
{"code":"0","msg":"success","data":{"audio_url":"https://zos.abcpen.com/tts/test1/20231127/audio/28386da3-92c5-484b-9a4d-73a29d215be1.wav","time":0.132161537068896}}
```
#### 代码示例
参考 [极速版本代码示例](../python/fast_tts.py)


### 语音合成模特
#### 极速版本总计有2014个模特发音，具体有如下选择。 请从中选择一个具体的数字字符串
```
['16', '19', '20', '25', '26', '27', '28', '29', '30', '31', '32', '36', '37', '38', '39', '40', '44', '45', '46', '47', '49', '51', '52', '55', '56', '57', '58', '60', '62', '64', '65', '66', '70', '75', '77', '78', '81', '82', '83', '85', '87', '89', '90', '91', '92', '93', '94', '98', '101', '102', '103', '104', '107', '110', '111', '112', '118', '119', '122', '123', '125', '126', '127', '128', '133', '147', '150', '151', '152', '153', '154', '159', '161', '163', '167', '168', '173', '175', '176', '177', '188', '196', '198', '199', '200', '201', '202', '203', '204', '205', '207', '208', '209', '210', '211', '215', '218', '224', '225', '226', '227', '228', '229', '231', '233', '238', '240', '242', '243', '245', '248', '249', '250', '252', '253', '254', '255', '258', '263', '264', '265', '272', '273', '274', '277', '278', '283', '289', '294', '298', '302', '303', '307', '310', '311', '313', '317', '319', '322', '331', '332', '335', '336', '337', '340', '345', '348', '353', '362', '365', '366', '369', '373', '374', '377', '380', '392', '398', '402', '403', '404', '405', '408', '409', '412', '413', '421', '426', '428', '432', '439', '444', '446', '448', '451', '453', '454', '458', '459', '460', '466', '470', '472', '474', '475', '476', '479', '480', '481', '483', '489', '497', '505', '517', '534', '542', '544', '551', '557', '567', '568', '569', '572', '576', '580', '581', '583', '584', '585', '587', '589', '593', '594', '597', '598', '608', '613', '614', '622', '625', '636', '637', '639', '644', '663', '664', '667', '669', '679', '681', '684', '690', '696', '705', '708', '711', '712', '713', '716', '718', '720', '726', '727', '728', '730', '731', '737', '742', '753', '766', '770', '774', '778', '779', '780', '781', '782', '783', '789', '791', '792', '797', '803', '807', '810', '811', '815', '816', '820', '826', '829', '830', '831', '836', '839', '844', '845', '846', '850', '851', '868', '876', '882', '884', '886', '887', '895', '909', '911', '915', '921', '922', '923', '925', '927', '937', '949', '951', '956', '957', '960', '964', '969', '976', '978', '979', '982', '984', '985', '986', '1006', '1012', '1018', '1025', '1027', '1028', '1034', '1040', '1046', '1049', '1050', '1051', '1052', '1058', '1061', '1065', '1066', '1069', '1079', '1081', '1084', '1085', '1088', '1092', '1093', '1094', '1096', '1097', '1098', '1107', '1110', '1112', '1116', '1121', '1124', '1132', '1152', '1154', '1160', '1161', '1165', '1166', '1168', '1171', '1175', '1179', '1182', '1183', '1184', '1187', '1195', '1200', '1222', '1224', '1225', '1226', '1230', '1235', '1239', '1246', '1250', '1252', '1258', '1259', '1260', '1261', '1263', '1265', '1266', '1271', '1274', '1280', '1283', '1291', '1296', '1298', '1311', '1313', '1323', '1331', '1334', '1335', '1336', '1341', '1342', '1343', '1347', '1349', '1353', '1355', '1363', '1365', '1367', '1370', '1373', '1374', '1379', '1384', '1387', '1392', '1403', '1414', '1417', '1421', '1422', '1425', '1430', '1444', '1445', '1447', '1448', '1455', '1460', '1463', '1469', '1474', '1485', '1487', '1492', '1494', '1495', '1498', '1502', '1505', '1509', '1513', '1535', '1536', '1544', '1545', '1547', '1552', '1553', '1556', '1559', '1563', '1564', '1566', '1569', '1571', '1572', '1578', '1579', '1593', '1594', '1595', '1601', '1603', '1607', '1614', '1618', '1621', '1624', '1633', '1636', '1639', '1641', '1643', '1645', '1646', '1647', '1648', '1653', '1664', '1665', '1668', '1674', '1679', '1680', '1681', '1685', '1690', '1691', '1693', '1695', '1696', '1699', '1704', '1705', '1708', '1710', '1714', '1717', '1721', '1726', '1731', '1733', '1736', '1737', '1743', '1746', '1748', '1750', '1754', '1756', '1757', '1760', '1765', '1767', '1769', '1772', '1773', '1777', '1779', '1780', '1784', '1789', '1795', '1801', '1804', '1809', '1811', '1813', '1815', '1819', '1825', '1826', '1828', '1841', '1844', '1846', '1849', '1851', '1859', '1863', '1867', '1868', '1870', '1874', '1878', '1885', '1898', '1901', '1903', '1913', '1920', '1923', '1924', '1926', '1931', '1938', '1943', '1944', '1963', '1968', '1970', '1974', '1977', '1985', '1987', '1989', '1992', '2001', '2002', '2003', '2004', '2007', '2010', '2012', '2013', '2021', '2026', '2039', '2042', '2046', '2050', '2051', '2060', '2061', '2062', '2063', '2067', '2068', '2089', '2090', '2092', '2096', '2100', '2104', '2110', '2113', '2122', '2127', '2133', '2136', '2140', '2143', '2148', '2149', '2152', '2156', '2159', '2167', '2182', '2185', '2194', '2195', '2196', '2198', '2208', '2229', '2230', '2234', '2237', '2238', '2240', '2246', '2254', '2256', '2262', '2269', '2270', '2272', '2273', '2275', '2276', '2279', '2284', '2288', '2289', '2292', '2294', '2297', '2299', '2301', '2309', '2312', '2319', '2339', '2341', '2346', '2351', '2356', '2361', '2364', '2368', '2374', '2380', '2384', '2391', '2393', '2397', '2401', '2404', '2405', '2407', '2416', '2436', '2437', '2445', '2448', '2485', '2487', '2488', '2491', '2494', '2496', '2498', '2499', '2504', '2512', '2514', '2517', '2518', '2522', '2526', '2531', '2541', '2544', '2545', '2552', '2553', '2568', '2570', '2573', '2574', '2577', '2587', '2588', '2589', '2598', '2606', '2607', '2624', '2628', '2638', '2652', '2654', '2660', '2671', '2673', '2674', '2676', '2691', '2694', '2712', '2724', '2730', '2733', '2735', '2740', '2741', '2748', '2754', '2762', '2764', '2769', '2775', '2785', '2787', '2812', '2817', '2825', '2827', '2834', '2836', '2843', '2853', '2854', '2882', '2893', '2895', '2909', '2910', '2911', '2919', '2920', '2925', '2930', '2943', '2946', '2952', '2960', '2967', '2971', '2975', '2979', '2985', '2988', '2989', '2990', '2992', '2997', '2998', '2999', '3003', '3006', '3008', '3020', '3021', '3025', '3033', '3045', '3046', '3053', '3054', '3060', '3063', '3079', '3082', '3088', '3090', '3094', '3097', '3098', '3100', '3105', '3109', '3112', '3114', '3118', '3119', '3125', '3132', '3135', '3137', '3138', '3142', '3143', '3144', '3148', '3157', '3168', '3172', '3179', '3180', '3192', '3196', '3214', '3215', '3224', '3227', '3230', '3235', '3238', '3240', '3242', '3244', '3245', '3257', '3258', '3259', '3261', '3268', '3271', '3272', '3274', '3285', '3288', '3289', '3290', '3307', '3314', '3318', '3319', '3334', '3340', '3346', '3356', '3357', '3361', '3370', '3373', '3374', '3379', '3380', '3381', '3389', '3394', '3400', '3409', '3411', '3417', '3433', '3436', '3440', '3446', '3448', '3465', '3467', '3470', '3479', '3482', '3486', '3488', '3490', '3500', '3503', '3513', '3521', '3526', '3537', '3541', '3546', '3547', '3551', '3553', '3554', '3557', '3559', '3564', '3567', '3571', '3584', '3587', '3588', '3592', '3595', '3598', '3606', '3607', '3618', '3630', '3638', '3641', '3645', '3647', '3650', '3654', '3656', '3657', '3664', '3665', '3675', '3679', '3681', '3691', '3698', '3699', '3703', '3723', '3728', '3733', '3738', '3744', '3747', '3757', '3779', '3780', '3781', '3783', '3793', '3796', '3798', '3807', '3819', '3830', '3835', '3843', '3845', '3848', '3851', '3852', '3857', '3864', '3866', '3867', '3869', '3871', '3876', '3879', '3885', '3894', '3895', '3896', '3905', '3906', '3909', '3911', '3912', '3922', '3923', '3925', '3926', '3928', '3934', '3945', '3947', '3955', '3959', '3962', '3969', '3972', '3977', '3979', '3982', '3983', '3990', '3992', '3994', '4005', '4009', '4010', '4013', '4014', '4015', '4017', '4018', '4019', '4020', '4021', '4034', '4039', '4042', '4044', '4051', '4054', '4057', '4059', '4063', '4064', '4071', '4078', '4085', '4088', '4090', '4098', '4104', '4108', '4110', '4111', '4122', '4137', '4138', '4145', '4152', '4156', '4160', '4161', '4172', '4174', '4179', '4189', '4191', '4192', '4193', '4195', '4196', '4205', '4211', '4214', '4216', '4217', '4218', '4225', '4234', '4235', '4238', '4243', '4257', '4262', '4263', '4267', '4273', '4277', '4280', '4295', '4297', '4305', '4310', '4313', '4321', '4327', '4331', '4335', '4340', '4344', '4345', '4352', '4356', '4362', '4363', '4379', '4381', '4396', '4397', '4402', '4406', '4407', '4411', '4415', '4420', '4422', '4423', '4427', '4428', '4433', '4434', '4441', '4442', '4443', '4447', '4455', '4463', '4474', '4480', '4481', '4484', '4487', '4490', '4492', '4495', '4511', '4513', '4519', '4520', '4535', '4545', '4546', '4549', '4563', '4576', '4583', '4586', '4591', '4592', '4594', '4598', '4599', '4640', '4652', '4659', '4660', '4667', '4680', '4681', '4687', '4693', '4697', '4699', '4701', '4703', '4705', '4706', '4710', '4712', '4719', '4731', '4738', '4741', '4742', '4744', '4748', '4750', '4757', '4766', '4767', '4771', '4773', '4779', '4788', '4791', '4799', '4800', '4806', '4813', '4821', '4824', '4830', '4836', '4837', '4841', '4846', '4848', '4853', '4854', '4859', '4860', '4863', '4872', '4894', '4898', '4899', '4910', '4915', '4926', '4930', '4931', '4936', '4948', '4955', '4958', '4959', '4964', '4965', '4969', '4973', '4979', '4991', '4993', '5000', '5002', '5005', '5007', '5009', '5013', '5019', '5022', '5023', '5029', '5036', '5038', '5039', '5043', '5044', '5045', '5049', '5054', '5060', '5062', '5076', '5077', '5082', '5092', '5093', '5101', '5104', '5115', '5118', '5123', '5132', '5133', '5136', '5141', '5147', '5152', '5154', '5157', '5163', '5164', '5172', '5181', '5183', '5185', '5186', '5189', '5190', '5192', '5198', '5199', '5217', '5220', '5224', '5230', '5233', '5239', '5242', '5244', '5245', '5246', '5248', '5252', '5261', '5269', '5271', '5278', '5280', '5285', '5287', '5290', '5293', '5296', '5299', '5304', '5321', '5322', '5325', '5328', '5333', '5337', '5339', '5340', '5350', '5355', '5361', '5375', '5379', '5386', '5389', '5390', '5393', '5400', '5401', '5405', '5412', '5424', '5429', '5439', '5445', '5456', '5459', '5460', '5463', '5468', '5471', '5480', '5487', '5506', '5513', '5514', '5538', '5545', '5561', '5565', '5567', '5569', '5583', '5604', '5606', '5620', '5628', '5635', '5636', '5641', '5649', '5652', '5653', '5660', '5661', '5665', '5671', '5678', '5682', '5684', '5688', '5700', '5703', '5717', '5719', '5720', '5723', '5724', '5725', '5727', '5733', '5735', '5740', '5746', '5750', '5756', '5765', '5767', '5772', '5776', '5778', '5781', '5784', '5789', '5791', '5796', '5802', '5808', '5809', '5810', '5825', '5826', '5831', '5837', '5840', '5854', '5860', '5867', '5874', '5876', '5886', '5890', '5893', '5894', '5906', '5909', '5910', '5911', '5913', '5914', '5929', '5933', '5935', '5940', '5949', '5951', '5952', '5968', '5970', '5975', '5977', '5979', '5980', '5983', '5993', '6000', '6003', '6006', '6009', '6010', '6014', '6019', '6025', '6030', '6035', '6051', '6060', '6064', '6065', '6072', '6076', '6077', '6078', '6080', '6081', '6084', '6087', '6088', '6097', '6098', '6099', '6102', '6106', '6111', '6119', '6120', '6121', '6126', '6127', '6131', '6135', '6138', '6139', '6145', '6147', '6153', '6159', '6173', '6177', '6178', '6181', '6184', '6188', '6196', '6199', '6209', '6211', '6221', '6224', '6227', '6232', '6233', '6235', '6242', '6248', '6249', '6251', '6254', '6272', '6276', '6281', '6284', '6286', '6288', '6294', '6300', '6308', '6311', '6317', '6323', '6324', '6330', '6332', '6333', '6339', '6346', '6351', '6352', '6353', '6356', '6358', '6364', '6367', '6368', '6370', '6377', '6378', '6385', '6391', '6395', '6399', '6402', '6406', '6407', '6411', '6415', '6418', '6436', '6437', '6446', '6454', '6458', '6459', '6476', '6482', '6484', '6488', '6492', '6494', '6499', '6505', '6506', '6512', '6513', '6529', '6531', '6533', '6534', '6535', '6538', '6539', '6540', '6548', '6549', '6550', '6553', '6557', '6563', '6567', '6568', '6574', '6575', '6583', '6590', '6594', '6609', '6610', '6614', '6620', '6625', '6627', '6636', '6637', '6643', '6652', '6660', '6668', '6670', '6671', '6673', '6674', '6676', '6685', '6686', '6687', '6689', '6690', '6694', '6695', '6701', '6705', '6707', '6709', '6713', '6724', '6726', '6727', '6733', '6735', '6741', '6743', '6746', '6747', '6749', '6752', '6753', '6754', '6758', '6773', '6777', '6784', '6788', '6792', '6794', '6798', '6804', '6807', '6818', '6821', '6836', '6846', '6848', '6849', '6853', '6865', '6875', '6877', '6880', '6882', '6883', '6892', '6895', '6902', '6906', '6912', '6913', '6914', '6918', '6923', '6924', '6925', '6927', '6943', '6945', '6947', '6950', '6951', '6954', '6962', '6963', '6965', '6967', '6974', '6978', '7000', '7001', '7008', '7009', '7011', '7012', '7026', '7030', '7046', '7051', '7055', '7059', '7061', '7062', '7065', '7067', '7069', '7073', '7078', '7079', '7090', '7092', '7095', '7096', '7097', '7107', '7113', '7117', '7121', '7125', '7128', '7131', '7134', '7135', '7138', '7139', '7143', '7147', '7148', '7150', '7155', '7169', '7170', '7177', '7178', '7188', '7189', '7190', '7197', '7198', '7199', '7205', '7208', '7215', '7218', '7220', '7223', '7226', '7228', '7229', '7238', '7239', '7240', '7242', '7245', '7246', '7247', '7250', '7255', '7263', '7264', '7265', '7277', '7278', '7285', '7286', '7299', '7301', '7302', '7307', '7312', '7313', '7315', '7320', '7326', '7327', '7331', '7333', '7337', '7338', '7342', '7346', '7348', '7354', '7357', '7360', '7367', '7376', '7383', '7387', '7389', '7391', '7392', '7395', '7398', '7402', '7408', '7416', '7423', '7424', '7433', '7436', '7445', '7447', '7448', '7460', '7463', '7467', '7475', '7478', '7480', '7491', '7492', '7495', '7498', '7502', '7505', '7507', '7510', '7511', '7512', '7514', '7515', '7517', '7518', '7520', '7522', '7525', '7538', '7540', '7552', '7553', '7555', '7556', '7558', '7559', '7561', '7565', '7584', '7585', '7594', '7597', '7603', '7607', '7608', '7609', '7618', '7635', '7640', '7644', '7647', '7649', '7654', '7657', '7672', '7679', '7683', '7687', '7691', '7699', '7700', '7702', '7704', '7708', '7713', '7717', '7720', '7733', '7737', '7739', '7746', '7749', '7752', '7756', '7762', '7764', '7766', '7769', '7777', '7780', '7786', '7789', '7794', '7795', '7796', '7800', '7802', '7816', '7823', '7825', '7826', '7828', '7833', '7835', '7839', '7843', '7848', '7859', '7871', '7879', '7883', '7886', '7892', '7898', '7909', '7912', '7923', '7925', '7932', '7938', '7939', '7942', '7945', '7946', '7949', '7957', '7959', '7962', '7967', '7981', '7988', '7997', '8005', '8006', '8008', '8009', '8012', '8014', '8015', '8023', '8033', '8040', '8042', '8044', '8051', '8057', '8058', '8063', '8066', '8071', '8072', '8075', '8080', '8087', '8088', '8095', '8097', '8098', '8108', '8112', '8118', '8119', '8123', '8138', '8143', '8148', '8152', '8156', '8163', '8164', '8168', '8169', '8172', '8176', '8180', '8183', '8190', '8193', '8194', '8195', '8197', '8199', '8200', '8208', '8215', '8222', '8225', '8226', '8228', '8238', '8240', '8242', '8245', '8246', '8250', '8259', '8262', '8266', '8272', '8273', '8291', '8295', '8296', '8300', '8302', '8307', '8312', '8316', '8321', '8322', '8324', '8328', '8329', '8334', '8337', '8346', '8347', '8356', '8367', '8382', '8388', '8389', '8392', '8394', '8396', '8401', '8410', '8413', '8414', '8415', '8419', '8421', '8422', '8424', '8425', '8430', '8432', '8441', '8443', '8444', '8445', '8447', '8459', '8465', '8466', '8468', '8470', '8474', '8476', '8490', '8494', '8498', '8499', '8500', '8506', '8527', '8531', '8534', '8536', '8543', '8544', '8545', '8565', '8573', '8575', '8576', '8580', '8587', '8590', '8591', '8592', '8609', '8625', '8629', '8630', '8631', '8632', '8635', '8644', '8664', '8666', '8671', '8675', '8677', '8678', '8684', '8687', '8699', '8705', '8710', '8713', '8722', '8725', '8742', '8747', '8753', '8758', '8765', '8770', '8772', '8776', '8778', '8786', '8791', '8797', '8799', '8803', '8808', '8820', '8825', '8838', '8846', '8848', '8855', '8867', '8875', '8887', '8897', '8975', '9000', '9017', '9022', '9136', '11614', '11697', '12787']
```
### 中英文语音轻便版
* 合成速度一般在1~2秒
* 支持中英文混合文本
* 吐字更加圆润
#### URL
**`https://tts-dev.abcpen.com/v3/tts/emotion2/long`**
中英文的语音合成

#### KEY
* 使用之前，请向商务申请appKey和appSecret, 以正常服务请求。
#### 请求参数：

* 以HTTPS POST(**x-www-form-urlencoded**)请求发送

|    参数    | 数据类型 | 是否必须 | 说明                                                         | 默认值   |
| :--------: | -------- | -------- | :----------------------------------------------------------- | -------- |
|    text    | String   | 是       | 待合成的中英文文本，需统一编码成utf-8格式                    |          |
| speaker_id | String   | 否       | 语音合成的具体的模特发音id号, 具体参考[模特效果](#TTS模型列表)支持如下模特语音选择 <br/>yunxiao<br/>yunni<br/>yunbei<br/>yunyang<br/>yunxia<br/>yunxi<br/>yunjian<br/>yunyi | "yunxia" |
|   speed    | string   | 语速     | 合成语音的语速，从-100%~100%                                 | "0%"     |
|   volume   | string   | 音量     | 合成语音的音量，从-100%~100%                                 | "0%"     |
| audio_type | string   | 声音类型 | 可不填，不填时默认为 5。<br/>audioType=3 返回 16K 采样率的 mp3 <br/>audioType=4 返回 8K 采样率的 mp3 <br/>audioType=5 返回 24K 采样率的 mp3<br/>audioType=6 返回 48k采样率的mp3 <br/>audioType=7 返回 16K 采样率的 pcm 格式<br/>audioType=8 返回 8K 采样率的 pcm 格式<br/>audioType=9 返回 24k 采样率的pcm格式<br/>audioType=10 返回  8K 采样率的 wav 格式<br/>audioType=11 返回 16K 采样率的 wav 格式 <br/> | "5"      |

#### TTS模型列表

| 模特名称 | 模特特点                                                     | 男声/女声                                                    | 国家/区域 |
| -------- | ------------------------------------------------------------ | ------------------------------------------------------------ | --------- |
| 云霄     | [试听声音](https://zos.abcpen.com/zos/models/yunxiao.mp3)    | 女声，成熟女声，声音柔和纯美; 支持中英文                     | 中国/大陆 |
| 云逸     | [试听声音](https://zos.abcpen.com/zos/models/yunyi.mp3)      | 女生（少女），少女声音，柔和纯美; 支持中英文                 | 中国/大陆 |
| 云剑     | [试听声音](https://zos.abcpen.com/zos/models/yunjian.mp3)    | 男声，央视播音，富有热情; 支持中英文                         | 中国/大陆 |
| 云曦     | [试听声音](https://zos.abcpen.com/zos/models/yunxi.mp3)      | 男声，抖音配音常见风格，声音较快，充满时尚; 支持中英文       | 中国/大陆 |
| 云夏     | [试听声音](https://zos.abcpen.com/zos/models/yunxia.mp3)     | 男声（男童），抖音配音常见风格，充满激情，热情四射; 支持中英文 | 中国/大陆 |
| 云阳     | [试听声音](https://zos.abcpen.com/zos/models/yunyang.mp3)    | 男声，和“云剑”相比，更正式，更有新闻联播的风格; 支持中英文   | 中国/大陆 |
| 云北     | [试听声音](https://zos.abcpen.com/zos/models/yunbei.mp3)     | 女生，东北风格语音，有调侃说单口相声的风格; 支持中英文       | 中国/大陆 |
| 云妮     | [试听声音](https://zos.abcpen.com/zos/models/yunni.mp3)      | 女生，东北风格语音，比“云北”更具备调侃的风格; 支持中英文     | 中国/大陆 |
| 云爱     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/38a8d77a-3f1c-487d-b6d0-43f3d269a878.mp3) | 香港口音; 支持中英文                                         | 中国/香港 |
| 云安     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/70d7f9fe-f56d-4f1b-979d-3b32d526a9a8.mp3) | 香港口音; 支持中英文                                         | 中国/香港 |
| 云晚     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/f8e6b076-df47-4792-b599-fb45821854e5.mp3) | 香港口音; 支持中英文                                         | 中国/香港 |
| 云辰     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/61895f9b-ddfe-4cef-b21e-d325c5150352.mp3) | 台湾口音; 支持中英文                                         | 中国/台湾 |
| 云昀     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/75d33562-3c6e-4980-93d0-a3dd1288852e.mp3) | 台湾口音; 支持中英文                                         | 中国/台湾 |
| 云雨     | [试听语音](https://zos.abcpen.com/tts/test1/20231128/19680faa-3868-444f-b81a-5c02cbbfb60e.mp3) | 台湾口音; 支持中英文                                         | 中国/台湾 |
| Ana      |                                                              |                                                              |           |
| Chris    |                                                              |                                                              |           |
| Eric     |                                                              |                                                              |           |
| Robert   |                                                              |                                                              |           |
| Jenny    |                                                              |                                                              |           |
| Michel   |                                                              |                                                              |           |
| Roger    |                                                              |                                                              |           |
| Steff    |                                                              |                                                              |           |



#### 返回参数

```json
{"code":"0","data":{"audio_url":"https://zos.abcpen.com/tts/test1/20231128/ae1194b1-d3f6-436c-be22-e2ae5b65edb1.mp3"},"msg":"success"}
```

