package com.zjut.servlet;

import com.zjut.bean.Teacher;
import com.zjut.service.InsertScoreService;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

public class InsertScoreServlet extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        //设置编码
        req.setCharacterEncoding("UTF-8");
        HttpSession session = req.getSession(false);
        Teacher teacher = (Teacher) session.getAttribute("teacher");
        String ID = teacher.getID();
        String[] stuIdArr = req.getParameterValues("ID");
        String[] termArr = req.getParameterValues("term");
        String[] courseIdArr = req.getParameterValues("courseId");
        String[] scoreArr = req.getParameterValues("score");
        InsertScoreService insertScoreService = new InsertScoreService();
        insertScoreService.insertScore(stuIdArr, termArr, courseIdArr, scoreArr, ID);
        req.getRequestDispatcher("/teacher/scoreInsert").forward(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}
