﻿using Xunit;

namespace IntegrationTests
{
	[Collection(TestConstants.LaunchWebApiAndInit)]
	public partial class DotNetCoreSpecial : IClassFixture<SuperDemoFixture>
	{
		public DotNetCoreSpecial(SuperDemoFixture fixture)
		{
			api = fixture.Api;
		}

		readonly DemoWebApi.Controllers.Client.SuperDemo api;

		[Fact]
		public void TestGetDictionary()
		{

/* Unmerged change from project 'IntegrationTestsTextJson'
Before:
			var dic = api.GetDictionary();
After:
			IDictionary<string, dic = api.GetDictionary();
*/
			System.Collections.Generic.IDictionary<string, string> dic = api.GetDictionary();
			Assert.Equal("number", dic["System.Int64"]);
		}

		[Fact]
		public void TestGetDictionaryOfPeople()
		{

/* Unmerged change from project 'IntegrationTestsTextJson'
Before:
			var dic = api.GetDictionaryOfPeople();
After:
			IDictionary<string, DemoWebApi.DemoData.Client.Person> dic = api.GetDictionaryOfPeople();
*/
			System.Collections.Generic.IDictionary<string, DemoWebApi.DemoData.Client.Person> dic = api.GetDictionaryOfPeople();
			Assert.Equal("Tony Stark", dic["Iron Man"].Name);
			Assert.Equal("New York", dic["Spider Man"].Addresses[0].City);
			Assert.Throws<System.Collections.Generic.KeyNotFoundException>(() => dic["iron Man"].Name); //the camelCase filter is in play in the web api
		}

		[Fact]
		public void TestZeroWithFloatDoubleAndDecimal()
		{
			// Assert.NotEqual(0f, 0.1f + 0.2f - 0.3f);//In VS 2015 update 2, compiler makes it zeror.
			Assert.NotEqual(0d, 0.1d + 0.2d - 0.3d);
			Assert.Equal(0m, 0.1m + 0.2m - 0.3m);

			Assert.Equal(0, api.GetFloatZero());
			Assert.NotEqual(0, api.GetDoubleZero());//.net core is consistent in both client side and server side.
			Assert.Equal(0, api.GetDecimalZero());

		}
	}
}
