/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.service;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.config.WXAuthorizedValids;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.AuthorizedValids;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.model.WXSubscription;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WXUserService {
    RestTemplate restTemplate = new RestTemplate();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserMapper userMapper;
    @Autowired
    WXSubscription wxSubscription;
    @Autowired
    WXAuthorizedValids wxAuthorizedValids;

    public User queryUserByOpenId(String openid) {
        User user = this.userMapper.queryUserByOpenId(openid);
        return user;
    }

    public ResData addWXUser(User user) {
        User queryUserByOpenId = this.userMapper.queryUserByOpenId(user.getOpenId());
        if (queryUserByOpenId != null) {
            return ResData.ofFail((Integer)10074, (String)"\u7528\u6237\u5df2\u7ecf\u6ce8\u518c");
        }
        this.userMapper.addWXUser(user);
        User msgUser = this.userMapper.queryUserByOpenId(user.getOpenId());
        if (msgUser == null) {
            return ResData.ofFail((Integer)10073, (String)"\u65b0\u589e\u5931\u8d25");
        }
        return ResData.of((Integer)0, (String)"\u65b0\u589e\u6210\u529f", (Object)msgUser);
    }

    public ResData UserBinding(User user, String phone) {
        User userByPhone = this.userMapper.getUserByPhone(phone);
        Integer integer = this.userMapper.UserBinding(user, userByPhone.getId());
        if (integer <= 0) {
            return ResData.ofSuccess((Integer)10075, (String)"\u7ed1\u5b9a\u5931\u8d25");
        }
        User msgUser = this.userMapper.queryUserByOpenId(user.getOpenId());
        return ResData.of((Integer)0, (String)"\u7ed1\u5b9a\u6210\u529f", (Object)msgUser);
    }

    public void arrangementQR(String state, long validTime) {
        this.wxAuthorizedValids.getWxAuthorizedValids().remove(state);
        Iterator it = this.wxAuthorizedValids.getWxAuthorizedValids().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            long currTime = System.currentTimeMillis();
            if (currTime - ((AuthorizedValids)entry.getValue()).getUpdateDate() <= validTime) continue;
            it.remove();
        }
    }
}

