/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.service;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.RandomIdCreate;
import com.c1801.spring.dzy.mapper.AddrMapper;
import com.c1801.spring.dzy.mapper.CategoryMapper;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.mapper.UserOperationRecordController;
import com.c1801.spring.dzy.model.Account;
import com.c1801.spring.dzy.model.Address;
import com.c1801.spring.dzy.model.Category;
import com.c1801.spring.dzy.model.StatisticUser;
import com.c1801.spring.dzy.model.User;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private AddrMapper addrMapper;
    @Autowired
    private CategoryMapper categoryMapper;
    @Autowired
    private UserOperationRecordController userOperationRecordController;
    @Autowired
    private RandomIdCreate randomIdCreate;

    public Account userLogin(User user) {
        User tempUser = this.userMapper.getUser(user);
        Account account = new Account();
        if (tempUser == null) {
            this.logger.info("tempUser = " + user);
            Integer id = (Integer)this.randomIdCreate.getUserId().get(0);
            this.randomIdCreate.getUserId().remove(0);
            if (this.randomIdCreate.getUserId().size() < 10) {
                this.randomIdCreate.addUserId();
            }
            user.setId(id);
            int result = this.userMapper.addUser(user);
            user = this.userMapper.getUser(user);
            account.setUserId(user.getId());
            account.setUser(user);
            account.setAddress(new Address());
        } else {
            tempUser.setLoginDate(new Date());
            this.userMapper.updateLoginDate(tempUser);
            Address addr = this.addrMapper.getAddrById(tempUser.getAddrId());
            account.setUserId(tempUser.getId());
            account.setUser(tempUser);
            if (addr == null) {
                addr = new Address();
            }
            account.setAddress(addr);
        }
        return account;
    }

    public Account getAccountById(Integer id) {
        return this.userMapper.getAccount(id);
    }

    public void UserOperationRecordByBooks(Integer userId, List<Integer> bookId) {
        List categorys = this.categoryMapper.getCategoryMapByBooksId(bookId);
        for (Integer category : categorys) {
            Category temp = this.userOperationRecordController.IsUserHasCategory(userId, category);
            if (temp != null) continue;
            this.userOperationRecordController.UserRecordAdd(userId, category);
        }
    }

    public List<User> getUserListByUserIds(List<Integer> userIds) {
        List userList = this.userMapper.getUserListByUserIds(userIds);
        return userList;
    }

    public List<StatisticUser> getStatisticUserByCreaeteDate(String minDate, String maxDate) {
        List statisticUserMap = this.userMapper.statisticUserByCreaeteDate(minDate, maxDate);
        return statisticUserMap;
    }

    public PageInfo getUserListOfPage(String name, Integer pageSize, Integer pageNum, String minDate, String maxDate) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page userList = this.userMapper.queryUserListOfPage(name, minDate, maxDate);
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)userList);
        this.logger.info("userList.getTotal() = " + userList.getTotal());
        this.logger.info("pageInfo = " + pageInfo);
        return pageInfo;
    }

    public Integer queryUserEnabled(Integer id) {
        return this.userMapper.queryUserEnabled(id);
    }
}

