/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.service;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.BookCollectionMapper;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.CollectionMapper;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.BookCollectionPack;
import com.c1801.spring.dzy.model.RecommendAccount;
import com.c1801.spring.dzy.model.RecommendBook;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CollectionService {
    @Autowired
    BookMapper bookMapper;
    @Autowired
    BookCollectionMapper bookCollectionMapper;
    @Autowired
    private CollectionMapper collectionMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ResData addBookAppointCollection(RecommendBook recommendBook) {
        Book book;
        if (recommendBook.getBookId() == null) {
            book = this.bookMapper.queryBookByIBSN(recommendBook.getIsbn());
            if (book == null) {
                return ResData.ofFail((Integer)20078, (String)"\u8be5isbn\u7801\u4e0d\u5b58\u5728");
            }
            recommendBook.setBookId(book.getId());
        }
        if ((book = this.bookMapper.queryBookById(recommendBook.getBookId())) == null) {
            return ResData.ofFail((Integer)20080, (String)"\u63a8\u8350\u7684\u4e66\u7c4d\u4e0d\u5b58\u5728");
        }
        if (book.getDoubanRate() < 7.5) {
            return ResData.ofFail((Integer)20076, (String)"\u63a8\u8350\u7684\u4e66\u7c4d\u8bc4\u5206\u4e0d\u80fd\u5c11\u4e8e7.5");
        }
        RecommendBook queryMsg = this.bookCollectionMapper.queryRecommendBook(recommendBook);
        if (queryMsg != null) {
            return ResData.ofFail((Integer)20077, (String)"\u8fd9\u672c\u4e66\u5df2\u7ecf\u5b58\u5728\u4e8e\u5f53\u524d\u4e66\u5355");
        }
        this.bookCollectionMapper.addRecommendBook(recommendBook);
        RecommendBook addMsg = this.bookCollectionMapper.queryRecommendBook(recommendBook);
        if (addMsg == null) {
            return ResData.ofFail((Integer)20079, (String)"\u63a8\u8350\u5931\u8d25");
        }
        return ResData.of((Integer)0, (String)"\u63a8\u8350\u6210\u529f", (Object)addMsg);
    }

    public ResData queryRecommendAccountById(Integer id) {
        RecommendBook recommendBook = this.bookCollectionMapper.queryRecommendBookById(id);
        if (recommendBook == null) {
            return ResData.ofFail((Integer)20081, (String)"\u63a8\u8350id\u4e0d\u5b58\u5728");
        }
        RecommendAccount recommendAccount = this.bookCollectionMapper.queryRecommendAccountById(id);
        BookCollectionPack bookCollectionPack = this.bookCollectionMapper.queryCountByCollectionId(recommendAccount.getBookCollectionPack().getId());
        recommendAccount.getBookCollectionPack().setContributorsCount(bookCollectionPack.getContributorsCount());
        recommendAccount.getBookCollectionPack().setItemsCount(bookCollectionPack.getItemsCount());
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)recommendAccount);
    }

    public BookCollectionPack querySingleCollection(Integer collectionId) {
        BookCollectionPack collectionPack = this.collectionMapper.querySingleCollection(collectionId);
        if (collectionPack.getId() == null) {
            return null;
        }
        return collectionPack;
    }

    public Map<String, Object> queryRecommedList(Integer collectionId, Integer pageSize, Integer pageNum, Date lastDate, Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.logger.info(collectionId + "");
        PageHelper.startPage((int)1, (int)1);
        Page fristRecommend = this.collectionMapper.queryRecommendList(collectionId, Integer.valueOf(1), Integer.valueOf(0), userId);
        this.logger.info(collectionId + "");
        RecommendAccount recommend = null;
        if (!fristRecommend.getResult().isEmpty()) {
            recommend = (RecommendAccount)fristRecommend.getResult().get(0);
        }
        map.put("frist", recommend);
        map.put("pageInfo", null);
        if (fristRecommend.getResult().isEmpty()) {
            return map;
        }
        if (fristRecommend.getTotal() == 1L) {
            return map;
        }
        this.logger.info(recommend.getId() + "");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page recommends = this.collectionMapper.queryRecommendList(collectionId, recommend.getId(), Integer.valueOf(1), userId);
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)recommends);
        System.out.println(pageInfo.getList().get(0));
        map.put("pageInfo", pageInfo);
        return map;
    }
}

