/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.service;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.mapper.CartMapper;
import com.c1801.spring.dzy.model.Cart;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CartService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CartMapper cartMapper;

    public int addShopToCart(Integer bookId, Integer condition, Integer userId) {
        int i = this.cartMapper.queryUserCartCount(userId);
        if (i >= 100) {
            return i;
        }
        int result = this.cartMapper.addShopToCart(bookId, condition, userId);
        return result;
    }

    public int delShopFromCart(Integer cartId, Integer userId) {
        int result = this.cartMapper.delShopFromCart(cartId, userId);
        return result;
    }

    public int updateConditoinOfCart(Cart cart) {
        int result = this.cartMapper.updateConditoinOfCart(cart);
        return result;
    }

    public int updateSelectedCart(Integer cartId, Integer userId) {
        int result = this.cartMapper.updateSelectedCart(cartId, userId);
        return result;
    }

    public int updateSelectedCarts(List<Integer> cartIds, Integer selected, Integer userId) {
        int result = this.cartMapper.updateSelectedCarts(cartIds, selected, userId);
        if (result > cartIds.size()) {
            this.logger.info("\u6570\u636e\u56de\u6eda");
        }
        return result;
    }

    public Cart queryBookInCart(Integer bookId, Integer userId) {
        return this.cartMapper.queryBookInCart(bookId, userId);
    }

    public PageInfo queryHasStockCarts(Integer pageSize, Integer pageNum, Integer userId) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page carts = this.cartMapper.queryHasStockCarts(userId);
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)carts);
        return pageInfo;
    }

    public PageInfo queryStockoutCarts(Integer pageSize, Integer pageNum, Integer userId) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page carts = this.cartMapper.queryStockoutCarts(userId);
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)carts);
        return pageInfo;
    }

    public int queryHasStockCartCount(Integer userId) {
        return this.cartMapper.queryHasStockCartCount(userId);
    }
}

