/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.service;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.BookSkuMapper;
import com.c1801.spring.dzy.mapper.OrderBookRecordMapper;
import com.c1801.spring.dzy.mapper.SkuMapper;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.BookInfo;
import com.c1801.spring.dzy.model.BookSku;
import com.c1801.spring.dzy.model.OrderBookRecord;
import com.c1801.spring.dzy.model.Sku;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookService {
    @Autowired
    private BookMapper bookMapper;
    @Autowired
    private BookSkuMapper bookSkuMapper;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private OrderBookRecordMapper orderBookRecordMapper;

    public Book getBook(String isbn) {
        return this.bookMapper.queryBookByIBSN(isbn);
    }

    public PageInfo<BookInfo> queryBookInfoOfPage(String name, String author, Integer minStock, Integer maxStock, Integer minSale, Integer maxSale, Integer minStatus, Integer maxStatus, Integer pageSize, Integer pageNum, Integer nameStatus, Integer totalStatus) {
        if (minStock != null && maxStock != null && (maxStock < 0 || maxStock > minStock) || minSale != null && maxSale != null && (maxSale < 0 || maxSale > minSale) || minStatus != null && maxStatus != null && (maxStatus < 0 || maxStatus > minStatus)) {
            PageInfo pageInfo = PageInfo.ofEmpty((Integer)pageSize);
            return pageInfo;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page bookInfos = this.bookMapper.queryBookInfoList(name, author, minStock, maxStock, minSale, maxSale, minStatus, maxStatus, nameStatus, totalStatus);
        return PageInfo.ofPageInfo((Page)bookInfos);
    }

    public List<BookSku> getBookSkuList(String name, Integer pageSize, Integer pageNum) {
        return this.bookSkuMapper.queryBookSkuList(name);
    }

    public PageInfo queryIsSellBookInfoList(String name, Double rate, Integer pageSize, Integer pageNum) {
        PageHelper.startPage((int)pageNum, (int)pageSize, (String)"douban_rate desc, sale desc");
        Page bookInfos = this.bookSkuMapper.queryIsSellBookInfoList(name, rate);
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)bookInfos);
        return pageInfo;
    }

    public BookSku getBookSku(Integer bookId) {
        return this.bookSkuMapper.getBookSku(bookId);
    }

    public BookInfo getIsSellBookInfo(Integer bookId) {
        return this.bookSkuMapper.getIsSellBookInfo(bookId);
    }

    public List<BookSku> getBookSkuList(List<Integer> ids) {
        return this.bookSkuMapper.getBookSkuList(ids);
    }

    public int updateSku(Sku sku) {
        int i = this.skuMapper.updateSku(sku);
        return i;
    }

    public int delSku(Integer id) {
        return this.skuMapper.delSku(id);
    }

    public int addStock(List<OrderBookRecord> orderBookRecords) {
        int count = 0;
        for (int i = 0; i < orderBookRecords.size(); ++i) {
            Sku sku = new Sku();
            sku.setBookId(orderBookRecords.get(i).getBookId());
            sku.setCondition(orderBookRecords.get(i).getCondition());
            int result = this.skuMapper.addStock(sku);
            if (result == 0) {
                count += this.skuMapper.addSku(sku);
                continue;
            }
            ++count;
        }
        return count;
    }

    public List<Sku> querySkuByBookId(Integer bookId) {
        return this.bookSkuMapper.querySkuByBookId(bookId);
    }

    public int addOrderBookRecordMapper(List<OrderBookRecord> orderBookRecords) {
        int result = this.orderBookRecordMapper.addOrderBookRecord(orderBookRecords);
        return result;
    }
}

