/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.wx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.common.wx.qr.QRGenerate;
import com.c1801.spring.dzy.config.WXAuthorizedValids;
import com.c1801.spring.dzy.model.AuthorizedValids;
import com.c1801.spring.dzy.model.WXSubscription;
import com.c1801.spring.dzy.service.WXUserService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Transactional
@RequestMapping(value={"/dzy/wx/interface"})
public class WXController {
    private Long validTime = 300000L;
    @Autowired
    WXSubscription wxSubscription;
    @Autowired
    WXAuthorizedValids wxAuthorizedValids;
    @Autowired
    WXUserService wxUserService;
    RestTemplate restTemplate = new RestTemplate();

    @GetMapping(value={"/config"})
    public Map config(@RequestHeader(value="Referer") String url) {
        System.out.println(this.wxSubscription.getAppid());
        System.out.println(this.wxSubscription.getAppsecret());
        String forObject = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.wxSubscription.getAppid() + "&secret=" + this.wxSubscription.getAppsecret(), String.class, new Object[0]);
        JSONObject jsonObject = JSON.parseObject((String)forObject);
        String accessToken = jsonObject.getString("access_token");
        System.out.println("jsonObject = " + jsonObject);
        System.out.println("accessToken = " + accessToken);
        String jsapiTicketJSON = (String)this.restTemplate.getForObject(String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", accessToken), String.class, new Object[0]);
        JSONObject jsapiTicketJsonObject = JSON.parseObject((String)jsapiTicketJSON);
        String ticket = jsapiTicketJsonObject.getString("ticket");
        System.out.println("jsapiTicketJsonObject = " + ticket);
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("timestamp", System.currentTimeMillis() / 1000L + "");
        packageParams.put("noncestr", UUID.randomUUID().toString().replaceAll("-", ""));
        packageParams.put("jsapi_ticket", ticket);
        packageParams.put("url", url);
        Set params = packageParams.keySet();
        StringBuffer sign = new StringBuffer();
        for (String param : params) {
            if (sign.length() > 0) {
                sign.append("&");
            }
            sign.append(param).append("=").append((String)packageParams.get(param));
        }
        String sha1Sign = DigestUtils.sha1Hex((String)sign.toString());
        System.out.println("sha1Sign = " + sha1Sign);
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("appId", this.wxSubscription.getAppid());
        configParams.put("timestamp", (String)packageParams.get("timestamp"));
        configParams.put("nonceStr", (String)packageParams.get("noncestr"));
        configParams.put("signature", sha1Sign);
        System.out.println("configParams = " + configParams);
        return configParams;
    }

    @GetMapping(value={"/address"})
    public ResData getAuthorizedAddress() {
        String redirectUri = "http://wx.panqingshan.cn/scanlogin";
        String state = UUID.randomUUID().toString().replaceAll("-", "");
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.wxSubscription.getAppid() + "&redirect_uri=" + redirectUri + "&response_type=code&scope=snsapi_userinfo&state=" + state + "#wechat_redirect";
        Map packageParams = QRGenerate.getQRGenerate((String)url);
        packageParams.put("state", state);
        AuthorizedValids authorizedValids = new AuthorizedValids();
        authorizedValids.setState(state);
        authorizedValids.setUpdateDate(System.currentTimeMillis());
        this.wxAuthorizedValids.getWxAuthorizedValids().put(state, authorizedValids);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)packageParams);
    }

    @GetMapping(value={"/state"})
    public ResData QRState(@RequestParam(value="state") String state, HttpSession session) {
        AuthorizedValids authorizedValids = (AuthorizedValids)this.wxAuthorizedValids.getWxAuthorizedValids().get(state);
        System.out.println("\u5faa\u73af\u904d\u5386\u6253\u5370\uff1a" + authorizedValids);
        long currTime = System.currentTimeMillis();
        if (authorizedValids == null || currTime - authorizedValids.getUpdateDate() > this.validTime) {
            return ResData.ofFail((Integer)1017, (String)"\u8be5\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (authorizedValids.getLinkedHashMap() == null) {
            return ResData.ofFail((Integer)1018, (String)"\u5f85\u7528\u6237\u6388\u6743");
        }
        if (authorizedValids.getUser() != null) {
            this.wxUserService.arrangementQR(state, this.validTime.longValue());
            session.setAttribute("user", (Object)authorizedValids.getUser());
            return ResData.of((Integer)0, (String)"\u8001\u7528\u6237\u767b\u5f55", (Object)authorizedValids.getUser());
        }
        this.wxUserService.arrangementQR(state, this.validTime.longValue());
        session.setAttribute("userInfoMap", (Object)authorizedValids.getLinkedHashMap());
        return ResData.of((Integer)1, (String)"\u65b0\u7528\u6237\u6388\u6743", authorizedValids.getLinkedHashMap().get("headimgurl"));
    }
}

