/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.user;

import com.alibaba.fastjson.JSON;
import com.c1801.spring.dzy.common.RandomIdCreate;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.config.UserValids;
import com.c1801.spring.dzy.config.WXAuthorizedValids;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.AuthorizedValids;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.model.ValidCode;
import com.c1801.spring.dzy.model.WXSubscription;
import com.c1801.spring.dzy.service.WXUserService;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Transactional
@RequestMapping(value={"/dzy/wx"})
public class UserWXLoginController {
    private HttpSession phoneSession;
    RestTemplate restTemplate = new RestTemplate();
    @Autowired
    WXAuthorizedValids wxAuthorizedValids;
    @Autowired
    WXSubscription wxSubscription;
    @Autowired
    RandomIdCreate randomIdCreate;
    @Autowired
    UserMapper userMapper;
    @Autowired
    WXUserService wxUserService;
    @Autowired
    private UserValids userValid;
    private Long validTime = 300000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/login"})
    public ResData getCode(@RequestParam(value="code") String code, @RequestParam(value="state", required=false) String state, HttpSession session) throws UnsupportedEncodingException {
        String openid;
        User queryUser;
        this.logger.info("state:" + state);
        AuthorizedValids authorizedValids = null;
        if (state != null) {
            this.phoneSession = session;
            authorizedValids = (AuthorizedValids)this.wxAuthorizedValids.getWxAuthorizedValids().get(state);
            if (authorizedValids == null) {
                return ResData.ofFail((Integer)1017, (String)"\u8be5\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            }
        }
        String tokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + this.wxSubscription.getAppid() + "&secret=" + this.wxSubscription.getAppsecret() + "&code=" + code + "&grant_type=authorization_code";
        ResponseEntity tokenlist = this.restTemplate.getForEntity(tokenUrl, String.class, new Object[0]);
        LinkedHashMap hashMap = (LinkedHashMap)JSON.parseObject((String)((String)tokenlist.getBody()), LinkedHashMap.class);
        String access_token = (String)hashMap.get("access_token");
        String openId = (String)hashMap.get("openid");
        String userUrl = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openId + "&lang=zh_CN";
        ResponseEntity user = this.restTemplate.getForEntity(userUrl, String.class, new Object[0]);
        LinkedHashMap userInfoMap = (LinkedHashMap)JSON.parseObject((String)((String)user.getBody()), LinkedHashMap.class);
        if (state != null) {
            authorizedValids.setLinkedHashMap(userInfoMap);
        }
        if ((queryUser = this.wxUserService.queryUserByOpenId(openid = (String)userInfoMap.get("openid"))) != null) {
            session.setAttribute("user", (Object)queryUser);
            if (state != null) {
                authorizedValids.setUser(queryUser);
                this.wxAuthorizedValids.getWxAuthorizedValids().put(state, authorizedValids);
            }
            this.logger.info("\u8001\u7528\u6237\uff1a" + this.wxAuthorizedValids.getWxAuthorizedValids().get(state));
            return ResData.of((Integer)0, (String)"\u8001\u7528\u6237", (Object)queryUser);
        }
        session.setAttribute("userInfoMap", (Object)userInfoMap);
        if (state != null) {
            this.wxAuthorizedValids.getWxAuthorizedValids().put(state, authorizedValids);
            this.logger.info("\u65b0\u7528\u6237\uff1a" + this.wxAuthorizedValids.getWxAuthorizedValids().get(state));
        }
        return ResData.of((Integer)1, (String)"\u65b0\u7528\u6237", userInfoMap.get("headimgurl"));
    }

    @PostMapping
    public ResData addUser(HttpSession session) throws UnsupportedEncodingException {
        this.logger.info("\u65b0\u7528\u6237\u65b0\u589e");
        LinkedHashMap userInfoMap = (LinkedHashMap)session.getAttribute("userInfoMap");
        this.logger.info("userInfoMap\uff1a" + userInfoMap);
        if (userInfoMap == null) {
            return ResData.ofFail((Integer)20013, (String)"\u8bf7\u5148\u6388\u6743");
        }
        User addUser = new User();
        String openid = (String)userInfoMap.get("openid");
        addUser.setId(this.randomIdCreate.getNewUserId());
        String addName = (String)userInfoMap.get("nickname");
        String newAddName = new String(addName.getBytes("ISO-8859-1"), "utf-8");
        addUser.setWxName(newAddName);
        addUser.setOpenId(openid);
        addUser.setCover((String)userInfoMap.get("headimgurl"));
        ResData resData = this.wxUserService.addWXUser(addUser);
        if (resData.getData() != null) {
            session.setAttribute("user", resData.getData());
        }
        return resData;
    }

    @PutMapping
    public ResData UserBinding(@RequestParam(value="phone") String phone, @RequestParam(value="code") String code, HttpSession session) throws UnsupportedEncodingException {
        User userByPhone = this.userMapper.getUserByPhone(phone);
        if (userByPhone == null) {
            return ResData.ofFail((Integer)10065, (String)"\u624b\u673a\u53f7\u672a\u6ce8\u518c");
        }
        if (userByPhone.getEnabled() == 0) {
            return ResData.ofFail((Integer)2003, (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u5c01");
        }
        if (userByPhone.getOpenId() != null) {
            return ResData.ofFail((Integer)10074, (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
        }
        LinkedHashMap userInfoMap = (LinkedHashMap)session.getAttribute("userInfoMap");
        this.logger.info("userInfoMap\uff1a" + userInfoMap);
        if (userInfoMap == null) {
            return ResData.ofFail((Integer)20013, (String)"\u8bf7\u5148\u6388\u6743");
        }
        ValidCode validCode1 = (ValidCode)this.userValid.getUserValidsList().get(phone);
        long currTime = System.currentTimeMillis();
        this.userValid.getUserValidsList().remove(phone);
        User user = new User();
        String addName = (String)userInfoMap.get("nickname");
        String newAddName = new String(addName.getBytes("ISO-8859-1"), "utf-8");
        user.setOpenId((String)userInfoMap.get("openid"));
        user.setWxName(newAddName);
        user.setCover((String)userInfoMap.get("headimgurl"));
        ResData resData = this.wxUserService.UserBinding(user, phone);
        if (resData.getData() != null) {
            session.setAttribute("user", resData.getData());
        }
        return resData;
    }
}

