/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.user;

import com.aliyuncs.exceptions.ClientException;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.common.shortmsg.ShortMessage;
import com.c1801.spring.dzy.config.UserValids;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.ShortMessageConfiguration;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.model.ValidCode;
import com.c1801.spring.dzy.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/dzy/captcha"})
public class UserLoginController {
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserValids userValid;
    @Autowired
    ShortMessageConfiguration smc;

    @GetMapping(value={"/{phone}"})
    public ResData getValidCode(@PathVariable(value="phone") String phone) throws ClientException {
        this.logger.info("\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801phone = " + phone);
        String regexMobile = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
        if (phone.length() != 11) {
            return ResData.ofSuccess((Integer)10062, (String)"\u624b\u673a\u53f7\u5e94\u4e3a11\u4f4d\u6570");
        }
        if (!phone.matches(regexMobile)) {
            return ResData.ofSuccess((Integer)10064, (String)"\u8bf7\u4e0d\u8981\u8f93\u5165\u65e0\u6548\u624b\u673a\u53f7");
        }
        User user = this.userMapper.queryUserByName(phone);
        if (user == null) {
            return ResData.ofSuccess((Integer)10065, (String)"\u624b\u673a\u53f7\u672a\u6ce8\u518c");
        }
        if (this.userMapper.queryUserEnabled(user.getId()) == 0) {
            return ResData.ofSuccess((Integer)2003, (String)"\u8be5\u8d26\u6237\u5df2\u88ab\u7981\u7528");
        }
        if (user.getOpenId() != null) {
            return ResData.ofSuccess((Integer)2004, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
        }
        String verCode = ShortMessage.getVerCode((String)phone, (ShortMessageConfiguration)this.smc);
        ValidCode validCode = new ValidCode();
        validCode.setUpdateDate(System.currentTimeMillis());
        this.logger.info("\u624b\u673a\u53f7\uff1a" + phone + "\u9a8c\u8bc1\u7801 = " + validCode);
        this.userValid.getUserValidsList().put(phone, validCode);
        return ResData.of((Integer)0, (String)"\u8bf7\u6ce8\u610f\u67e5\u770b\u9a8c\u8bc1\u7801", null);
    }
}

