/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.user;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.config.UserValids;
import com.c1801.spring.dzy.model.Account;
import com.c1801.spring.dzy.model.ShortMessageConfiguration;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.model.ValidCode;
import com.c1801.spring.dzy.service.UserService;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/dzy/user"})
public class UserController {
    @Autowired
    private UserService userService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserValids userValid;
    @Autowired
    private Map<String, Account> accountMap;
    private Long validTime = 180000L;
    @Autowired
    ShortMessageConfiguration smc;

    @PostMapping(value={"/login"})
    public ResData getCode(@RequestBody ValidCode validCode, HttpSession session) {
        this.logger.info("\u767b\u5f55\u9a8c\u8bc1validCode = " + validCode);
        ValidCode validCode1 = (ValidCode)this.userValid.getUserValidsList().get(validCode.getPhone());
        long currTime = System.currentTimeMillis();
        if (validCode1 == null || !validCode1.getCode().equals(validCode.getCode()) || currTime - validCode1.getUpdateDate() > this.validTime) {
            return ResData.of((Integer)1007, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801", null);
        }
        this.userValid.getUserValidsList().remove(validCode.getPhone());
        this.logger.info("\u767b\u5f55\u9a8c\u8bc1\u540e = " + validCode1);
        User user = new User();
        user.setName(validCode.getPhone());
        Account account = this.userService.userLogin(user);
        if (account.getUser().getEnabled() == 0) {
            return ResData.ofFail((Integer)2003, (String)"\u8be5\u8d26\u53f7\u5df2\u88ab\u5c01", null);
        }
        this.accountMap.put(account.getUser().getName(), account);
        session.setAttribute("user", (Object)account.getUser());
        session.setMaxInactiveInterval(1800);
        return ResData.ofSuccess((Integer)0, (String)"\u767b\u5f55\u6210\u529f", (Object)account);
    }

    @GetMapping(value={"/info"})
    public ResData getUser(HttpSession session) {
        User u = (User)session.getAttribute("user");
        this.logger.info("\u6839\u636eid\u83b7\u53d6\u7528\u6237\u4fe1\u606f = " + u.getId());
        Account user = this.userService.getAccountById(u.getId());
        this.logger.info("user = " + user);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)user);
    }

    @GetMapping(value={"/logout"})
    public Object logout(HttpSession session) {
        session.removeAttribute("user");
        session.invalidate();
        return "\u9000\u51fa\u6210\u529f";
    }
}

