/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.user;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.service.UserService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/user"})
public class ManageUserController {
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public ResData getUserList(@RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(defaultValue="") String minDate, @RequestParam(defaultValue="") String maxDate) {
        PageInfo pageInfo = this.userService.getUserListOfPage(name, pageSize, pageNum, minDate, maxDate);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)pageInfo);
    }

    @GetMapping(value={"/list"})
    public ResData getUserListByIds(@RequestParam(value="userId") List<Integer> userIds) {
        List userList = this.userService.getUserListByUserIds(userIds);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)userList);
    }

    @PutMapping(value={"/{id}"})
    public ResData getUserByState(@PathVariable(value="id") Integer id) {
        User user = this.userMapper.getUserById(id);
        user = user.getEnabled() == 0 ? this.userMapper.updateUserByState(id, Integer.valueOf(1)) : this.userMapper.updateUserByState(id, Integer.valueOf(0));
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)user);
    }

    @GetMapping(value={"/create/statistic"})
    public ResData getStatisticUserByLoginDate(@RequestParam(defaultValue="") String minDate, @RequestParam(defaultValue="") String maxDate) {
        List statisticUser = this.userService.getStatisticUserByCreaeteDate(minDate, maxDate);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)statisticUser);
    }
}

