/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.sellbook;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.common.exception.CusBookException;
import com.c1801.spring.dzy.config.ExceptionEmial;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.SellBookMapper;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.SellBook;
import com.c1801.spring.dzy.model.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Transactional
@RequestMapping(value={"/dzy/sell"})
public class SellBookController {
    @Autowired
    private SellBookMapper sellBookMapper;
    @Autowired
    private BookMapper bookMapper;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ExceptionEmial exceptionEmial;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public ResData getSellBookListByUserId(HttpSession session) {
        User u = (User)session.getAttribute("user");
        this.logger.info("\u7528\u6237\u5356\u4e66\u5217\u8868 userId\uff1a" + this.sellBookMapper.getSellBookListByUserId(u.getId()));
        List sellBookList = this.sellBookMapper.getSellBookListByUserId(u.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)sellBookList);
    }

    @GetMapping(value={"/{isbn}"})
    public ResData getDateByISBN(@PathVariable(value="isbn") String isbn, HttpSession session) throws ParseException, CusBookException {
        Object book;
        User u = (User)session.getAttribute("user");
        if (isbn.length() < 10 || isbn.length() > 13) {
            return ResData.ofFail((Integer)1006, (String)"isbn \u5e94\u662f10\u621613\u4f4d");
        }
        if (isbn.length() == 10 && isbn.lastIndexOf("0") == 9) {
            StringBuilder sb = new StringBuilder(isbn);
            sb.replace(9, 10, "X");
            isbn = sb.toString();
        }
        if ((book = null) != null) {
            this.logger.info("\u6570\u636e\u5e93\u67e5\u8be2");
            SellBook sellBook = this.sellBookMapper.getSellBookBySellBookIdAndUserId(book.getId(), u.getId());
            if (sellBook != null) {
                ResData resData = new ResData();
                resData.setCode(Integer.valueOf(0));
                resData.setDesc("\u8be5\u4e66\u7c4d\u5df2\u5728\u5217\u8868\u4e2d\u6216\u5df2\u5356\u8fc7\u8fd9\u672c\u4e66");
                return resData;
            }
            this.sellBookMapper.addSellBook(book.getId(), u.getId());
            ResData resData = new ResData();
            resData.setCode(Integer.valueOf(0));
            resData.setDesc("\u6210\u529f");
            return resData;
        }
        this.logger.info("api\u8fdc\u7a0b\u67e5\u8be2");
        String url = "http://book.api.p.cn/isbn1/" + isbn;
        ResponseEntity results = null;
        try {
            results = this.restTemplate.exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.exceptionEmial.exceptionEmial(e);
        }
        JSONObject object = JSON.parseObject((String)((String)results.getBody()));
        if (object.getInteger("code") != 0) {
            ResData resData = new ResData();
            resData.setCode(object.getInteger("code"));
            resData.setDesc("\u67e5\u8be2\u4e0d\u5230\u6307\u5b9a\u4e66\u7c4d");
            return resData;
        }
        JSONObject result = object.getJSONObject("data");
        JSONObject rating = result.getJSONObject("rating");
        if (rating.getDouble("average") == null || rating.getDouble("average") <= 0.0) {
            return ResData.ofSuccess((Integer)0, (String)"\u6ca1\u6709\u8bc4\u5206\u7684\u4e66\u7c4d\u4e0d\u6536");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Book newbook = new Book();
        newbook.setISBN10(result.getString("isbn10"));
        newbook.setISBN13(result.getString("isbn13"));
        newbook.setName(result.getString("title"));
        String cover = result.getString("image");
        cover = "https://images.weserv.nl/?url=" + cover.replaceFirst("s", "");
        newbook.setCover(cover);
        String author = result.getString("author");
        author = author.substring(1, author.length() - 1);
        author = author.replaceAll("[\"\\\\]", "");
        newbook.setAuthor(author);
        newbook.setPublisher(result.getString("publisher"));
        if (result.getString("price") != null && !result.getString("price").equals("")) {
            newbook.setPrice(Double.parseDouble(Pattern.compile("[^0-9(.)]").matcher(result.getString("price")).replaceAll("").trim()));
        }
        if (result.getString("pubdate") != null && !result.getString("pubdate").equals("")) {
            newbook.setPubDate(sdf.parse(result.getString("pubdate")));
        }
        newbook.setDoubanRate(rating.getDouble("average").doubleValue());
        newbook.setGist(result.getString("summary"));
        newbook.setBinding(result.getString("binding"));
        this.bookMapper.addBook(newbook);
        this.sellBookMapper.addSellBook(newbook.getId(), u.getId());
        ResData resData = new ResData();
        resData.setCode(Integer.valueOf(0));
        resData.setDesc("\u6210\u529f");
        return resData;
    }

    @DeleteMapping
    public ResData delSellBook(@RequestParam(value="bookId") Integer bookId, HttpSession session) {
        User u = (User)session.getAttribute("user");
        this.logger.info("\u5220\u9664\u64cd\u4f5c\uff1abookId\uff1a" + bookId + "\uff0cuserId\uff1a" + u.getId());
        this.sellBookMapper.delSellBook(bookId, u.getId());
        ResData resData = new ResData();
        resData.setCode(Integer.valueOf(0));
        resData.setData((Object)"\u5220\u9664\u6210\u529f");
        this.logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + resData);
        return resData;
    }

    @PutMapping
    public ResData sellBookWhetherInOrder(HttpSession session, @RequestParam(value="state") Integer state, @RequestParam(value="bookId") List<Integer> bookId) {
        User u = (User)session.getAttribute("user");
        this.logger.info("\u8ba2\u5355\u96c6\u4f53\u64cd\u4f5c\uff1auserId\uff1a" + u.getId() + "\uff0cstate\uff1a" + state + "\uff0cList\uff1a" + bookId);
        this.sellBookMapper.sellBookWhetherInOrder(u.getId(), bookId, state);
        ResData resData = new ResData();
        resData.setCode(Integer.valueOf(0));
        resData.setData((Object)"\u6210\u529f");
        return resData;
    }
}

