/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.order;

import com.c1801.spring.dzy.common.RandomIdCreate;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.AddrMapper;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.OrderBookMapper;
import com.c1801.spring.dzy.mapper.OrderMapper;
import com.c1801.spring.dzy.mapper.SellBookMapper;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.Address;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.Order;
import com.c1801.spring.dzy.model.OrderAccount;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.service.BookService;
import com.c1801.spring.dzy.service.OrderService;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/dzy/order"})
public class OrderController {
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    SellBookMapper sellBookMapper;
    @Autowired
    AddrMapper addrMapper;
    @Autowired
    OrderBookMapper orderBookMapper;
    @Autowired
    UserMapper userMapper;
    @Autowired
    BookService bookService;
    @Autowired
    BookMapper bookMapper;
    @Autowired
    OrderService orderService;
    @Autowired
    RandomIdCreate randomIdCreate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/{orderId}"})
    public ResData queryOrderAccountByOrderId(@PathVariable(value="orderId") Integer orderId) {
        OrderAccount orderAccount = this.orderMapper.queryOrderAccountByOrderId(orderId);
        this.logger.info("\u8ba2\u5355\u4e66\u7c4d\u5217\u8868orderAccount order = " + orderAccount);
        return ResData.of((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)orderAccount);
    }

    @PostMapping
    public ResData addOrder(@RequestBody Address addr, HttpSession session) {
        User u = (User)session.getAttribute("user");
        List books = this.sellBookMapper.getSellBookListByUserId(u.getId());
        if (books == null) {
            return ResData.ofSuccess((Integer)10036, (String)"\u7528\u6237id\u4e0d\u5b58\u5728");
        }
        Double total = 0.0;
        for (Book s : books) {
            total = total + s.getPrice();
        }
        total = total * 0.3;
        Order order = new Order();
        Integer id = (Integer)this.randomIdCreate.getOrderId().get(0);
        this.randomIdCreate.getOrderId().remove(0);
        if (this.randomIdCreate.getOrderId().size() < 10) {
            this.randomIdCreate.addOrderId();
        }
        order.setId(id);
        order.setUserId(u.getId());
        order.setStatus(Integer.valueOf(0));
        order.setType(Integer.valueOf(0));
        order.setTotal(total);
        order.setProvince(addr.getProvince());
        order.setCity(addr.getCity());
        order.setDistrict(addr.getDistrict());
        order.setStreet(addr.getStreet());
        order.setUserName(addr.getName());
        order.setPhone(addr.getPhone());
        this.orderMapper.addOrder(order);
        List bookId = this.sellBookMapper.getBookIdByUserId(u.getId());
        if (bookId.size() <= 0) {
            return ResData.ofSuccess((Integer)0, (String)"\u8ba2\u5355\u4e2d\u6ca1\u6709\u4e66\u7c4d");
        }
        this.sellBookMapper.sellBookWhetherInOrder(u.getId(), bookId, Integer.valueOf(1));
        this.orderBookMapper.addOrderBook(order.getId(), bookId);
        User user = this.userMapper.getUserById(u.getId());
        Address address = this.addrMapper.getAddrById(user.getAddrId());
        if (address == null) {
            this.addrMapper.addAddr(addr);
            this.userMapper.updateUserAddr(addr.getId(), u.getId());
        } else {
            this.addrMapper.updateAddr(addr, address.getId());
        }
        return ResData.of((Integer)0, (String)"\u8ba2\u5355\u6210\u529f", (Object)order);
    }

    @PutMapping
    public ResData cancelOrder(@RequestBody Order order) {
        return this.orderService.changeOrderStatus(order);
    }

    @GetMapping
    public ResData queryOrderAccountByName(@RequestParam(value="name", required=false) String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, HttpSession session) {
        User u = (User)session.getAttribute("user");
        System.out.println(u);
        Integer index = (page - 1) * pageSize;
        if (name != null && !name.trim().equals("")) {
            User user = this.userMapper.queryUserByName(name);
            if (user == null) {
                return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", null);
            }
            return ResData.of((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)this.orderMapper.queryOrderAccountByUserId(user.getId()));
        }
        if (u.getId() != null) {
            return ResData.of((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)this.orderMapper.queryOrderAccountByUserId(u.getId()));
        }
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)this.orderMapper.queryOrderList(index, pageSize));
    }
}

