/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.order;

import com.c1801.spring.dzy.common.Calculate;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.AddrMapper;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.OrderBookMapper;
import com.c1801.spring.dzy.mapper.OrderMapper;
import com.c1801.spring.dzy.mapper.SellBookMapper;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.Order;
import com.c1801.spring.dzy.model.OrderAccount;
import com.c1801.spring.dzy.model.OrderBookRecord;
import com.c1801.spring.dzy.model.Pager;
import com.c1801.spring.dzy.service.BookService;
import com.c1801.spring.dzy.service.OrderService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/order"})
public class ManageOrderController {
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    SellBookMapper sellBookMapper;
    @Autowired
    AddrMapper addrMapper;
    @Autowired
    OrderBookMapper orderBookMapper;
    @Autowired
    UserMapper userMapper;
    @Autowired
    BookService bookService;
    @Autowired
    BookMapper bookMapper;
    @Autowired
    OrderService orderService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PutMapping
    public ResData cancelOrder(@RequestBody Order order) {
        return this.orderService.changeOrderStatus(order);
    }

    @GetMapping(value={"/{orderId}"})
    public ResData queryOrderAccountByOrderId(@PathVariable(value="orderId") Integer orderId) {
        OrderAccount orderAccount = this.orderMapper.queryOrderAccountByOrderId(orderId);
        this.logger.info("\u8ba2\u5355\u4e66\u7c4d\u5217\u8868orderAccount order = " + orderAccount);
        return ResData.of((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)orderAccount);
    }

    @PutMapping(value={"/proofread"})
    public ResData proofreadingOrder(@RequestBody List<OrderBookRecord> orderBookRecords) {
        if (orderBookRecords.size() == 0) {
            return ResData.ofSuccess((Integer)0, (String)"\u5f53\u524d\u8ba2\u5355\u6ca1\u6709\u4e66\u7c4d");
        }
        Double total = 0.0;
        for (OrderBookRecord obr : orderBookRecords) {
            Book book = this.bookMapper.queryBookById(obr.getBookId());
            Double condition = obr.getCondition() == 0 ? 0.3 : (obr.getCondition() == 1 ? 0.25 : 0.0);
            double mul = Calculate.mul((double)book.getPrice(), (double)condition);
            double round = Calculate.round((double)mul, (int)2);
            total = total + round;
        }
        this.orderMapper.updateOrderTotal(total, orderBookRecords.get(0).getOrderId());
        this.orderMapper.cancelOrder(orderBookRecords.get(0).getOrderId(), Integer.valueOf(5));
        this.bookService.addOrderBookRecordMapper(orderBookRecords);
        return ResData.ofSuccess((Integer)0, (String)"\u6821\u5bf9\u5b8c\u6210");
    }

    @PutMapping(value={"/settlement"})
    public ResData settlementOrder(@RequestBody List<OrderBookRecord> orderBookRecords) {
        if (orderBookRecords.size() == 0) {
            return ResData.ofSuccess((Integer)0, (String)"\u5f53\u524d\u8ba2\u5355\u6ca1\u6709\u4e66\u7c4d");
        }
        OrderAccount orderAccount = this.orderMapper.queryOrderAccountByOrderId(orderBookRecords.get(0).getOrderId());
        this.userMapper.updateUserBalance(orderBookRecords.get(0).getUserId(), orderAccount.getTotal());
        this.orderMapper.cancelOrder(orderBookRecords.get(0).getOrderId(), Integer.valueOf(6));
        for (int i = 0; i < orderBookRecords.size(); ++i) {
            if (orderBookRecords.get(i).getCondition() != 2) continue;
            orderBookRecords.remove(i);
            --i;
        }
        this.bookService.addStock(orderBookRecords);
        return ResData.ofSuccess((Integer)0, (String)"\u7ed3\u7b97\u5b8c\u6210");
    }

    @GetMapping(value={"/date"})
    public ResData queryOrderListInDate() {
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)this.orderMapper.queryOrderListInDate());
    }

    @GetMapping
    public ResData querOrderListInSection(@RequestParam(value="start", required=false) String start, @RequestParam(value="end", required=false) String end, @RequestParam(value="name", required=false) String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="totalPriceStatus", defaultValue="", required=false) Integer totalPriceStatus, @RequestParam(value="totalStatus", defaultValue="", required=false) Integer totalStatus) {
        Integer index = (page - 1) * pageSize;
        List total = this.orderMapper.querOrderListInSectionTotal(start, end, name);
        List orderAccounts = this.orderMapper.querOrderListInSection(start, end, name, index, pageSize, totalPriceStatus, totalStatus);
        Pager pager = new Pager();
        pager.setTotal(Integer.valueOf(total.size()));
        pager.setData((Object)orderAccounts);
        System.out.println("totalPriceStatus : " + totalPriceStatus);
        System.out.println("totalStatus:" + totalStatus);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)pager);
    }

    @GetMapping(value={"/list/section/complete"})
    public ResData queryOrderListInSectionAndComplete(@RequestParam(value="start", required=false) String start, @RequestParam(value="end", required=false) String end, @RequestParam(value="name", required=false) String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize) {
        Integer index = (page - 1) * pageSize;
        List total = this.orderMapper.queryOrderListInSectionAndCompleteTotal(start, end, name);
        List orderAccounts = this.orderMapper.queryOrderListInSectionAndComplete(start, end, name, index, pageSize);
        Pager pager = new Pager();
        pager.setTotal(Integer.valueOf(total.size()));
        pager.setData((Object)orderAccounts);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)pager);
    }
}

