/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.collection;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.BookCollectionMapper;
import com.c1801.spring.dzy.model.BookCollection;
import com.c1801.spring.dzy.model.BookCollectionList;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.HashMap;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/collection"})
public class ManageCollectionController {
    @Autowired
    BookCollectionMapper bookCollectionMapper;

    @GetMapping
    public ResData queryBookCollection(@Param(value="page") Integer page, @Param(value="size") Integer size) {
        PageHelper.startPage((int)page, (int)size, (String)"sort desc");
        Page bookCollections = this.bookCollectionMapper.queryBookCollection();
        PageInfo pageInfo = PageInfo.ofPageInfo((Page)bookCollections);
        System.out.println(pageInfo);
        return ResData.ofSuccess((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)pageInfo);
    }

    @GetMapping(value={"/id"})
    public ResData queryBookCollectionByID(@Param(value="id") Integer id) {
        BookCollection bookCollection = this.bookCollectionMapper.queryBookCollectionByID(id);
        try {
            for (BookCollectionList item : bookCollection.getList()) {
                System.out.println(item);
                Integer total = this.bookCollectionMapper.queryBookCollectionApplaudTotal(item.getId());
                item.setApplaudsTotal(Integer.valueOf(total == null ? 0 : total));
            }
            return ResData.ofSuccess((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)bookCollection);
        }
        catch (NullPointerException e1) {
            return ResData.ofSuccess((Integer)1008, (String)"\u67e5\u8be2\u6210\u529f-\u4f46\u6ca1\u6709\u6570\u636e");
        }
    }

    @PostMapping
    public ResData addBookCollection(@RequestBody HashMap<String, String> map) {
        BookCollection bookCollection = new BookCollection();
        bookCollection.setName(map.get("name"));
        bookCollection.setIntro(map.get("intro"));
        bookCollection.setBackgroundImage(map.get("image"));
        bookCollection.setBackgroundColor(map.get("color"));
        bookCollection.setSort(Integer.valueOf(map.get("sort")));
        bookCollection.setState(Boolean.valueOf(map.get("state")));
        bookCollection.setExpirationDate(new Date(Long.valueOf(map.get("expirationDate"))));
        System.out.println(bookCollection);
        this.bookCollectionMapper.addBookCollection(bookCollection);
        return ResData.ofSuccess((Integer)0, (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping
    public ResData updateBookCollectionState(@RequestBody HashMap<String, String> map) {
        BookCollection bookCollection = new BookCollection();
        bookCollection.setId(Integer.valueOf(map.get("id")));
        bookCollection.setName(map.get("name"));
        bookCollection.setIntro(map.get("intro"));
        bookCollection.setBackgroundImage(map.get("image"));
        bookCollection.setBackgroundColor(map.get("color"));
        bookCollection.setSort(Integer.valueOf(map.get("sort")));
        bookCollection.setState(Boolean.valueOf(map.get("state")));
        bookCollection.setExpirationDate(new Date(Long.valueOf(map.get("expirationDate"))));
        System.out.println(bookCollection);
        this.bookCollectionMapper.updateBookCollection(bookCollection);
        return ResData.ofSuccess((Integer)0, (String)"\u4fee\u6539\u6210\u529f");
    }

    @PutMapping(value={"/state"})
    public ResData updateBookCollectionState(@Param(value="id") Integer id, @Param(value="state") Boolean state) {
        this.bookCollectionMapper.updateBookCollectionState(id, state);
        return ResData.ofSuccess((Integer)0, (String)"\u4fee\u6539\u6210\u529f");
    }
}

