/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.collection;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.BookCollectionMapper;
import com.c1801.spring.dzy.model.BookCollectionPack;
import com.c1801.spring.dzy.model.RecommendBook;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.service.CartService;
import com.c1801.spring.dzy.service.CollectionService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dzy/collection"})
public class CollectionController {
    @Autowired
    private BookCollectionMapper bookCollectionMapper;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private CartService cartService;

    @GetMapping
    public ResData getBookCollectionList(@RequestParam(value="page") Integer page, @RequestParam(value="pageSize") Integer pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        ResData resData = new ResData();
        List bookCollection = this.bookCollectionMapper.getBookCollectionPack();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BookCollectionPack b : bookCollection) {
            ids.add(b.getId());
        }
        List counts = this.bookCollectionMapper.getCountByCollectionIds(ids);
        for (BookCollectionPack b : bookCollection) {
            for (BookCollectionPack c : counts) {
                if (b.getId() == c.getId()) {
                    b.setContributorsCount(c.getContributorsCount());
                    b.setItemsCount(c.getItemsCount());
                }
                if (b.getItemsCount() == null) {
                    b.setItemsCount(Integer.valueOf(0));
                }
                if (b.getContributorsCount() != null) continue;
                b.setContributorsCount(Integer.valueOf(0));
            }
        }
        return ResData.ofSuccess((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)bookCollection);
    }

    @GetMapping(value={"/list"})
    public ResData getBookListSum() {
        ResData resData = new ResData();
        Integer integer = this.bookCollectionMapper.getBookListSum();
        return ResData.ofSuccess((Integer)0, (String)"\u67e5\u8be2\u6210\u529f", (Object)integer);
    }

    @PostMapping(value={"/recommend"})
    public ResData addBookAppointCollection(@RequestBody RecommendBook recommendBook, HttpSession session) {
        if (recommendBook.getCollectionId() == null || recommendBook.getBookId() == null && recommendBook.getIsbn() == null) {
            return ResData.ofFail((Integer)1001, (String)"\u53c2\u6570\u7f3a\u5931");
        }
        User user = (User)session.getAttribute("user");
        recommendBook.setUserId(user.getId());
        return this.collectionService.addBookAppointCollection(recommendBook);
    }

    @GetMapping(value={"/recommend"})
    public ResData queryRecommendAccountById(@RequestParam(value="id") Integer id) {
        if (id == null) {
            return ResData.ofFail((Integer)1001, (String)"\u53c2\u6570\u7f3a\u5931");
        }
        return this.collectionService.queryRecommendAccountById(id);
    }

    @GetMapping(value={"/{collectionId:\\d+}"})
    public ResData querySingleCollection(@PathVariable(value="collectionId") Integer collectionId) {
        BookCollectionPack collectionPack = this.collectionService.querySingleCollection(collectionId);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)collectionPack);
    }

    @GetMapping(value={"/book"})
    public ResData queryRecommedList(@RequestParam(value="collectionId") Integer collectionId, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="lastDate", required=false) Date lastDate, HttpSession session) {
        User user = (User)session.getAttribute("user");
        if (user == null) {
            user = new User();
        }
        Map map = this.collectionService.queryRecommedList(collectionId, pageSize, pageNum, lastDate, user.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)map);
    }
}

