/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.category;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.BookMapper;
import com.c1801.spring.dzy.mapper.CategoryMapper;
import com.c1801.spring.dzy.model.Book;
import com.c1801.spring.dzy.model.Category;
import com.c1801.spring.dzy.model.CategoryBook;
import com.c1801.spring.dzy.model.Pager;
import com.c1801.spring.dzy.service.UserService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/category"})
public class CategoryController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CategoryMapper categoryMapper;
    @Autowired
    private BookMapper bookMapper;
    @Autowired
    private UserService userService;

    @GetMapping
    public ResData getCategoryList(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="name", required=false) String name) {
        Integer index = (page - 1) * pageSize;
        List categoryListTotal = this.categoryMapper.getCategoryListTotal(name);
        List categoryList = this.categoryMapper.getCategoryList(index, pageSize, name);
        Pager pager = new Pager();
        pager.setTotal(Integer.valueOf(categoryListTotal.size()));
        pager.setPages(Integer.valueOf(categoryListTotal.size() / pageSize + (categoryListTotal.size() % pageSize == 0 ? 0 : 1)));
        pager.setData((Object)categoryList);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)pager);
    }

    @GetMapping(value={"/{categoryId}"})
    public ResData getCategoryByCategoryId(@PathVariable(value="categoryId") Integer categoryId) {
        CategoryBook category = this.categoryMapper.getCategoryByCategoryId(categoryId);
        if (category == null) {
            return ResData.ofSuccess((Integer)10088, (String)"\u5206\u7c7bid\u4e0d\u5b58\u5728\u6216\u5206\u7c7b\u6682\u65e0\u4e66\u7c4d");
        }
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)category);
    }

    @PostMapping
    public ResData addCategory(@RequestBody Category category) {
        block2: {
            try {
                this.categoryMapper.addCategory(category);
            }
            catch (Exception e) {
                if (category.getId() != null) break block2;
                return ResData.ofSuccess((Integer)10089, (String)"\u5206\u7c7b\u6635\u79f0\u5df2\u5b58\u5728");
            }
        }
        return ResData.ofSuccess((Integer)0, (String)"\u65b0\u589e\u6210\u529f");
    }

    @PostMapping(value={"/book"})
    public ResData addCategory(@RequestBody CategoryBook categoryBook) {
        ArrayList<Integer> bookId = new ArrayList<Integer>();
        for (Book book : categoryBook.getBooks()) {
            bookId.add(book.getId());
        }
        this.categoryMapper.addCategorys(categoryBook.getId(), bookId);
        return ResData.ofSuccess((Integer)0, (String)"\u65b0\u589e\u6210\u529f");
    }

    @DeleteMapping(value={"/{categoryId}"})
    public ResData delCategory(@PathVariable(value="categoryId") Integer categoryId) {
        this.categoryMapper.delCategory(categoryId);
        this.categoryMapper.delCategoryBook(categoryId);
        return ResData.ofSuccess((Integer)0, (String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping
    public ResData delCategoryBooks(@RequestParam(value="categoryId") Integer categoryId, @RequestParam(value="bookId") List<Integer> bookId) {
        this.categoryMapper.delCategoryBooks(categoryId, bookId);
        return ResData.ofSuccess((Integer)0, (String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping
    public ResData updateCategory(@RequestBody Category category) {
        this.categoryMapper.updateCategory(category);
        return ResData.ofSuccess((Integer)0, (String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/book"})
    public ResData getBooksNotInCategory(@RequestParam(value="categoryId") Integer categoryId) {
        List booksNotInCategory = this.bookMapper.getBooksNotInCategory(categoryId);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)booksNotInCategory);
    }
}

