/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.cart;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.model.Cart;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.service.CartService;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dzy/cart"})
public class CartController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CartService cartService;

    @PostMapping
    public ResData addShopToCart(@RequestBody Cart cart, HttpSession session) throws MissingServletRequestParameterException {
        this.logger.info(cart + "\u6dfb\u52a0\u5230\u8d2d\u7269\u8f66");
        if (cart.getBookId() == null) {
            throw new MissingServletRequestParameterException("bookId", "\u4e66\u7c4did\u5fc5\u987b\u4f20\u5165");
        }
        if (cart.getCondition() == null) {
            throw new MissingServletRequestParameterException("condition", "\u54c1\u76f8\u5fc5\u987b\u4f20\u5165");
        }
        User user = (User)session.getAttribute("user");
        int reslut = this.cartService.addShopToCart(cart.getBookId(), cart.getCondition(), user.getId());
        if (reslut == 0) {
            return ResData.ofFail((Integer)3000, (String)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
        }
        if (reslut >= 100) {
            return ResData.ofFail((Integer)3001, (String)"\u8d2d\u7269\u8f66\u5df2\u6ee1");
        }
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)reslut);
    }

    @DeleteMapping(value={"/{cartId:\\d+}"})
    public ResData delShopFromCart(@PathVariable Integer cartId, HttpSession session) {
        this.logger.info(cartId + "\u4ece\u8d2d\u7269\u8f66\u5220\u9664");
        User user = (User)session.getAttribute("user");
        int result = this.cartService.delShopFromCart(cartId, user.getId());
        if (result == 0) {
            return ResData.ofFail((Integer)3002, (String)"\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25");
        }
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @PatchMapping
    public ResData updateConditoinOfCart(@RequestBody Cart cart, HttpSession session) throws MissingServletRequestParameterException {
        this.logger.info(cart + "\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u54c1\u76f8");
        if (cart.getBookId() == null) {
            throw new MissingServletRequestParameterException("bookId", "\u4e66\u7c4did\u5fc5\u987b\u4f20\u5165");
        }
        if (cart.getCondition() == null) {
            throw new MissingServletRequestParameterException("condition", "\u54c1\u76f8\u5fc5\u987b\u4f20\u5165");
        }
        User user = (User)session.getAttribute("user");
        cart.setUserId(user.getId());
        int result = this.cartService.updateConditoinOfCart(cart);
        if (result == 0) {
            return ResData.ofFail((Integer)3003, (String)"\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u54c1\u76f8\u5931\u8d25");
        }
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @PatchMapping(value={"/{cartId:\\d+}"})
    public ResData editSelectedCart(@PathVariable Integer cartId, HttpSession session) {
        this.logger.info(cartId + "\u9009\u4e2d/\u53d6\u6d88");
        User user = (User)session.getAttribute("user");
        int result = this.cartService.updateSelectedCart(cartId, user.getId());
        if (result == 0) {
            return ResData.ofFail((Integer)3004, (String)"\u5207\u6362\u5546\u54c1\u9009\u4e2d\u6216\u53d6\u6d88\u5931\u8d25");
        }
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @PutMapping
    public ResData editSelectedCarts(@RequestBody List<Integer> cartIds, @RequestParam(value="selected") Integer selected, HttpSession session) throws MissingServletRequestParameterException {
        this.logger.info(cartIds + "\u6279\u91cf\u9009\u4e2d/\u53d6\u6d88");
        if (cartIds.isEmpty()) {
            throw new MissingServletRequestParameterException("cartIds", "\u8d2d\u7269\u8f66id\u5fc5\u987b\u4f20\u5165");
        }
        User user = (User)session.getAttribute("user");
        int result = this.cartService.updateSelectedCarts(cartIds, selected, user.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @GetMapping
    public ResData queryCarts(@RequestParam(value="pageSize", defaultValue="100") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, HttpSession session) {
        this.logger.info(pageSize + "\t" + pageNum + " \u67e5\u8be2\u8d2d\u7269\u8f66\u6709\u5e93\u5b58");
        User user = (User)session.getAttribute("user");
        PageInfo pageInfo = this.cartService.queryHasStockCarts(pageSize, pageNum, user.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)pageInfo);
    }

    @GetMapping(value={"/stockout"})
    public ResData queryStockoutCarts(@RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, HttpSession session) {
        this.logger.info(pageSize + "\t" + pageNum + "\u67e5\u8be2\u8d2d\u7269\u8f66\u6ca1\u6709\u5e93\u5b58");
        User user = (User)session.getAttribute("user");
        PageInfo pageInfo = this.cartService.queryStockoutCarts(pageSize, pageNum, user.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)pageInfo);
    }

    @GetMapping(value={"/book/{bookId:\\d+}"})
    public ResData queryBookInCart(@PathVariable Integer bookId, HttpSession session) {
        this.logger.info(bookId + "\u67e5\u8be2\u662f\u5426\u5728\u8d2d\u7269\u8f66\u4e2d");
        User user = (User)session.getAttribute("user");
        if (user == null || user.getId() == null) {
            return ResData.ofSuccess((Integer)3005, (String)"\u672a\u767b\u5f55\u7684\u7528\u6237");
        }
        Cart cart = this.cartService.queryBookInCart(bookId, user.getId());
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)cart);
    }

    @GetMapping(value={"/count"})
    public ResData queryHasStockCartsCount(HttpSession session) {
        this.logger.info("\u67e5\u8be2\u7528\u6237\u8d2d\u7269\u8f66\u6709\u5e93\u5b58\u5546\u54c1\u6570\u91cf");
        User user = (User)session.getAttribute("user");
        if (user == null || user.getId() == null) {
            return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)0);
        }
        int count = this.cartService.queryHasStockCartCount(user.getId());
        this.logger.info(count + "");
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)count);
    }
}

