/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.book;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.model.BookSku;
import com.c1801.spring.dzy.model.Sku;
import com.c1801.spring.dzy.service.BookService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/book"})
public class ManageBookController {
    @Autowired
    private BookService bookService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public ResData getBookInfoList(@RequestParam(value="name", defaultValue="", required=false) String name, @RequestParam(value="author", defaultValue="", required=false) String author, @RequestParam(value="minStock", required=false) Integer minStock, @RequestParam(value="maxStock", required=false) Integer maxStock, @RequestParam(value="minSale", required=false) Integer minSale, @RequestParam(value="maxSale", required=false) Integer maxSale, @RequestParam(value="minStatus", required=false) Integer minStatus, @RequestParam(value="maxStatus", required=false) Integer maxStatus, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="nameStatus", required=false) Integer nameStatus, @RequestParam(value="totalStatus", required=false) Integer totalStatus) {
        this.logger.info("name = " + name + author + minStock + maxStock + minSale + maxSale + minStatus + maxStatus + pageSize + pageNum + nameStatus + totalStatus);
        PageInfo bookList = this.bookService.queryBookInfoOfPage(name, author, minStock, maxStock, minSale, maxSale, minStatus, maxStatus, pageSize, pageNum, nameStatus, totalStatus);
        this.logger.info("bookList\uff1a" + bookList);
        System.out.println("nameStatus:" + nameStatus);
        System.out.println("totalStatus:" + totalStatus);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)bookList);
    }

    @GetMapping(value={"/sku"})
    public ResData getBookSkuList(@RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum) {
        this.logger.info("name = " + name + " pageSize = " + pageSize + " pageNum =" + pageNum);
        if (StringUtils.isEmpty((Object)name.trim())) {
            name = null;
        }
        this.logger.info("\u67e5\u8be2\u6240\u6709\u4e66\u7c4d\u5355\u54c1\u4fe1\u606f");
        List bookSkuList = this.bookService.getBookSkuList(name, pageSize, pageNum);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)bookSkuList);
    }

    @GetMapping(value={"/sku/{bookId:\\d{1,13}+}"})
    public ResData getBook(@PathVariable Integer bookId) {
        this.logger.info("\u67e5\u8be2\u672c\u4e66\u7c4d\u6240\u6709\u5355\u54c1\u4fe1\u606f = " + bookId);
        BookSku bookSku = this.bookService.getBookSku(bookId);
        this.logger.info("bookSku = " + bookSku);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)bookSku);
    }

    @PutMapping
    public ResData updateSku(@RequestBody Sku sku) throws MissingServletRequestParameterException {
        this.logger.info("\u4fee\u6539 sku = " + sku);
        if (sku.getId() == null) {
            throw new MissingServletRequestParameterException("id", "\u5fc5\u987b\u6709\u7528\u6237id\u53c2\u6570");
        }
        int i = this.bookService.updateSku(sku);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)i);
    }

    @DeleteMapping(value={"/sku/{id:\\d+}"})
    public ResData delSku(@PathVariable(value="id") Integer id) {
        this.logger.info("id = " + id);
        int i = this.bookService.delSku(id);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)i);
    }
}

