/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.book;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.model.BookSku;
import com.c1801.spring.dzy.service.BookCategoryService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@RestController
@RequestMapping(value={"/manage/book/category"})
public class ManageBookCategoryController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BookCategoryService bookCategoryService;

    @PostMapping
    public ResData bookAppendCategory(@RequestBody BookSku bookCategories) throws MissingServletRequestParameterException {
        if (bookCategories.getId() == null) {
            throw new MissingServletRequestParameterException("id", "\u4e66\u7c4did\u5fc5\u987b\u53c2\u5165");
        }
        if (bookCategories.getCategorys() == null || bookCategories.getCategorys().isEmpty()) {
            throw new MissingServletRequestParameterException("categorys", "\u5206\u7c7b\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a");
        }
        this.logger.info("bookCategories = " + bookCategories);
        int i = this.bookCategoryService.bookAppendCategory(bookCategories);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)i);
    }

    @DeleteMapping
    public ResData delCategoryFromBook(@RequestBody BookSku bookCategories) {
        int i = this.bookCategoryService.delCategoryFromBook(bookCategories);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)i);
    }

    @GetMapping(value={"/{bookId:\\d+}"})
    public ResData getCategoryInBook(@PathVariable Integer bookId) {
        this.logger.info("\u67e5\u8be2\u51fa\u6709\u7684\u5206\u7c7b\u6807\u7b7e" + bookId);
        List categoryInBook = this.bookCategoryService.getCategoryInBook(bookId);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)categoryInBook);
    }

    @GetMapping(value={"/not/{bookId:\\d+}"})
    public ResData getCategoryNotBook(@PathVariable Integer bookId) {
        this.logger.info("\u67e5\u8be2\u51fa\u4e66\u7c4d\u6ca1\u6709\u7684\u5206\u7c7b\u6807\u7b7e" + bookId);
        List categoryInBook = this.bookCategoryService.getCategoryNotBook(bookId);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)categoryInBook);
    }
}

