/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.book;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.model.BookInfo;
import com.c1801.spring.dzy.service.BookService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/dzy/book"})
public class BookController {
    @Autowired
    private BookService bookService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public ResData getIsSellBookSkuList(@RequestParam(value="name", defaultValue="") String name, @RequestParam(value="rate", defaultValue="0") Double rate, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum) {
        this.logger.info("name = " + name + " rate=" + rate + " pageSize = " + pageSize + " pageNum =" + pageNum);
        if (StringUtils.isEmpty((Object)name.trim())) {
            name = null;
        }
        this.logger.info("\u67e5\u8be2\u6240\u6709\u4e66\u7c4d\u5355\u54c1\u4fe1\u606f");
        PageInfo bookSkuList = this.bookService.queryIsSellBookInfoList(name, rate, pageSize, pageNum);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)bookSkuList);
    }

    @GetMapping(value={"/{bookId:\\d{1,13}+}"})
    public ResData getIsSellBook(@PathVariable(value="bookId") Integer bookId) {
        this.logger.info("\u67e5\u8be2\u672c\u4e66\u7c4d\u6240\u6709\u5355\u54c1\u4fe1\u606f = " + bookId);
        BookInfo bookInfo = this.bookService.getIsSellBookInfo(bookId);
        this.logger.info("bookInfo = " + bookInfo);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)bookInfo);
    }

    @GetMapping(value={"/sku/{bookId:\\d+}"})
    public ResData getBook(@PathVariable Integer bookId) {
        this.logger.info("\u67e5\u8be2\u672c\u4e66\u7c4d\u6240\u6709\u5355\u54c1\u4fe1\u606f = " + bookId);
        List skus = this.bookService.querySkuByBookId(bookId);
        this.logger.info("bookSku = " + skus);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)skus);
    }
}

