/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.admin;

import com.c1801.spring.dzy.common.PageInfo;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.model.Admin;
import com.c1801.spring.dzy.service.AdminService;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/manage/admin"})
public class AdminController {
    @Autowired
    private AdminService adminService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping
    public ResData addAdmin(@RequestBody @Valid Admin admin) {
        this.logger.info("\u65b0\u589e\u7ba1\u7406\u5458 = " + admin);
        int result = this.adminService.addAdmin(admin);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @DeleteMapping(value={"/{id:\\d+}"})
    public ResData deleteAdmin(@PathVariable Integer id) {
        this.logger.info("\u5220\u9664\u7ba1\u7406\u5458 = " + id);
        int result = this.adminService.delAdmin(id);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @PutMapping
    public ResData updateAdmin(@RequestBody @Valid Admin admin) throws MissingServletRequestParameterException {
        this.logger.info("\u4fee\u6539admin = " + admin);
        if (admin.getId() == null) {
            throw new MissingServletRequestParameterException("id", "\u5fc5\u987b\u6709\u7528\u6237id\u53c2\u6570");
        }
        int result = this.adminService.updateAdmin(admin);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)result);
    }

    @GetMapping(value={"/{id:\\d+}"})
    public ResData getAdmin(@PathVariable Integer id) {
        this.logger.info("\u6839\u636eid\u83b7\u53d6 = " + id);
        Admin admin = this.adminService.getAdmin(id);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)admin);
    }

    @GetMapping
    public ResData adminList(@RequestParam(value="name", defaultValue="", required=false) String name, @RequestParam(value="pageSize", defaultValue="5") Integer pageSize, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(defaultValue="", required=false) String minDate, @RequestParam(defaultValue="", required=false) String maxDate) {
        this.logger.info("\u67e5\u8be2\u6240\u6709\u7ba1\u7406\u5458\u7528\u6237 = ");
        PageInfo pageInfo = this.adminService.queryAdminListOfPage(name, pageSize, pageNum, minDate, maxDate);
        return ResData.ofSuccess((Integer)0, (String)"\u6210\u529f", (Object)pageInfo);
    }
}

