/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.controller.addr;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.AddrMapper;
import com.c1801.spring.dzy.mapper.OrderMapper;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.Address;
import com.c1801.spring.dzy.model.User;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/dzy/addr"})
public class AddrController {
    @Autowired
    AddrMapper addrMapper;
    @Autowired
    UserMapper userMapper;
    @Autowired
    OrderMapper orderMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public ResData getAddrByUserId(HttpSession session) {
        User u = (User)session.getAttribute("user");
        User user = this.userMapper.getUserById(u.getId());
        Address addr = this.addrMapper.getAddrById(user.getAddrId());
        this.logger.info("\u7528\u6237\u83b7\u53d6\u5730\u5740\uff1a" + addr);
        return ResData.of((Integer)0, (String)"\u6210\u529f", (Object)addr);
    }

    @PutMapping
    public ResData editAddr(@RequestBody Address addr, @RequestParam(value="orderId") Integer orderId, HttpSession session) {
        User u = (User)session.getAttribute("user");
        User user = this.userMapper.getUserById(u.getId());
        if (user == null) {
            return ResData.ofSuccess((Integer)10033, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        this.addrMapper.updateAddr(addr, user.getAddrId());
        Integer data = this.orderMapper.updateOrderAddr(orderId, addr);
        return ResData.ofSuccess((Integer)0, (String)"\u4fee\u6539\u5730\u5740\u6210\u529f", (Object)data);
    }
}

