/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.config;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PrintSqlPlugin
implements Interceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object intercept(Invocation invocation) throws Throwable {
        RoutingStatementHandler target = (RoutingStatementHandler)invocation.getTarget();
        BoundSql boundSql = target.getBoundSql();
        String sql = boundSql.getSql();
        SimpleDateFormat dateFormat = new SimpleDateFormat("YY-MM-dd HH:mm:ss");
        String topLine = "------------------------------------------------------------------------------------------------------------------------------";
        System.out.printf("\n\n" + topLine + "\n" + dateFormat.format(new Date(System.currentTimeMillis())) + "\nSQL:\n%s \n%s\n", sql, "\u53c2\u6570\t" + boundSql.getParameterObject() + "\n" + topLine + "\n\n");
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.logger.info("properties\uff1a" + properties);
    }
}

