/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.config;

import com.alibaba.fastjson.JSON;
import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.mapper.UserMapper;
import com.c1801.spring.dzy.model.Account;
import com.c1801.spring.dzy.model.User;
import com.c1801.spring.dzy.service.UserService;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogCostInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Map<String, Account> accountMap;
    @Autowired
    private UserService userService;
    @Autowired
    UserMapper userMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.logger.info("request.getHeader(\"Cookie\") = " + request.getHeader("Cookie"));
        this.logger.info("request.getHeader(\"token\") = " + request.getHeader("token"));
        this.logger.info("accountMap = " + this.accountMap);
        this.logger.info("\u5f53\u524d\u8bf7\u6c42\u7684\u63a5\u53e3 = " + request.getRequestURI());
        HttpSession session = request.getSession();
        ServletOutputStream output = response.getOutputStream();
        response.setContentType("application/json;charset=utf-8");
        User user = (User)session.getAttribute("user");
        if (user == null) {
            ResData res = ResData.ofFail((Integer)2002, (String)"\u8bf7\u767b\u5f55", null);
            output.write(JSON.toJSONString((Object)res).getBytes());
            output.flush();
            return false;
        }
        if (this.userService.queryUserEnabled(user.getId()) != null && this.userService.queryUserEnabled(user.getId()) == 0) {
            ResData res = ResData.ofFail((Integer)2003, (String)"\u8d26\u53f7\u88ab\u7981\u7528", null);
            output.write(JSON.toJSONString((Object)res).getBytes());
            output.flush();
            session.removeAttribute("user");
            session.invalidate();
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

