/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.config;

import com.c1801.spring.dzy.common.ResData;
import com.c1801.spring.dzy.common.exception.CusBookException;
import com.c1801.spring.dzy.config.ExceptionEmial;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class ContronllerAdvice {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ExceptionEmial exceptionEmial;

    @ExceptionHandler
    public ResData exception(Exception e) {
        this.logger.info("\u62e6\u622a\u5f02\u5e38e = " + e);
        if (e instanceof MethodArgumentNotValidException) {
            List fieldErrors = ((MethodArgumentNotValidException)e).getBindingResult().getFieldErrors();
            HashMap errorsMsg = new HashMap();
            fieldErrors.forEach(error -> errorsMsg.put(error.getField(), error.getDefaultMessage() + " \u3010" + error.getRejectedValue() + "\u3011"));
            this.logger.info("errorcode = 1000");
            return ResData.ofFail((Integer)1000, null, errorsMsg);
        }
        if (e instanceof MissingServletRequestParameterException) {
            this.logger.info("errorcode = 1001");
            return ResData.ofFail((Integer)1001, (String)e.getMessage());
        }
        if (e instanceof MethodArgumentTypeMismatchException) {
            this.logger.info("errorcode = 1002");
            return ResData.ofFail((Integer)1002, (String)e.getMessage());
        }
        if (e instanceof HttpMediaTypeNotSupportedException) {
            this.logger.info("errorcode = 1003");
            return ResData.ofFail((Integer)1003, (String)e.getMessage());
        }
        if (e instanceof HttpMessageNotReadableException) {
            this.logger.info("errorcode = 1004");
            return ResData.ofFail((Integer)1004, (String)e.getMessage());
        }
        if (e instanceof HttpRequestMethodNotSupportedException) {
            this.logger.info("errorcode = 1005");
            return ResData.ofFail((Integer)1005, (String)"\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5339\u914d", (Object)e.getMessage());
        }
        if (e instanceof CusBookException) {
            this.exceptionEmial.exceptionEmial(e);
            return ResData.ofFail((Integer)1006, (String)"\u8bf7\u6c42\u56fe\u4e66api\u5931\u8d25", (Object)e.getMessage());
        }
        e.printStackTrace();
        this.logger.info("errorcode = 2000");
        return ResData.ofFail((Integer)2000, (String)e.getMessage());
    }
}

