/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common.wx.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.c1801.spring.dzy.common.wx.msg.WXMsg;
import com.c1801.spring.dzy.common.wx.sdk.WXConfigParam;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Configuration
public class SDKConfig {
    private RestTemplate restTemplate = new RestTemplate();
    private static String accessToken = null;
    private static int accessExpiresIn = 0;
    private static long accessUpdateDate = 0L;
    private static String jsapiTicket = null;
    private static int ticketExpiresIn = 0;
    private static long ticketUpdateDate = 0L;
    private static final String ACCESS_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String JSAPI_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String TEMPLATE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=%s";

    public String getAccessToken(String appId, String secret, boolean refresh) {
        long updateDate = System.currentTimeMillis() / 1000L;
        if (accessToken != null && updateDate - accessUpdateDate < (long)(accessExpiresIn + 120) && !refresh) {
            return accessToken;
        }
        System.out.println("\u5237\u65b0access");
        accessUpdateDate = updateDate;
        String accessUrl = String.format(ACCESS_URL, appId, secret);
        ResponseEntity accessEntity = this.restTemplate.getForEntity(accessUrl, String.class, new Object[0]);
        System.out.println("\n\n accessEntity = " + accessEntity.getStatusCode());
        System.out.println("accessEntity.getBody() = " + (String)accessEntity.getBody());
        JSONObject jsonObject = JSON.parseObject((String)((String)accessEntity.getBody()));
        accessToken = jsonObject.getString("access_token");
        accessExpiresIn = jsonObject.getInteger("expires_in");
        return accessToken;
    }

    public WXConfigParam getWXConfig(String appId, String accessToken, String url, boolean refresh) {
        String jsApiTicketUrl = String.format(JSAPI_TICKET_URL, accessToken);
        long updateDate = System.currentTimeMillis() / 1000L;
        if (jsapiTicket == null || updateDate - ticketUpdateDate > (long)(ticketExpiresIn - 120) || refresh) {
            System.out.println("\u5237\u65b0 ticket");
            ticketUpdateDate = updateDate;
            String jsapiTicketObject = (String)this.restTemplate.getForObject(jsApiTicketUrl, String.class, new Object[0]);
            System.out.println("\n\n jsapiTicket = " + jsapiTicketObject);
            JSONObject jsonObject = JSON.parseObject((String)jsapiTicketObject);
            jsapiTicket = jsonObject.getString("ticket");
            ticketExpiresIn = jsonObject.getInteger("expires_in");
            System.out.println("\n\n jsapiTicketJsonObject = " + jsonObject);
        }
        TreeMap map = new TreeMap();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("timestamp", System.currentTimeMillis() / 1000L + "");
        params.put("noncestr", UUID.randomUUID().toString().replaceAll("-", ""));
        params.put("jsapi_ticket", jsapiTicket);
        params.put("url", url);
        String sign = this.sign(params);
        WXConfigParam wxConfig = new WXConfigParam();
        wxConfig.setAppId(appId);
        wxConfig.setTimestamp((String)params.get("timestamp"));
        wxConfig.setNonceStr((String)params.get("noncestr"));
        wxConfig.setSignature(sign);
        return wxConfig;
    }

    public String sendTemplateMsg(String appId, String accessToken, String templateId, String openId, Map<String, WXMsg> templateMsgs, String url) {
        System.out.println("\u6a21\u677f\u6d88\u606faccessToken = " + accessToken);
        JSONObject params = new JSONObject();
        params.put("touser", (Object)openId);
        params.put("appId", (Object)appId);
        params.put("template_id", (Object)templateId);
        params.put("url", (Object)url);
        params.put("data", templateMsgs);
        String templateObject = (String)this.restTemplate.postForObject(String.format(TEMPLATE_URL, accessToken), (Object)params, String.class, new Object[0]);
        return templateObject;
    }

    private String sign(Map map) {
        Set keySet = map.keySet();
        StringBuffer sign = new StringBuffer();
        map.forEach((key, value) -> {
            if (sign.length() > 0) {
                sign.append("&");
            }
            sign.append(key).append("=").append(value);
        });
        System.out.println("sign = " + sign);
        String sha1Sign = DigestUtils.sha1Hex((String)sign.toString());
        return sha1Sign;
    }
}

