/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common.wx.auth;

import com.alibaba.fastjson.JSON;
import com.c1801.spring.dzy.common.wx.auth.AccessToken;
import com.c1801.spring.dzy.common.wx.auth.WXUser;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
public class WXAuth {
    private RestTemplate restTemplate = new RestTemplate();
    private static final String ACCESS_TOKE_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";

    public AccessToken auth(String appId, String secret, String code) {
        String accessTokeUrl = String.format(ACCESS_TOKE_URL, appId, secret, code);
        ResponseEntity tokenEntity = this.restTemplate.getForEntity(accessTokeUrl, String.class, new Object[0]);
        System.out.println("tokenEntity = " + tokenEntity.getStatusCode());
        AccessToken access = (AccessToken)JSON.parseObject((String)((String)tokenEntity.getBody()), AccessToken.class);
        System.out.println("\n access = " + access);
        return access;
    }

    public WXUser getWXUser(String accessToken, String openId) {
        this.restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        String userInfoUrl = String.format(USER_INFO_URL, accessToken, openId);
        ResponseEntity userEntity = this.restTemplate.getForEntity(userInfoUrl, String.class, new Object[0]);
        System.out.println("\n\n forEntity = " + userEntity.getStatusCode());
        WXUser user = (WXUser)JSON.parseObject((String)((String)userEntity.getBody()), WXUser.class);
        System.out.println("user = " + user);
        return user;
    }
}

