/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common.shortmsg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.c1801.spring.dzy.common.exception.ShortException;
import com.c1801.spring.dzy.model.ShortMessageConfiguration;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortMessage {
    private static final Logger logger = LoggerFactory.getLogger(ShortMessage.class);

    public static String getVerCode(String phone, ShortMessageConfiguration smc) throws ClientException, ServerException, ShortException {
        DefaultProfile profile = DefaultProfile.getProfile((String)smc.getAccessKey(), (String)smc.getAccessId(), (String)smc.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(smc.getDomain());
        request.setVersion(smc.getVersion());
        request.setAction(smc.getAction());
        request.putQueryParameter("RegionId", smc.getAccessKey());
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("SignName", smc.getSignName());
        request.putQueryParameter("TemplateCode", smc.getTemplateCode());
        String verCode = String.valueOf(ThreadLocalRandom.current().nextInt(100000, 999999));
        request.putQueryParameter("TemplateParam", "{\"code\":\"" + verCode + "\"}");
        CommonResponse response = client.getCommonResponse(request);
        int status = response.getHttpStatus();
        logger.info(status + "");
        logger.info("\u53d1\u9001\u77ed\u4fe1\u5b8c\u6210");
        logger.info(response.getData());
        JSONObject jsonObject = JSON.parseObject((String)response.getData());
        String code = jsonObject.getString("Code");
        if (!"OK".equals(code)) {
            throw new ShortException("1007", jsonObject.getString("Message"));
        }
        return verCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShortMessage)) {
            return false;
        }
        ShortMessage other = (ShortMessage)o;
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShortMessage;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

