/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common.email;

import com.c1801.spring.dzy.common.email.Email;
import com.c1801.spring.dzy.common.email.IMailService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class MailServiceImpl
implements IMailService {
    private static final Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    public Configuration configuration;
    @Value(value="${spring.mail.username}")
    public String USER_NAME;

    public void send(Email mail) {
        try {
            logger.info("\u53d1\u9001\u666e\u901a\u6587\u672c\u90ae\u4ef6\uff1a{}", (Object)mail.getContent());
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.USER_NAME);
            message.setTo(mail.getEmail());
            message.setSubject(mail.getSubject());
            message.setText(mail.getContent());
            this.mailSender.send(message);
        }
        catch (Exception e) {
            logger.info("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public void sendFreemarker(Email mail) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.USER_NAME, "\u7cfb\u7edf\u90ae\u4ef6\u901a\u77e5");
            helper.setTo(mail.getEmail());
            helper.setSubject(mail.getSubject());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("mail", mail);
            model.put("exception", mail.getKvMap());
            Template template = this.configuration.getTemplate(mail.getTemplate());
            String text = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, model);
            helper.setText(text, true);
            this.mailSender.send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        System.setProperty("mail.mime.splitlongparameters", "false");
    }
}

