/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZXingUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZXingUtil.class);

    private ZXingUtil() {
        throw new IllegalStateException("ZXingUtil class");
    }

    public static String getBase64QRCodeData(String content, int width, int height) {
        return "data:image/jpg;base64," + ZXingUtil.getBase64QRCode((String)content, (int)width, (int)height);
    }

    public static String getBase64QRCode(String content, int width, int height) {
        return Base64.getEncoder().encodeToString(ZXingUtil.getBytes((String)content, (int)width, (int)height));
    }

    public static byte[] getBytes(String content, int width, int height) {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.MARGIN, 1);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            logger.error(e.getMessage());
        }
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        return ZXingUtil.imageToBytes((BufferedImage)image, (String)"jpg");
    }

    private static byte[] imageToBytes(BufferedImage image, String type) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, type, out);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage());
        }
        return out.toByteArray();
    }

    public static BufferedImage toBufferedImageCustom(BitMatrix matrix) {
        int left = 3;
        int right = 4;
        int top = 2;
        int bottom = 2;
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + left + right;
        int resHeight = rec[3] + top + bottom;
        BitMatrix matrix2 = new BitMatrix(resWidth, resHeight);
        matrix2.clear();
        for (int i = left + 1; i < resWidth - right; ++i) {
            for (int j = top + 1; j < resHeight - bottom; ++j) {
                if (!matrix.get(i - left + rec[0], j - top + rec[1])) continue;
                matrix2.set(i, j);
            }
        }
        int width = matrix2.getWidth();
        int height = matrix2.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (x < left || x > width - right || y < top || y > height - bottom) {
                    image.setRGB(x, y, -16777216);
                    continue;
                }
                image.setRGB(x, y, matrix2.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

