/*
 * Decompiled with CFR 0.152.
 */
package com.c1801.spring.dzy.common;

import com.github.pagehelper.Page;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageInfo<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer pageNum;
    private Integer pageSize;
    private Long total;
    private Integer pages;
    private List<T> list;
    private boolean isFirsPage = false;
    private boolean isLastPage = false;

    public static PageInfo ofPageInfo(Page page) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.pageNum = page.getPageNum();
        pageInfo.pageSize = page.getPageSize();
        pageInfo.pages = page.getPages();
        pageInfo.list = page.getResult();
        pageInfo.total = page.getTotal();
        pageInfo.judgePageBoudary();
        return pageInfo;
    }

    public static PageInfo ofEmpty(Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(Collections.emptyList());
        pageInfo.setPageNum(Integer.valueOf(1));
        pageInfo.setPages(Integer.valueOf(0));
        pageInfo.setTotal(Long.valueOf(0L));
        pageInfo.setPageSize(pageSize);
        pageInfo.judgePageBoudary();
        return pageInfo;
    }

    private void judgePageBoudary() {
        this.isFirsPage = this.pageNum == 1;
        this.isLastPage = this.pageNum.equals(this.pages);
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotal() {
        return this.total;
    }

    public Integer getPages() {
        return this.pages;
    }

    public List<T> getList() {
        return this.list;
    }

    public boolean isFirsPage() {
        return this.isFirsPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setFirsPage(boolean isFirsPage) {
        this.isFirsPage = isFirsPage;
    }

    public void setLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$pages = this.getPages();
        Integer other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        List this$list = this.getList();
        List other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        if (this.isFirsPage() != other.isFirsPage()) {
            return false;
        }
        return this.isLastPage() == other.isLastPage();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        List $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        result = result * 59 + (this.isFirsPage() ? 79 : 97);
        result = result * 59 + (this.isLastPage() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PageInfo(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", pages=" + this.getPages() + ", list=" + this.getList() + ", isFirsPage=" + this.isFirsPage() + ", isLastPage=" + this.isLastPage() + ")";
    }
}

