/*
 * @lc app=leetcode id=232 lang=kotlin
 *
 * [232] Implement Queue using Stacks
 *
 * https://leetcode.com/problems/implement-queue-using-stacks/description/
 *
 * algorithms
 * Easy (42.54%)
 * Total Accepted:    144.7K
 * Total Submissions: 338K
 * Testcase Example:  '["MyQueue","push","push","peek","pop","empty"]\n[[],[1],[2],[],[],[]]'
 *
 * Implement the following operations of a queue using stacks.
 *
 *
 * push(x) -- Push element x to the back of queue.
 * pop() -- Removes the element from in front of queue.
 * peek() -- Get the front element.
 * empty() -- Return whether the queue is empty.
 *
 *
 * Example:
 *
 *
 * MyQueue queue = new MyQueue();
 *
 * queue.push(1);
 * queue.push(2);
 * queue.peek();  // returns 1
 * queue.pop();   // returns 1
 * queue.empty(); // returns false
 *
 * Notes:
 *
 *
 * You must use only standard operations of a stack -- which means only push to
 * top, peek/pop from top, size, and is empty operations are valid.
 * Depending on your language, stack may not be supported natively. You may
 * simulate a stack by using a list or deque (double-ended queue), as long as
 * you use only standard operations of a stack.
 * You may assume that all operations are valid (for example, no pop or peek
 * operations will be called on an empty queue).
 *
 *
 */
class MyQueue() {

    /** Initialize your data structure here. */
    val q = mutableListOf<Int>()

    /** Push element x to the back of queue. */
    fun push(x: Int) {
        q.add(x)
    }

    /** Removes the element from in front of queue and returns that element. */
    fun pop(): Int {
        return q[0].also { q.removeAt(0) }
    }

    /** Get the front element. */
    fun peek(): Int {
        return q[0]
    }

    /** Returns whether the queue is empty. */
    fun empty(): Boolean {
        return q.size == 0
    }
}

/**
 * Your MyQueue object will be instantiated and called as such:
 * var obj = MyQueue()
 * obj.push(x)
 * var param_2 = obj.pop()
 * var param_3 = obj.peek()
 * var param_4 = obj.empty()
 */
