# Awesome Backend Engineer

**EN**
A curated **and opinionated** list of resources (English & Russian) for Backend developers that will help you orginize & structure your learning path and knowledges. Inspired by [Awesome CTO](https://github.com/kuchin/awesome-cto).

**RU**
Структурированный список ресурсов для изучения Backend разработки, который поможет систематизировать свои знания и составить план обучения. Основан на личном опыте и самостоятельном изучении данной области. Вдохновленно [Awesome CTO](https://github.com/kuchin/awesome-cto).

***На правах рекламы***
*Если вы интересуетесь бекендом и хотите прокачать теоретическую базу, советую познакомится с [курсом "Архитектура Современных Веб-Приложений"](https://www.zhashkevych.com/modern-web-architecture)*


## Contents
 * [Basics](#basics)
 * [Computer Science](#computer-science)
 * [Web Development & Networking](#web-development--networking)
 * [Databases](#databases)
 * [Security](#security)
 * [Architecture & Infrastracture](#architecture--infrastracture)
 * [Related links](#related-links)
 * [Books](#books)

## Basics
 * [Developer Roadmap](https://github.com/kamranahmedse/developer-roadmap)
 * [How to Become a Good Backend Engineer (Fundamentals)](https://www.youtube.com/watch?v=V3ZPPPKEipA&ab_channel=HusseinNasser)
 * [Learn to become a Backend Developer (2018)](https://medium.com/tech-tajawal/modern-backend-developer-in-2018-6b3f7b5f8b9)
 * [Advice for beginner backend engineers who just started their new jobs in software companies](https://www.youtube.com/watch?v=V3C0VvNrFZ8&ab_channel=HusseinNasser)
 
## Computer Science

Main topics | Основные темы
----------- | ----------
What is computer and how it works? | Что такое компьютер и как он работает?
Why do we need programming languages? What types of programming languages are out there? | Зачем нужны языки программирования? Какие типы бывают?
Algorithms & Data Structures | Алгоритмы и структуры данных
OOP | Объектно ориентированное программирование
Concurrency & Parallelism | Конкурентность и параллелизм

#### Resouses (Ресурсы)
* [What is Computer Science](https://www.youtube.com/watch?v=Tzl0ELY_TiM&ab_channel=ZachStar)
* [Map of Computer Science](https://www.youtube.com/watch?v=SzJ46YA_RaA&ab_channel=DoS-DomainofScience)
* CS50 by Harvard. [EN](https://cs50.harvard.edu/) / [RU](https://javarush.ru/quests/QUEST_HARVARD_CS50)
* [Computer Science Crash Course](https://www.youtube.com/watch?v=tpIctyqH29Q&list=PL8dPuuaLjXtNlUrzyH5r6jN9ulIgZBpdo&ab_channel=CrashCourse)
* [How do computers read code?](https://www.youtube.com/watch?v=QXjU9qTsYCc&ab_channel=FrameofEssence)
* [The Forgotten History of OOP](https://medium.com/javascript-scene/the-forgotten-history-of-oop-88d71b9b2d9f)
* [Concurrency is not Parallelism](https://youtu.be/oV9rvDllKEg)
* [Структуры данных для самых маленьких](https://habr.com/ru/post/310794/)
* [Алгоритмы и структуры данных. Подготовительный курс (весна 2016)](https://www.youtube.com/playlist?list=PLrCZzMib1e9pDxHYzmEzMmnMMUK-dz0_7)
* [ООП в картинках](https://habr.com/ru/post/463125/)
* [Многопроцессность, многопоточность, асинхронность в Python и не только. Что это и как работает?](https://youtu.be/JIp14T9bvvc)
* [Конкурентность и Параллелизм. Просто о сложном](https://youtu.be/-DYeH8kGKVA)

## Web Development & Networking

Main topics | Основные темы
----------- | ----------
What is client-server architecture and HTTP? | Что такое клиент-серверная архитектура и HTTP?
What is TCP/IP? | Что такое стек TCP/IP?
What is DNS? | Что такое DNS?
How authorization & authentication works? What is JWT? | Как работает авторизация и аутентификация? Что такое JWT?
Proxy & Reverse Proxy | Прокси и обратный прокси
Web servers. Nginx. | Веб-сервер. Nginx
REST API Design Principles | Принципы проектирования REST API

#### Resouses (Ресурсы)
* [Web Development In 2021 - A Practical Guide](https://youtu.be/VfGW0Qiy2I0)
* [What is TCP/IP?](https://youtu.be/PpsEaqJV_A0)
* [Hyper Text Transfer Protocol Crash Course - HTTP 1.0, 1.1, HTTP/2, HTTP/3](https://youtu.be/0OrmKCB0UrQ)
* [HTTP Crash Course & Exploration](https://youtu.be/iYM2zFP3Zn0)
* [TCP vs UDP Crash Course](https://www.youtube.com/watch?v=qqRYkcta6IE&ab_channel=HusseinNasser)
* [REST API concepts and examples](https://youtu.be/7YcW25PHnAA)
* [RESTful API](https://restfulapi.net/)
* [2 Hours NginX Crash Course + Bonus Content](https://youtu.be/hcw-NjOh8r0)
* [JWT - JSON Web Token Crash Course (NodeJS & Postgres)](https://youtu.be/T0k-3Ze4NLo)
* [Proxy vs Reverse Proxy Server Explained](https://youtu.be/SqqrOspasag)
* [How HTTP/2 Works, Performance, Pros & Cons and More](https://youtu.be/fVKPrDrEwTI)
* [How DNS Works - Computerphile](https://youtu.be/uOfonONtIuk)
* [gRPC Crash Course - Modes, Examples, Pros & Cons and more](https://youtu.be/Yw4rkaTc0f8)
* [Курс. Языки веб-программирования](https://www.youtube.com/playlist?list=PLrCZzMib1e9odW1P2LnmGfe_dypZTxO3I)
* [6. Web-технологии. Протокол HTTP | Технострим](https://youtu.be/HFt7Lm7hv1E)
* [Веб-разработка для начинающих 🚀 Как устроены веб-приложения? (Frontend/Backend)](https://youtu.be/nQBNH0x4YmI)
* [Архитектура Web Приложений / от простых до высоконагруженных](https://youtu.be/9mZmc6a0tmM)
* [Аутентификация в Веб-Приложениях 👨‍💻JWT и Сессии](https://youtu.be/w8ENQfaYIT8)
* [Введение в REST API — RESTful веб-сервисы](https://habr.com/ru/post/483202/)

## Databases

Main topics | Основные темы
----------- | ----------
What are database and DBMS? | Что такое база данных и СУБД?
What is a relational database? What is SQL? | Что такое реляционная БД и SQL?
What are indexes & transactions? | Что такое индексы и транзакции?
What are ACID properties? Which Isolation levels are out there? | Что такое свойства ACID? Какие есть уровни изоляции транзакций?
What are NoSQL Databases? What are the differences between NoSQL & SQL? | Что такое NoSQL? Какие различия между NoSQL и SQL?
What is databases normalization? | Что такое нормализация БД?

#### Resouses (Ресурсы)
* [What is a Database?](https://www.oracle.com/database/what-is-database/)
* [What is Database & SQL?](https://youtu.be/FR4QIeZaPeM)
* [SQL Tutorial - Full Database Course for Beginners](https://youtu.be/HXV3zeQKqGY)
* [Database Design Course - Learn how to design and plan a database for beginners](https://youtu.be/ztHopE5Wnpc)
* [Database Indexing Explained (with PostgreSQL)](https://youtu.be/-qNSXK7s7_w)
* [SQL vs NoSQL or MySQL vs MongoDB](https://youtu.be/ZS_kXvOeQ5Y)
* [Introduction to NoSQL databases](https://youtu.be/xQnIN9bW0og)
* [MongoDB Basics](https://university.mongodb.com/courses/M001/about)
* [MongoDB for SQL Pros](https://university.mongodb.com/courses/M100/about)
* [ACID](https://en.wikipedia.org/wiki/ACID)
* [🔥Разбираем SQL на примере PostgreSQL — SELECT, JOIN, GROUP, HAVING, Coalesce и др.](https://youtu.be/WpojDncIWOw)
* [Курс "Использование баз данных" (2019)](https://www.youtube.com/playlist?list=PLrCZzMib1e9reQb3ZXLWVaEu2CM3R54ho)
* [Курс "Базы данных. Лаборатория Tarantool" (2018)](https://www.youtube.com/playlist?list=PLrCZzMib1e9o-2km1HniylB-ZZteznvLb)
* [Руководство для начинающих: ACID и транзакции БД](http://akorsa.ru/2016/08/rukovodstvo-dlya-nachinayushhih-acid-i-tranzaktsii-bd/)
* [Как бы я сейчас объяснил молодому себе зачем существуют требования ACID для баз данных?](https://habr.com/ru/post/535616/)
* [Основы правил проектирования базы данных](https://habr.com/ru/post/514364/)
* [Нормализация отношений. Шесть нормальных форм](https://habr.com/ru/post/254773/)
* [Руководство по проектированию реляционных баз данных (1-3 часть из 15)](https://habr.com/ru/post/193136/)


## Security

Main topics | Основные темы
----------- | ----------
What is HTTPS and how does it work? | Что такое HTTPS и как он работает?
What are main types of attacks and vulnurabilities in web applications? | Какие существуют основные типы атак и уязвимостей в веб-приложениях?
What is SQL Injection? How to prevent it? | Что такое SQL инъекция? Как ее предотвратить?
What is XSS Attack? How to prevent it? | Что такое XSS атака? Как ее предотвратить?
How to store passwords/secrets in web app? | Как хранить пароли/секреты в веб приложении?

#### Resouses (Ресурсы)
* [9. Securing Web Applications](https://youtu.be/WlmKwIe9z1Q)
* [How does HTTPS work? What's a CA? What's a self-signed Certificate?](https://youtu.be/T4Df5_cojAs)
* [Password Cracking - Computerphile](https://youtu.be/7U-RbOKanYs)
* [Running an SQL Injection Attack - Computerphile](https://youtu.be/ciNHn38EyRc)
* [How NOT to Store Passwords! - Computerphile](https://youtu.be/8ZtInClXe1Q)
* [Cracking Websites with Cross Site Scripting - Computerphile](https://youtu.be/L5l9lSnNMxg)
* [Cross-Site Scripting (XSS) Explained](https://youtu.be/EoaDgUgS6QA)
* [Why LocalStorage is Vulnerable to XSS (and cookies are too)](https://youtu.be/M6N7gEZ-IUQ)
* [OWASP Cheat Sheat](https://cheatsheetseries.owasp.org/)
* [Как работает HTTPS?](https://youtu.be/B3j4SS5P8tM)
* [Безопасность интернет-приложений (2020)](https://www.youtube.com/playlist?list=PLrCZzMib1e9oopXP4-aumUxkbz_56Czon)
* [Как хранить пароли и ключи в коде проектов? Всё о переменных окружения. Пример с Django](https://youtu.be/Y9MRCxq4DIc)
* [SQL-инъекция. Оборона и нападение (часть 1)](https://youtu.be/eE-W2_M_mMU)
* [Что такое XSS-уязвимость и как тестировщику не пропустить ее](https://habr.com/ru/post/511318/)


## Architecture & Infrastracture

Main topics | Основные темы
----------- | ----------
What are distributed systems? | Что такое распределеные системы?
What is scaling? Horizontal vs Vertical scaling? How to scale web apps and databases? | Что такое масштабирование? Горизонтальное vs Вертикальное масштабирование? Как масштабировать веб-приложения и базы данных?
What is CAP Theorem? What are CP and AP systems? | Что такое CAP теорема? Как выглядят CP и AP системы?
What are Microservices? What patterns do they use? How to design microservices architecture? | Что такое микросервисы? Какие паттерны они используют? Как их проектировать?
What is Event-Driven Architecture? | Что такое Event-Driven архитектура?
What is Clean Architecture? How to implement it using your programming language / framework? | Что такое Чистая Архитектура? Как имплеменировать ее в вашем ЯП / фреймворке?
How to deploy web applications? What is VPS? What is SSH? | Как развертывать веб-приложения? Что такое VPS? Что такое SSH?
What is Docker? Why do we need it? | Что такое Docker? Зачем он нужен?
What are cloud providers? How do you use them? | Что такое клауд провайдеры и зачем они нужны?
How to automize testing & deployment? What is CI/CD? How to implement it? | Как автоматизировать тестирование и деплоймент? Что такое CI/CD и как его настроить?
What is SSL Certificate? How to set it up for your web app? | Что такое SSL сертификат? Как его настроить?
What is Kubernetes? When should you use it? | Что такое и зачем нужен Kubernetes?
What is DDD? | Что такое Domain Driven Design?

#### Resources (Ресурсы)
* [Approaching Distributed Systems](https://betterprogramming.pub/approaching-distributed-systems-958d9926d77b)
* [Scalable Web Architectures Concepts & Design](https://medium.com/distributed-knowledge/scalable-web-architectures-concepts-design-6fd372ee4541)
* [How to Scale SQL and NoSQL Databases](https://betterprogramming.pub/scaling-sql-nosql-databases-1121b24506df)
* [Scaling Your Web Application](https://medium.com/@harithjaved/scaling-your-web-application-693657ce333c)
* [CAP Theorem in Distributed Systems](https://medium.com/swlh/cap-theorem-in-distributed-systems-edd967e7bdf4)
* [How to Design a Web Application: Software Architecture 101](https://betterprogramming.pub/how-to-design-a-web-application-software-architecture-101-df568b88da76)
* [Introduction to Microservices](https://www.nginx.com/blog/introduction-to-microservices/)
* [Microservice Architecture at Medium](https://medium.engineering/microservice-architecture-at-medium-9c33805eb74f)
* [Mastering Chaos - A Netflix Guide to Microservices](https://youtu.be/CZ3wIuvmHeM)
* [GOTO 2020 • When To Use Microservices (And When Not To!) • Sam Newman & Martin Fowler](https://youtu.be/GBTdnfD6s5Q)
* [Modern Banking in 1500 Microservices](https://youtu.be/t7iVCIYQbgk)
* [Managing Data in Microservices](https://youtu.be/E8-e-3fRHBw)
* [What is DDD - Eric Evans - DDD Europe 2019](https://youtu.be/pMuiVlnGqjk)
* [The Clean Architecture](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html)
* [Learn Docker in 12 Minutes 🐳](https://youtu.be/YFl2mCHdv24)
* [Docker Tutorial for Beginners - A Full DevOps Course on How to Run Applications in Containers](https://youtu.be/fqMOX6JJhGo)
* [What is a Multitenancy Architecture and Why Is it becoming popular?](https://youtu.be/x8vtmX4vF9I)
* [The Twelve-Factor App](https://12factor.net/)
* [Блог HighLoad](https://ruhighload.com/%D0%A7%D1%82%D0%BE+%D1%82%D0%B0%D0%BA%D0%BE%D0%B5+highload)
* [Архитектура высоких нагрузок](https://ruhighload.com/%D0%90%D1%80%D1%85%D0%B8%D1%82%D0%B5%D0%BA%D1%82%D1%83%D1%80%D0%B0+%D0%B2%D1%8B%D1%81%D0%BE%D0%BA%D0%B8%D1%85+%D0%BD%D0%B0%D0%B3%D1%80%D1%83%D0%B7%D0%BE%D0%BA)
* [CAP-теорема простым, доступным языком](https://habr.com/ru/post/130577/)
* [Создание архитектуры программы или как проектировать табуретку](https://habr.com/ru/post/276593/)
* [Как получить и настроить LetsEncrypt SSL сертификат для сайта?](https://youtu.be/1wnOw1vwPEo)
* [Поднимаем Debian сервер для Python/Django — установка и настройка с нуля. Как настроить сервер?](https://youtu.be/FLiKTJqyyvs)
* [🚀 Деплой Fullstack Приложения [Golang+JS]. СI/CD, DigitalOcean, Github Actions](https://youtu.be/ceRTzKuCLnw)
* [Чистая архитектура](https://habr.com/ru/post/269589/)
* [Основы Docker. Большой практический выпуск](https://youtu.be/QF4ZF857m44)
* [Артём Антоненко «Domain Driven Design»](https://youtu.be/_CK5Kag7enw)
* [Настраиваем авторизацию SSH по ключу в Linux / Unix](https://youtu.be/IVHv3eVQa14)
* [🚀Собираем масштабируемую архитектуру веб-приложения. Горизонтальное и вертикальное масштабирование](https://www.youtube.com/watch?v=kclYmb47LTg&ab_channel=%D0%94%D0%B8%D0%B4%D0%B6%D0%B8%D1%82%D0%B0%D0%BB%D0%B8%D0%B7%D0%B8%D1%80%D1%83%D0%B9%21)


## Related Links
* [Good enough engineering to start an Internet company](https://medium.com/@wenbinf/good-enough-engineering-to-start-an-internet-company-f26be5b01025)
* [The boring technology behind a one-person Internet company](https://medium.com/@wenbinf/the-boring-technology-behind-listen-notes-56697c2e347b)
* [API as a product. How to sell your work when all you know is a back-end](https://towardsdatascience.com/api-as-a-product-how-to-sell-your-work-when-all-you-know-is-a-back-end-bd78b1449119)
* [UML for beginners](https://www.youtube.com/playlist?list=PLUoebdZqEHTxNC7hWPPwLsBmWI0KEhZOd)
* [The other side of technical skill: domain knowledge and long-term vision](https://medium.com/@sihui/the-other-side-of-technical-skill-domain-knowledge-and-long-term-vision-7db0602755da)
* [Going from Developer to CTO](https://medium.com/@simondowling/how-to-go-from-developer-to-cto-ce72d261c5fc)
* [What Truly Makes a Senior Developer](https://medium.com/s/story/what-truly-makes-a-senior-developer-74b608847d7e)
* [Что стоит за простой загрузкой веб-странички в браузере](https://medium.com/genesis-media/%D1%87%D1%82%D0%BE-%D1%81%D1%82%D0%BE%D0%B8%D1%82-%D0%B7%D0%B0-%D0%BF%D1%80%D0%BE%D1%81%D1%82%D0%BE%D0%B9-%D0%B7%D0%B0%D0%B3%D1%80%D1%83%D0%B7%D0%BA%D0%BE%D0%B9-%D0%B2%D0%B5%D0%B1-%D1%81%D1%82%D1%80%D0%B0%D0%BD%D0%B8%D1%87%D0%BA%D0%B8-%D0%B2-%D0%B1%D1%80%D0%B0%D1%83%D0%B7%D0%B5%D1%80%D0%B5-3933c96467a)

## Books
📚         | 📚
---------- | ----------
[Grokking Algorithms](https://www.amazon.com/Grokking-Algorithms-illustrated-programmers-curious/dp/1617292230) | [Грокаем Алгоритмы](https://github.com/mduisenov/GrokkingAlgorithms/blob/master/%D0%91%D1%85%D0%B0%D1%80%D0%B3%D0%B0%D0%B2%D0%B0%20%D0%90.%20-%20%D0%93%D1%80%D0%BE%D0%BA%D0%B0%D0%B5%D0%BC%20%D0%90%D0%BB%D0%B3%D0%BE%D1%80%D0%B8%D1%82%D0%BC%D1%8B.%20%D0%98%D0%BB%D0%BB%D1%8E%D1%81%D1%82%D1%80%D0%B8%D1%80%D0%BE%D0%B2%D0%B0%D0%BD%D0%BD%D0%BE%D0%B5%20%D0%BF%D0%BE%D1%81%D0%BE%D0%B1%D0%B8%D0%B5%20%D0%B4%D0%BB%D1%8F%20%D0%BF%D1%80%D0%BE%D0%B3%D1%80%D0%B0%D0%BC%D0%BC%D0%B8%D1%81%D1%82%D0%BE%D0%B2%20%D0%B8%20%D0%BB%D1%8E%D0%B1%D0%BE%D0%BF%D1%8B%D1%82%D1%81%D1%82%D0%B2%D1%83%D1%89%D0%B8%D1%85%20-%202017.PDF)
"Clean Code" by Robert Martin | "Чистый Код" Роберт Мартин
"Clean Architecture" by Robert Martin | "Чистая Архитектура" Роберт Мартин
"Professional Software Development" by Steve McConnel | “Профессиональная Разработка ПО” Стив Макконел
"Building Microservices" by Sam Newman | "Создание Микросервисов" Сэм Ньюман
["Microservices Patterns" by Chris Richardson](https://github.com/PhatBK/experience/blob/master/tech/Chris%20Richardson%20-%20Microservices%20Patterns_%20With%20examples%20in%20Java%20(2018%2C%20Manning%20Publications).pdf) | "Микросервисы. Паттерны разработки и рефакторинга" Крис Ричардсон
