# 数据库解决方案合集

# 1. 1130 Host is not allowed to connect to mysql 解决办法

就是mysql user表中对应用户的host字段不是连接服务器的客户端的ip。简单说就是不允许这个ip连接到mysql服务器。

解决办法：host设为%，表示允许所有ip地址以此身份连接mysql。或者改为这个ip地址。、

# 2. 查看mysql连接状态

show full processlist;

# 3. 完全卸载oracle11g步骤：

1、 开始－＞设置－＞控制面板－＞管理工具－＞服务 停止所有Oracle服务。

2、 开始－＞程序－＞Oracle - OraHome81－＞Oracle Installation Products－＞ Universal Installer，单击“卸载产品”-“全部展开”，选中除“OraDb11g_home1”外的全部目录，删除。

5、 运行regedit，选择HKEY_LOCAL_MACHINE\SOFTWARE\ORACLE，按del键删除这个入口。

6、 运行regedit，选择HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services，滚动这个列表，删除所有Oracle入口(以oracle或OraWeb开头的键)。

7、 运行refedit，HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application，删除所有Oracle入口。

8、 删除HKEY_CLASSES_ROOT目录下所有以Ora、Oracle、Orcl或EnumOra为前缀的键。

9、 删除HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs中所有以oracle开头的键。

10、删除HKEY_LOCAL_MACHINE\SOFTWARE\ODBC\ODBCINST.INI中除Microsoft ODBC for Oracle注册表键以外的所有含有Oracle的键。

11、我的电脑-->属性-->高级-->环境变量,删除环境变量CLASSPATH和PATH中有关Oracle的设定。 12、从桌面上、STARTUP（启动）组、程序菜单中，删除所有有关Oracle的组和图标。

13、删除所有与Oracle相关的目录(如果删不掉，重启计算机后再删就可以了)包括：  

a) C:\Program file\Oracle目录。   

b) ORACLE_BASE目录(oracle的安装目录)。

c) C:\WINDOWS\system32\config\systemprofile\Oracle目录。   

d) C:\Users\Administrator\Oracle或C:\Documents and Settings\Administrator\Oracle目录。

e) C:\WINDOWS下删除以下文件ORACLE.INI、oradim73.INI、oradim80.INI、oraodbc.ini等等。
f) C:\WINDOWS下的WIN.INI文件中若有[ORACLE]的标记段，删除该段。

14、如有必要，删除所有Oracle相关的ODBC的DSN

15、到事件查看器中，删除Oracle相关的日志 说明： 如果有个别DLL文件无法删除的情况，则不用理会，重新启动，开始新的安装，安装时，选择一个新的目录，则，安装完毕并重新启动后，老的目录及文件就可以删除掉了。


# 4. mysql 创建触发器

```mysql
2019/10/10 mysql创建触发器

drop TRIGGER if EXISTS AutoUpdateTypeText;
delimiter $$
CREATE TRIGGER AutoUpdateTypeText BEFORE UPDATE ON tblaccount for each ROW
BEGIN
	IF new.FType = 0 THEN
		set new.FTypeText='一般用户';
	ELSE
		SET new.FTypeText='特权用户';
	END IF;
END $$
delimiter ;

```

# 5. oracle listener.ora与tsnames.ora配置

oracle安装配置过程中出现 `ORA-12514: TNS: 监听程序当前无法识别连接描述符中请求的服务`;`ORA-28547: 连接服务器失败, 可能是 Oracle Net 管理错误`,都是因为这两个文件没有配置好。以配置本地oracle服务为例，修改这两个配置文件如下：

`listener.ora`如此配置

```shell
# listener.ora Network Configuration File: D:\app\luzhanhui\product\network\admin\listener.ora
# Generated by Oracle configuration tools.

SID_LIST_LISTENER =
   (SID_DESC =
      (SID_NAME = XXXXX)
      (ORACLE_HOME = D:\app\wangxiaoming\product)
  
    )


LISTENER =
  (DESCRIPTION_LIST =
    (DESCRIPTION =
      (ADDRESS = (PROTOCOL = TCP)(HOST = 127.0.0.1)(PORT = 1521))
  
    )
  )

ADR_BASE_LISTENER = D:\app\wangxiaoming

```

`tsnames.ora`如此配置

```shell

```

配置完成后重启listener服务

`lsnrctl stop`,`lsnrctl start`

再然后创建数据库

需要注意的是，一定要将配置的监听实例对应到相应的数据库。否则就会出现 `数据库服务未注册到监听程序`的错误。

这两个配置文件位置在oracle安装目录的 `\product\NETWORK\ADMIN`下。修改这两个文件要在其它位置修改好后复制替换（权限问题）。

# 6. oracle常用操作命令

## 6.1 创建表空间

```sql
create tablespace tsp_emr
	datafile 'D:\app\zhangsansan\oradata\jhemr\emr.dbf'
	size 20M
	reuse
	autoextend on
	next 5M
	maxsize unlimited;
```

## 6.2 创建用户并授权

```sql
create user emr
	identified by emr
	default tablespace tsp_emr
	temporary tablespace temp
	quota unlimited on tsp_emr;
grant connect,resource,dba to emr;
```

## 6.3 导出数据库到桌面

```sql
exp emr/emr@192.168.2.214:1521/emr file=C:\Users\wangxiaoming\Desktop\emr.dmp
```

## 6.4 导入dmp文件到数据库

```sql
imp medrec/medrec@localemrdb file=C:\Users\wangxiaoming\Desktop\medrec.dmp;
```

## 6.5 登录数据库

```sql
sqlplus emr/emr 或 sqlplus /nolog
```

## 6.6 级联删除用户所有数据

```
drop user emr cascade;
```

## 6.7 删除表空间

```sql
drop tablespace 表空间名称 including contents and datafiles;  
```

# 7. Oracle用例一则

```sql
select t.outpatient_id,
		t2.file_no,
		t3.patient_name,
		to_char(t.datetime_in,'yyyy-mm-dd') as datetime_in,
		t4.dept_name,
		t2.topic,
		nvl(t2.print_flag,0) as print_flag,
		t2.emr_doc
	from table1 t,
		table2 t2,
		table3 t3,
		table4 t4,
		table5 t5,
	where t.outpatient_id =t2.outpatient_id
		and t.patient_id=t3.patient_id
		and t2.dept_id=t4.dept_id
		and t.patient_id=t5.brid
		and t5.jzkh='2999999'
		and to_char(t2.CREATE_DATE_TIME,'yyyy-mm-dd')>=to_char(to_date('2018-06-01','yyyy-mm-dd')-7),'yyyy-mm-dd')
		and to_char(t2.CREATE_DATE_TIME,'yyyy-mm-dd')>'2011-05-01'
		order by t2.CREATE_DATE_TIME desc

   select to_char(sysdate-7,'yyyy-mm-dd') from dual;--查询距离今天7天的时间--将日期格式转为字符格式
   
   select * from t2 
   	where t2.outpatient_id='98839383738'
   	for update;--查询t2表中的数据并可修改
   
   select to_date('2018-06-01','yyyy-mm-dd')-7 from dual;--将字符格式转为日期格式
```

# 8. plsql激活

plsql激活码：

Product Code(产品编号)：4t46t6vydkvsxekkvf3fjnpzy5wbuhphqz

serial Number(序列号)：601769

password(口令)：xs374ca
