# 1. Web

## 1.1 CSS按钮背景渐变

要实现当鼠标放到按钮上时，背景色和字体色渐渐变成另一种颜色，离开时又变成另一种颜色。只需用transition属性就行了。

```css
.button{
    margin: 20px auto;
    line-height: 50px;
    width: 150px;
    height: 50px;
    display: block;
    text-decoration: none;
    font-weight: 100;
    font-size: 20px;
    border-radius: 5px;
    color: #B4B4B5;
    background: #333337;
    text-align: center;
    transition: all 900ms;
}

.button:hover{  
    background:#434346;
    color: #F0F0F0;
}
```

## 1.2 CSS禁用滚动条

如此设置：

```css
body{  
    overflow-y: hidden;
    overflow-x: hidden;
}
```

## 1.3 CSS禁用滚动条但仍可滚动

这样做：

```css
*{
    margin: 0;
    padding: 0;
    /* border: 1px solid red; */
    /* box-sizing: border-box; */
}

html{
    overflow: hidden;
}

body{/*滚动条将显示在body区域*/
    overflow-y: scroll;/*按需要显示*/
    overflow-x: hidden;/*始终不显示x方向的滚动条*/
    width: calc(100vw + 20px);/*设body宽为比视窗宽还要宽20像素，这样就可以把滚动条隐藏在视窗外*/
}
```


## 1.4 JS切换图片


如此写：

```js
//js文件

//窗口加载
this.onload=function(){
  
    // 获取图片列表
    var imageList=document.getElementsByClassName('imageList')[0].getElementsByTagName('li');

    // 设置图片列表项的可见性
    function changeItemVisiable(index) {
        for (var i = 0; i < imageList.length; i++) {
            imageList[i].style.display = 'none';
        }
        imageList[index].style.display = 'list-item';
    }
    changeItemVisiable(0);//默认使第一项可见 

    //设置间隔为2s
    var timeInterval=setInterval(changeItem,2000);

    var count=0;//计数变量
    //改变图片列表项的可见性
    function changeItem(){
        count++;
        count=count%5;
        changeItemVisiable(count);
    }  
}
```

对应HTML文件

```html

<ul class="imageList" style="list-style: none;">
    <li>
        <img src="images/2018-04-18_093957.png" alt="image1" width="348px" height="200px">
    </li>
    <li>
        <img src="images/2018-04-18_094016.png" alt="image2" width="348px" height="200px">
    </li>
    <li>
        <img src="images/2018-04-18_094025.png" alt="image3" width="348px" height="200px">
    </li>
    <li>
    	<img src="images/2018-04-18_094036.png" alt="image4" width="348px" height="200px">
    </li>
    <li>
    	<img src="images/2018-04-18_094123.png" alt="image5" width="348px" height="200px"> 
    </li>
</ul>
```


## 1.5 引用bootstrap字体图标


```html
<span class="glyphicon glyphicon-minus" aria-hidden="true"></span>
```


## 1.6 bootstrap progressbar没有动态效果

加了 `.progress-bar-animated`还是没有动态效果？再添加 `.active`就好了

## 1.7 electron require is not defined

原因是在下面代码中对require进行了重命名。

```html
    <script>
      window.nodeRequire = require;
      delete window.require;
      delete window.exports;
      delete window.module;
    </script>

```

将所有需要用到require的地方换成nodeRequire即可。


## 1.8 Electron渲染进程与主进程交互


某个Electron项目配置如下

```json
{
  "name": "nodejs-console-app1",
  "version": "0.0.0",
  "description": "NodejsConsoleApp1",
  "main": "app.js",
  "author": {
    "name": ""
 }
```

app.js规定的文件是可与主进程直接通信。项目其它任何位置都被视为在渲染进程内。主界面是Html页，其中不可避免地需要与主进程交互。例如，要实现窗体最小化，最大化，关闭窗体等功能，就需要触发Electron规定的一些事件，调用一些只有Electron库中规定的方法，以实现上述功能。可用 `ipcMain`和 `ipcRender`来在主渲进程间交互。

#### 一、渲染进程让主进程做事

```javascript
// Html页中的js

var ipcRenderer=nodeRequire('electron').ipcRenderer;
document.getElementById('self-min').onclick=function(){
    ipcRenderer.send('min-window')
}
document.getElementById('self-max').onclick=function(){
    var length=document.getElementsByClassName('glyphicon-resize-full').length
    if(length>0){
        ipcRenderer.send('max-window')
        document.getElementById('self-btn-max').className='glyphicon glyphicon-resize-small'
    }else{
        ipcRenderer.send('unmax-window')
        document.getElementById('self-btn-max').className='glyphicon glyphicon-resize-full'
    }      
}
document.getElementById('self-close').onclick=function(){
    ipcRenderer.send('quit-app')
}
```

```js
// app.js中的js

ipcMain.on('min-window', () => {
win.minimize()
})
ipcMain.on('max-window', () => {
win.maximize()
})
ipcMain.on('unmax-window', () => {
win.unmaximize()
})
ipcMain.on('quit-app', () => {
app.quit();
})
```

#### 二、主进程让渲染进程做事

```js
win.on('maximize',function(){
win.webContents.executeJavaScript(
"document.getElementById('self-btn-max').className='glyphicon glyphicon-resize-small'"
)
})
win.on('unmaximize',function(){
win.webContents.executeJavaScript(
"document.getElementById('self-btn-max').className='glyphicon glyphicon-resize-full'"
)
})
```



# 1.9 electron引入bootstrap注意


引入方法

方法1：

可通过 `npm install bootstrap`引入，`bootstrap@3`或 `bootstrap@4`下载对应版本的bootstrap。

方法2：

到bootstrap官网下载对应压缩包，至于 `node_modules`下。

引入时直接在html页面中引入

```html
<head>
    <meta charset="utf-8" />
    <script>
        window.nodeRequire = require;
        delete window.require;
        delete window.exports;
        delete window.module;
    </script>
    <script type="text/javascript" src="node_modules/jquery/dist/jquery.min.js"></script>   
    <script src="node_modules/bootstrap/dist/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="node_modules/bootstrap/dist/css/bootstrap.css">
    <title></title>
</head>
```

bootstrap依赖 `jquery`。若不在引入 `bootstrap.js`前先引入 `jquery`，将导致许多效果失效。如 `dropdown`不起作用等。



## 1.10 修改npm的代理


安装成功后，这样改

打开路径 `C:\Users\Administrator`，然后修改 `.npmrc`为 `registry=https://registry.npm.taobao.org ELECTRON_MIRROR=http://npm.taobao.org/mirrors/electron/`。这样就好了


## 1.11 npm修改源

npm config set registry https://registry.npm.taobao.org

修改后可以通过这个进行测试

npm config get registry
