#### 首次安装后wordPress上传图片问题

刚安装完的wordPress是不能上传图片的。因为上传的图片会被存到wordPress项目的`wp-content`目录下，即向这个目录下写数据。而这个目录的写权限默认是归创建了此目录的用户（所属创建了父目录的用户）所有。

但是，实际上传图片时用户是代理服务器，如此网站用Apache代理，那么在web界面访问这个目录时用户就是这个代理。而一般用户是没有写权限的。所以就需要我们手动开放目录权限。这样做：

```shell
chmod 777 wp-content #不级联授权
```

这样就有了修改`wp-content`的权限。然后，我们就可以在web界面上传一张图片，上传（操作了这个目录）之后，这个目录，还有其子目录的权限就被指定给代理服务器。

在这之后尽管可以把`wp-content`的权限恢复成默认状态

```shell
chmod 755 wp-content #不级联授权
```

但是子目录属于代理服务器的事实并没有改变，除非级联收回权力。



需要注意的是：wordPress通过web方式上传图片时会自动创建uploads文件夹到`wp-content`目录。若级联收回服务器写权限，再想授予服务器写`wp-content`的权限前应当删除上次自动创建的`uploads`目录，否则上传失败。