#### 一无所有建网站过程

一个输入域名就可访问的网站是如何建立起来的呢？这样：

首先，需要购买服务器。现在有很多云服务器提供商，如阿里巴巴的阿里云，腾讯的腾讯云等。去他们官网买个服务器，建议去买阿里云服务器，相对来说便宜。建议包年。

买到服务器后，就会得到这台服务器（计算机）在公网中的位置（IP地址）。有了IP地址，就能通过浏览器访问这台机器。其实并不能。不能的原因在于浏览器访问其它计算机的过程：

在浏览器输入域名之后，浏览器将比较这个域名是否与缓存中的某个相同，如果相同，则直接调出缓存中保存的HTML,CSS,JS等交给浏览器界面解析模块解析；如果不同，则查找本机Host文件中的域名跟IP地址的映射关系。

浏览器中输入IP地址和输入域名访问其它计算机的过程相似。都是先看缓存中是否有对应记录。不过我猜想如果 缓存中找不到对应记录，它不会再去查找本地Host文件。因为Host文件中规定某个域名与IP地址的映射关系的作用是硬性地将某个域名指向某个IP地址，即使实际上这个域名与实际IP地址并不真的互相对映。而知道了IP地址之后就相当于知道了这个计算机的实际位置（公网中的位置或私网中的位置）。或者说，域名就是这个计算机的位置名称，IP地址是“世界坐标”。位置的名称可以变，或者说知道名称并不真的确定位置在哪，而知道了路如何走就真的确定位置在哪了。从这个角度说，IP地址就相当于路径。域名就相当于要去的地点名。所以，既然知道了路径就完全没必要在本地“欺瞒”了。因此，我认为知道了IP地址就不会再查本地Host记录了。

有了IP地址就可以远程访问这个计算机，这不意味着可以通过在浏览器输入IP地址的方式访问。浏览器输IP地址访问的方式是通过Http协议访问。而刚买的服务器默认没有开放用于http协议访问的端口（80），即使开了这个端口，域名提供商（如阿里）提供的服务器安全策略也不允许通过http协议通过这个计算机的80端口访问这台计算机。需要在控制台设置允许。而配置`Mysql`服务也是如此，默认不开放3306端口，需要双设置（设置服务器，设置安全策略）。完全开放（双设置之后）了80端口后是可以通过浏览器输地址的方式访问到这台计算机的。但是开放后马上这样做，会发现浏览器页面什么都没有。这是肯定的了。因为虽然可以通过http协议连接到远程计算机，也能通过其端口，但是进到那台计算机后却没有“人”“招呼”“访问者”。结果“访问者”就“待在那”无所事事“，直到连接中断，”退出“（被撵出）计算机。所以，就需要设置一”导引者“。实际可充当这一角色的是`Apache`和`Nginx`。它们（手动安装配置）运行在被访计算机的内存中，时刻监听着80端口。发现80端口的“动静”后，就“引导”访问者到计算机指定位置。如何指定这一位置，就需要我们事先告诉“导引者”，这也就是配置`Apache`或`Nginx`的目的。而事实上，通过80端口的只是http协议，也就是说80端口只做一件事：网站访问。所以，只需把我们想要被访问的网站路径告诉`Apache`或`Nginx`，那么http的连接就能取回我们网页的信息（HTML,CSS,JS等），最终被浏览器解析，展现给访问的人。

现在就很清楚了。我们买完服务器之后，只需要进行`双设置`，上传网站，安装配置`Apache`或`Nginx`，就算完成工作了。

但是这样每次都得通过IP地址访问网站。实际上没有正规网站只是通过IP地址访问的。因此，我们还需要买域名。域名在服务器提供商那里就能买到。也建议包年。买完之后，按照提供商的要求备案，最终交给管局（政府机构）审核通过才能使用这个域名。

域名合法之后，就需要在域名提供商的DNS解析系统系统中设置域名与IP地址的对应关系。以上操作全部完成后，一个网站才算真正被建设了起来。