#### 鼠标滑轮上滚下滚事件

`xaml`中定义了一`Grid`，其结构如下：

```xml
<Grid>
  <ScrollViewer VerticalScrollBarVisibility="Hidden" HorizontalScrollBarVisibility="Hidden">
    <Canvas Background="Red" Width="500" Height="500" HorizontalAlignment="Center" VerticalAlignment="Center"></Canvas>
  </ScrollViewer>
</Grid>

```

然后添加滑轮滚动事件`ShowFuncGrid_MouseWheel`：

```xml
<Grid Grid.Column="1">
  <ScrollViewer VerticalScrollBarVisibility="Hidden" HorizontalScrollBarVisibility="Hidden">
    <Canvas MouseWheel="ShowFuncGrid_MouseWheel" Background="Red" Width="500" Height="500" HorizontalAlignment="Center" VerticalAlignment="Center"></Canvas>
  </ScrollViewer>
</Grid>
```

之后在对应的`cs`文件中添加事件：

```c#
private void ShowFuncGrid_MouseWheel(object sender, MouseWheelEventArgs e)
{
  if(e.Delta>0)
  {
 	 MessageBox.Show("鼠标滑轮上滚");
  }
  else
  {		
  	MessageBox.Show("鼠标滑轮下滚");
  }
}

```

这样就可以检测鼠标滑轮是上滑还是下滑。



注意：此事件添加到`Grid`上无效。